<?php
/*
Plugin Name: Social Auto Poster
Plugin URI: http://persianscript.ir
Description: Social Auto Poster lets you automatically post all your content to several different social networks.
Version: 1.1.0
Author: persianscript
Author URI: http://persianscript.ir
*/    

// Exit if accessed directly
include 'includes/shorteners/class.php';
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Basic Plugin Definitions 
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
if( !defined( 'wpwautoposterlevel' ) ) {
	//specify the user's role capabilites who can access this plugins settings in backend
	//for more informatioon please check  http://codex.wordpress.org/Roles_and_Capabilities
	define( 'wpwautoposterlevel','manage_options'); //administrator role can use this plugin
}
if( !defined( 'WPW_AUTO_POSTER_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_DIR', dirname( __FILE__ ) ); // plugin dir
}
if( !defined( 'WPW_AUTO_POSTER_URL' ) ) {
	define( 'WPW_AUTO_POSTER_URL', plugin_dir_url( __FILE__ ) ); // plugin url
}   
if( !defined( 'WPW_AUTO_POSTER_IMG_URL' ) ) {
	define( 'WPW_AUTO_POSTER_IMG_URL', WPW_AUTO_POSTER_URL . 'includes/images' ); // plugin image url
}   
if( !defined( 'WPW_AUTO_POSTER_ADMIN' ) ) {
	define( 'WPW_AUTO_POSTER_ADMIN', WPW_AUTO_POSTER_DIR . '/includes/admin' ); // plugin admin dir
}
if( !defined( 'WPW_AUTO_POSTER_META_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_META_DIR', WPW_AUTO_POSTER_DIR . '/includes/meta-boxes' ); // path to meta boxes
}
if( !defined( 'WPW_AUTO_POSTER_META_URL' ) ) {
	define( 'WPW_AUTO_POSTER_META_URL', WPW_AUTO_POSTER_URL . 'includes/meta-boxes' ); // path to meta boxes
}
if( !defined( 'WPW_AUTO_POSTER_SOCIAL_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_SOCIAL_DIR', WPW_AUTO_POSTER_DIR . '/includes/social/libraries' ); // path to meta boxes
}
if( !defined( 'WPW_AUTO_POSTER_TITLE_PREFIX' )) {
	define( 'WPW_AUTO_POSTER_TITLE_PREFIX', 'WPWeb' );
}
//metabox prefix
if( !defined( 'WPW_AUTO_POSTER_META_PREFIX' )) {
	define( 'WPW_AUTO_POSTER_META_PREFIX', '_wpweb_' );
}

add_action('activated_plugin','save_error');
function save_error(){
    update_option('plugin_error',  ob_get_contents());
}
/**
 * Load Text Domain
 *
 * This gets the plugin ready for translation.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_load_textdomain() {

  load_plugin_textdomain( 'wpwautoposter', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}

add_action( 'init', 'wpw_auto_poster_load_textdomain' ); 

/**
 * Activation Hook
 *
 * Register plugin activation hook.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
register_activation_hook( __FILE__, 'wpw_auto_poster_install' );

/**
 * Plugin Setup (On Activation)
 *
 * Does the initial setup, creates tables in the database and
 * stest default values for the plugin options.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_install() {

	global $wpdb;
	
	/****************** Update Old Facebook Session Data to New Start **********************/
	
	// start code to manage session from database 			
	$wpw_auto_poster_fb_sess_data = get_option( 'wpw_auto_poster_fb_sess_data' );
	
	//old facebook session data
	$old_fb_sess_data = get_option('wpweb_fb_sess_data');
	
	//check new session data empty and Old session data should not empty
	if( empty( $wpw_auto_poster_fb_sess_data ) && !empty( $old_fb_sess_data ) ) {
		
		$new_fb_sess_data =	array();
		
		foreach ( $old_fb_sess_data as $key => $value  ) {
			//check wpweb is exist in key or not
			if( strpos( $key, 'wpweb' ) !== FALSE ) {
				$newkey = str_replace( 'wpweb', 'wpw_auto_poster', $key );
			} else {
				$newkey = $key;
			}
			$new_fb_sess_data[$newkey] = $value;
		}
		
		//update old session data to new session data
		update_option( 'wpw_auto_poster_fb_sess_data', $new_fb_sess_data );
		
		//get session data from options
		$wpw_auto_poster_fb_sess_upd = get_option( 'wpw_auto_poster_fb_sess_data' );
		
		//check new data is successfully imported
		if( !empty( $wpw_auto_poster_fb_sess_upd ) ) {
			//delete old options data
			delete_option( 'wpweb_fb_sess_data' );
		}
	} //check session data is empty
	
	/****************** Update Old Facebook Session Data to New End **********************/
	
	/****************** Update Old Widget Pack Data to New Start **********************/
	
	//get widget pack options
	$new_widget_pack_opt = get_option( 'wpw_auto_poster_widget_pack' );
	
	//old widget pack options
	$old_widget_pack_opt = get_option( 'wpweb_fb_widget_pack' );
		
	//check new options are empty and old options not empty
	if( empty( $wpw_auto_poster_widget_pack_opt ) && !empty( $old_widget_pack_opt ) ) {
	
		//update new widget pack options 
		update_option( 'wpw_auto_poster_widget_pack', $old_widget_pack_opt );
		
		//get widget pack options
		$new_widget_pack_opt_upd = get_option( 'wpw_auto_poster_widget_pack' );
		
		//check new data is successfully imported
		if( !empty( $new_widget_pack_opt_upd ) ) {
			//delete old options data
			delete_option( 'wpweb_fb_widget_pack' );
		}
	}
	
	/****************** Update Old Widget Pack Data to New End **********************/
	
	//get plugin options from database
	$wpw_auto_poster_options = get_option( 'wpw_auto_poster_options' );
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//check auto poster options is empty or not
	if( empty( $wpw_auto_poster_options ) ) {
		
		//set default settings of social auto poster
		wpw_auto_posting_default_settings();
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0' );
	}
	
	if( $wpw_auto_poster_set_option == '1.0' ) { //check set option for plugin is set 1.0
		
		// future code will be done here
		
	} //check plugin set option value is 1.0
	
}

/**
 * Deactivation Hook
 *
 * Register plugin deactivation hook.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
register_deactivation_hook( __FILE__, 'wpw_auto_poster_uninstall' );

/**
 * Plugin Setup (On Deactivation)
 *
 * Deletes all the plugin options if the user has
 * set the option to do that.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_uninstall() {

	global $wpdb;
	
	$wpw_auto_poster_options = get_option( 'wpw_auto_poster_options' );
	
	if( isset( $wpw_auto_poster_options['delete_options'] ) && !empty( $wpw_auto_poster_options['delete_options'] ) && $wpw_auto_poster_options['delete_options'] == '1') {
		
		//facebook posting class
		$fbposting = new Wpw_Auto_Poster_FB_Posting();
		//linkedin posting class
		$liposting = new Wpw_Auto_Poster_Li_Posting();
		
		//facebook session reset
		$fbposting->wpw_auto_poster_fb_reset_session();
		//linkedin session reset
		$liposting->wpw_auto_poster_li_reset_session();
		
		//delete auto poster options
		delete_option( 'wpw_auto_poster_options' );
		//deleter facebook session data
		delete_option( 'wpw_auto_poster_fb_sess_data' );
		//delete linkedin session data
		delete_option( 'wpw_auto_poster_li_sess_data' );
		//delete set option data
		delete_option( 'wpw_auto_poster_set_option' );
		//delete widget pack data 
		delete_option( 'wpw_auto_poster_widget_pack' );
	}
}

/**
 * Default Settings
 *
 * Defining the default values for the plugin options.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_posting_default_settings() {

	//default values
	$fb_enable_autopost = $fb_app_id = $fb_app_secret = $prevent_linked = $fb_prevent_meta = '';
	$fb_custom_message = __( 'New blog post:', 'wpwautoposter' ) . '  {title} - {link}';
	$post_types_for_fb = array();
	$fb_enable_for_types = array();
	//old options data
	$old_options_data = get_option( 'wpweb_fb_options' );
	
	//cehck old option data should not empty
	if( !empty( $old_options_data ) ) {
		
		$fb_enable_autopost = isset( $old_options_data['allow_autopost'] )	&& !empty( $old_options_data['allow_autopost'] )
								?	'1'	:	'';
		$fb_app_id 			= isset( $old_options_data['fb_app_id'] )		?	$old_options_data['fb_app_id'] 			: '';
		$fb_app_secret 		= isset( $old_options_data['fb_app_secret'] )	?	$old_options_data['fb_app_secret'] 		: '';
		$prevent_linked 	= isset( $old_options_data['prevent_linked_accounts_access'] ) && !empty( $old_options_data['prevent_linked_accounts_access'] )
								?	'1'	:	'';
		$fb_prevent_meta 	= isset( $old_options_data['prevent_post_metabox'] ) && !empty( $old_options_data['prevent_post_metabox'] )
								?	'1'	:	'';
		if ( isset( $old_options_data['custom_status_msg'] ) && !empty( $old_options_data['custom_status_msg'] ) ) {
			$searcharr 			=	array( '%title%', '%link%' );
			$replacearr			=	array( '{title}', '{link}' );
			$fb_custom_message	=	str_replace( $searcharr, $replacearr, $old_options_data['custom_status_msg'] );
		}
		
		//get all post types for
		$types = get_post_types( array( 'public'=>true ), 'objects' );
		$types = is_array( $types ) ? $types : array();
		
		//loop to get method is stored for post type or not
		foreach ($types as $type ) {
			
			$label = @$type->labels->name ? $type->labels->name : $type->name;
			if( $label == 'Media' || $label == 'media' ) continue; // skip media
			
			//if old autoposting is enable then make new all types selected
			if( !empty( $fb_enable_autopost ) ) {
				$fb_enable_for_types[] = $type->name;
			}
			
			//check posting method is stored in old options or not
			if( isset( $old_options_data['wpweb_fb_type_'.$type->name.'_method'] ) ) {
			 	$post_types_for_fb['fb_type_'.$type->name.'_method'] = $old_options_data['wpweb_fb_type_'.$type->name.'_method'];
			}
			//check posting user is set in old option or not
			if( isset( $old_options_data['wpweb_fb_type_'.$type->name.'_user'] ) ) {
			 	$post_types_for_fb['fb_type_'.$type->name.'_user']	= $old_options_data['wpweb_fb_type_'.$type->name.'_user'];
			} 
		} //end foreach loop
		
		//delete options old plugin option data
		delete_option( 'wpweb_fb_options' );
		
	} //check old options dat is empty or not
	 
	$wpw_auto_poster_options = array(
		//General Settings
		'delete_options'					=> '',
		'url_shortener'						=> 'wordpress',
		'bitly_username'					=> '',
		'bitly_api_key'						=> '',
		//Facebook Settings
		'enable_facebook'					=> $fb_enable_autopost,
		'enable_facebook_for'				=> $fb_enable_for_types,
		'fb_app_id'							=> $fb_app_id,
		'fb_app_secret'						=> $fb_app_secret,
		'prevent_linked_accounts_access'	=> $prevent_linked,
		'prevent_post_metabox'				=> $fb_prevent_meta,
		'fb_custom_img'						=> '',
		'custom_status_msg'					=> $fb_custom_message,
		//Twitter Settings
		'enable_twitter'					=> '',
		'enable_twitter_for'				=> '',
		'twitter_consumer_key'				=> '',
		'twitter_consumer_secret'			=> '',
		'twitter_oauth_token'				=> '',
		'twitter_oauth_secret'				=> '',
		'tw_tweet_template'					=> 'title_link',
		'tw_custom_tweet_template'			=> '',
		//LinkedIn Settings
		'enable_linkedin'					=> '',
		'enable_linkedin_for'				=> '',
		'linkedin_app_id'					=> '',
		'linkedin_app_secret'				=> '',
		'li_post_image'						=> '',
	);
		
	$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $post_types_for_fb  );
	update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
}
/**
 * Settings Link
 *
 * Adds a settings link to the plugin list.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_add_settings_link( $links, $file ) {

	static $this_plugin;
	if ( !$this_plugin ) $this_plugin = plugin_basename( __FILE__ );
	if ( $file == $this_plugin ) {
		$settings_link = '<a href="edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings">' . __( 'Settings', 'wpwautoposter' ) . '</a>';
		array_unshift($links, $settings_link);
	}
	return $links;
}

add_filter( 'plugin_action_links', 'wpw_auto_poster_add_settings_link', 10, 2 );

/**
 * Start Session
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_sessionset() {

	global $wpdb, $wpw_auto_poster_message_stack;	

	if( !session_id() ) { 
		@session_start();
	}

	$settingspage = add_query_arg( array( 'page' => 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) );
	
	$wpw_auto_poster_fb_sess_data = get_option( 'wpw_auto_poster_fb_sess_data' );	
	
	if( !empty( $wpw_auto_poster_fb_sess_data ) &&  WPW_AUTO_POSTER_FB_APP_ID != '' ) {	
		if( ! isset( $_SESSION['wpweb_fb_user_id'] ) ) { 
			$_SESSION['wpweb_fb_user_cache'] 	= $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_cache'];
			$_SESSION['wpweb_fb_user_id'] 		= $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_id'];
			$_SESSION['wpweb_fb_user_accounts'] = $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts'];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS1] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS1];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS2] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS2];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS3] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS3];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS4] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS4];
		}
	}
	
	if( isset( $_REQUEST['fb_reset_user'] ) && $_REQUEST['fb_reset_user'] == '1' ) {
		$fbposting = new Wpw_Auto_Poster_FB_Posting();
		$fbposting->wpw_auto_poster_fb_reset_session();
		$wpw_auto_poster_message_stack->add_session( 'poster-selected-tab', 'facebook' );
		wp_redirect( $settingspage );
		exit;	
	}
	
	//Reset LinkedIn User Data
	if( isset( $_GET['li_reset_user'] ) && $_GET['li_reset_user'] == '1' ) {
		$liposting = new Wpw_Auto_Poster_Li_Posting();
		$liposting->wpw_auto_poster_li_reset_session();
		$wpw_auto_poster_message_stack->add_session( 'poster-selected-tab', 'linkedin' );
		wp_redirect( $settingspage );
		exit;	
	}
	
}

global $wpw_auto_poster_options, $wpw_auto_poster_widget_pack, $wpw_auto_poster_message_stack, $wpw_auto_poster_model,
		$wpw_auto_poster_fb_posting, $wpw_auto_poster_tw_posting, $wpw_auto_poster_li_posting,
		$wpw_auto_poster_scripts, $wpw_auto_poster_render, $wpw_auto_poster_admin;
		
/**
 * Include different files needed for our plugin.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */  
require_once( WPW_AUTO_POSTER_DIR . '/includes/wpw-auto-poster-misc-functions.php' ); // plugin options class
$wpw_auto_poster_options = wpw_auto_poster_settings();
$wpw_auto_poster_widget_pack = get_option('wpw_auto_poster_widget_pack');
wpw_auto_poster_initialize();

require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-message-stack.php'); // message class, handles the messages after review submission
$wpw_auto_poster_message_stack = new Wpw_Auto_Poster_Message_Stack();

require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-model.php' ); // plugin model class
$wpw_auto_poster_model = new Wpw_Auto_Poster_Model();

//facebook posting class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-fb-posting.php' ); // fan page posting class
$wpw_auto_poster_fb_posting = new Wpw_Auto_Poster_FB_Posting();

//twitter posting class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-tw-posting.php' ); // fan page posting class
$wpw_auto_poster_tw_posting = new Wpw_Auto_Poster_TW_Posting();

//linkein posting class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-li-posting.php' ); // fan page posting class
$wpw_auto_poster_li_posting = new Wpw_Auto_Poster_Li_Posting();

//add action init for making user to logged in linkedin
add_action( 'init', array( $wpw_auto_poster_li_posting, 'wpw_auto_poster_li_user_logged_in' ) );

//Metabox file to handle metaboxes
require_once( WPW_AUTO_POSTER_META_DIR . '/wpw-auto-poster-meta-box.php' ); // meta box for posting 

require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-scripts.php' ); // including the java script and css files
$wpw_auto_poster_scripts = new Wpw_Auto_Posting_Scripts();
$wpw_auto_poster_scripts->add_hooks();

//Render class to handles most of html design for plugin
require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-renderer.php' );
$wpw_auto_poster_render = new Wpw_Auto_Poster_Renderer();

require_once( WPW_AUTO_POSTER_ADMIN . '/class-wpw-auto-poster-admin.php' ); // including plugin admin functions
$wpw_auto_poster_admin = new Wpw_Auto_Posting_AdminPages();
$wpw_auto_poster_admin->add_hooks();

//check dashboard permission allowed or not
if( isset( $wpw_auto_poster_widget_pack['dashboard_permissions_allowed'] ) 
	&& $wpw_auto_poster_widget_pack['dashboard_permissions_allowed'] == '1' ) {
	//show dashboard widget
	add_action('wp_dashboard_setup', 'wpw_auto_poster_dashboard_setup' );
}

/**
 * Register All Widgets of plugin
 *
 * Handle to register all widgets of plugin
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
if( isset( $wpw_auto_poster_widget_pack['albums_allowed'] ) && $wpw_auto_poster_widget_pack['albums_allowed'] == '1' ) {

	require_once ( WPW_AUTO_POSTER_DIR . '/includes/widgets/class-wpw-auto-poster-widget-albums.php' );

	add_action('widgets_init', create_function('', "register_widget('Wpw_Auto_Poster_Fb_WidgetAlbums');"));

}

if( isset( $wpw_auto_poster_widget_pack['events_allowed'] ) && $wpw_auto_poster_widget_pack['events_allowed'] == '1' ) {
	
	require_once ( WPW_AUTO_POSTER_DIR . '/includes/widgets/class-wpw-auto-poster-widget-events.php' );

	add_action('widgets_init', create_function('', "register_widget('Wpw_Auto_Poster_Fb_WidgetEvents');"));

}

if( isset( $wpw_auto_poster_widget_pack['facepile_allowed'] ) && $wpw_auto_poster_widget_pack['facepile_allowed'] == '1' ) {

	require_once ( WPW_AUTO_POSTER_DIR . '/includes/widgets/class-wpw-auto-poster-widget-facepile.php' );

	add_action('widgets_init', create_function('', "register_widget('Wpw_Auto_Poster_Fb_WidgetFacepile');"));

}

if( isset( $wpw_auto_poster_widget_pack['likebox_allowed'] ) && $wpw_auto_poster_widget_pack['likebox_allowed'] == '1' ) {

	require_once ( WPW_AUTO_POSTER_DIR . '/includes/widgets/class-wpw-auto-poster-widget-likebox.php' );

	add_action('widgets_init', create_function('', "register_widget('Wpw_Auto_Poster_Fb_WidgetLikebox');"));

}

if( isset( $wpw_auto_poster_widget_pack['recommendations_allowed'] ) && $wpw_auto_poster_widget_pack['recommendations_allowed'] == '1' ) {

	require_once ( WPW_AUTO_POSTER_DIR . '/includes/widgets/class-wpw-auto-poster-widget-recommendations.php' );

	add_action('widgets_init', create_function('', "register_widget('Wpw_Auto_Poster_Fb_WidgetRecommendations');"));

}

if( isset( $wpw_auto_poster_widget_pack['activityfeed_allowed'] ) && $wpw_auto_poster_widget_pack['activityfeed_allowed'] == '1' ) {

	require_once ( WPW_AUTO_POSTER_DIR . '/includes/widgets/class-wpw-auto-poster-widget-activityfeed.php' );

	add_action('widgets_init', create_function('', "register_widget('Wpw_Auto_Poster_Fb_WidgetActivityFeed');"));

}

/**
 * Register Dashboard widget
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_dashboard_setup() { 

	global $wpw_auto_poster_fb_posting;

	wp_add_dashboard_widget( 'wpw_auto_poster_dashboard_permissions_widget', __( 'Social Auto Poster Permissions','wpwautoposter'), array( $wpw_auto_poster_fb_posting, 'wpw_auto_poster_dashboard_permissions_widget' ) );

}

//session set
add_action( 'init','wpw_auto_poster_sessionset' );