<?php
global $cjaddons_options;
$file_name = str_replace( '.php', '', basename( __FILE__ ) );
$cjaddons_options[ $file_name ] = array(
	array(
		'type' => 'heading',
		'id' => 'cjsupport_configuration_heading',
		'label' => __( 'App Setup', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'hidden',
		'id' => 'cjsupport-migration',
		'label' => __( 'Migration', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 0,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'hidden',
		'id' => 'cjsupport_imap_accounts',
		'label' => __( 'Migration', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 0,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'page',
		'id' => 'cjsupport_page_app',
		'label' => __( 'Standalone App Page', 'addon-supportezzy' ),
		'info' => __( 'Specify app page where the support system will run.', 'addon-supportezzy' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_show_departments',
		'label' => __( 'Enable Departments', 'addon-supportezzy' ),
		'info' => __( 'Enable departments on ticket pages and forms.', 'addon-supportezzy' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_show_products',
		'label' => __( 'Enable Products', 'addon-supportezzy' ),
		'info' => __( 'Enable products on ticket pages and forms.', 'addon-supportezzy' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_show_faqs',
		'label' => __( 'Enable FAQs', 'addon-supportezzy' ),
		'info' => __( 'You can choose to enable or disable FAQs on the app.', 'addon-supportezzy' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'nav_menu',
		'id' => 'cjsupport_nav_menu',
		'label' => __( 'Additional Menu Links', 'addon-supportezzy' ),
		'info' => __( 'Select menu to extend main navigation links.', 'addon-supportezzy' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => ''
	),
	array(
		'type' => 'group',
		'id' => 'cjsupport_footer_widget',
		'group' => 'group-name',
		'label' => esc_attr__( 'Include app on all pages?', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'no',
		'options' => array('yes' => __( 'Yes', 'addon-supportezzy' ), 'no' => __( 'No', 'addon-supportezzy' )), // array in case of dropdown, checkbox and radio buttons
		'options_disable_blank' => true,
		'items' => array(
			'yes' => array(
				'button_icon' => array(
					'id' => 'button_icon',
					'type' => 'dropdown',
					'label' => __( 'Button Icon', 'addon-supportezzy' ),
					'info' => '',
					'default' => 'fa-life-saver',
					'params' => array(
						'class' => 'selectize'
					),
					'options' => $this->fontAwesomeIconsArray(), // array in case of dropdown, checkbox and radio buttons
				),
				'button_text' => array(
					'id' => 'button_text',
					'type' => 'text',
					'label' => __( 'Button Text', 'addon-supportezzy' ),
					'info' => __('HTML is not allowed in this field.', 'cjaddons'),
					'default' => __( 'Click here for Support', 'addon-supportezzy' ),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				'button_class' => array(
					'id' => 'button_class',
					'type' => 'dropdown',
					'label' => __('Button Class', 'cjaddons'),
					'info' => sprintf(__('<a href="%s" target="_blank">Click here</a> to change colors for these classes.', 'cjaddons'), $this->callbackUrl('config', 'core-sass', 'cjaddons')),
					'params' => array(
						'class' => 'selectize'
					),
					'default' => 'primary',
					'options' => array(
						'primary' => __('Primary', 'cjaddons'),
						'success' => __('Success', 'cjaddons'),
						'warning' => __('Warning', 'cjaddons'),
						'danger' => __('Danger', 'cjaddons'),
						'info' => __('Info', 'cjaddons'),
					), // array in case of dropdown, checkbox and radio buttons
				)
			),
			'no' => array(),
		)
	),
	array(
		'type' => 'sub-heading',
		'id' => 'cjsupport_company_settings_headings',
		'label' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __( 'Company Settings', 'cjsupport' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_company_name',
		'label' => __( 'Company Name', 'cjsupport' ),
		'info' => __( 'This will be used in all communication and branding.', 'cjsupport' ),
		'suffix' => '',
		'prefix' => '',
		'default' => get_bloginfo( 'name' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_company_email',
		'label' => __( 'Company email', 'cjsupport' ),
		'info' => __( 'All emails will be sent via this email address.', 'addon-supportezzy' ),
		'suffix' => '',
		'prefix' => '',
		'default' => get_option( 'admin_email' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'file',
		'id' => 'cjsupport_company_logo',
		'label' => __( 'Company logo (Primary)', 'cjsupport' ),
		'info' => __( 'Upload your company logo. If you do not upload any image, your company name will be displayed instead.', 'cjsupport' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_logo_type',
		'label' => __( 'Logo Type?', 'cjsupport' ),
		'info' => __( 'Select what type of logo you would like to use on SupportEzzy App.', 'cjsupport' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'text',
		'options' => array(
			'text' => __( 'Use Text Logo', 'addon-supportezzy' ),
			'image' => __( 'Use Image Logo', 'addon-supportezzy' ),
		), // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'sub-heading',
		'id' => 'cjsupport_page_setup_heading',
		'label' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __( 'Default Links and Pages', 'cjsupport' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_home_url',
		'label' => __( 'Homepage link', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => site_url(),
		'params' => array(
			'placeholder' => 'http://'
		),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_login_url',
		'label' => __( 'Login Page Url', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => site_url( 'wp-login.php' ),
		'params' => array(
			'placeholder' => 'http://'
		),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_edit_profile_url',
		'label' => __( 'Edit Profile Page Url', 'addon-supportezzy' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => admin_url( 'profile.php' ),
		'params' => array(
			'placeholder' => 'http://'
		),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
);