<?php
global $cjaddons_options, $cjaddons_item_vars;
$helpers = cjaddons_supportezzy_helpers::getInstance();
$file_name = str_replace( '.php', '', basename( __FILE__ ) );
$cjaddons_options[ $file_name ] = array(
	array(
		'type' => 'heading',
		'id' => 'cjsupport-tickets-configuration-heading',
		'label' => __( 'Tickets Configuration', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_user_must_login',
		'label' => __( 'User must login to create ticket?', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays('yes-no'), // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'group',
		'id' => 'cjsupport_ticket_assignment',
		'group' => 'cjsupport_ticket_assignment',
		'label' => esc_attr__( 'Ticket Assignment', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'agent_with_least_tickets',
		'options' => array(
			'keep_unassigned' => __( 'Let agents or admin assign the tickets.', 'cjaddons' ),
			'assign_to_one_agent' => __( 'Assign all tickets to one agent and he/she will then reassign.', 'cjaddons' ),
			'taxonomy_assignment' => __( 'Assign to next available agent based on department and product selected by client.', 'cjaddons' ),
			'agent_with_least_tickets' => __( 'Assign to agent with least tickets based on department and product.', 'cjaddons' ),
		), // array in case of dropdown, checkbox and radio buttons
		'options_disable_blank' => true,
		'items' => array(
			'keep_unassigned' => array(),
			'taxonomy_assignment' => array(),
			'agent_with_least_tickets' => array(),
			'assign_to_one_agent' => array(
				'agent_id' => array(
					'id' => 'agent_id',
					'type' => 'dropdown',
					'label' => __( 'Select an agent', 'cjaddons' ),
					'info' => '',
					'default' => '',
					'params' => array(
						'class' => 'selectize'
					),
					'options' => $helpers->supportAgentsArray(),
				)
			),
		)
	),
	array(
		'type' => 'repeatable',
		'disable_new' => true,
		'id' => 'cjsupport-tickets-priority',
		'label' => __( 'Tickets Priority', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => array(
			'6' => __( 'High', 'cjaddons' ),
			'12' => __( 'Important', 'cjaddons' ),
			'24' => __( 'Normal', 'cjaddons' ),
			'48' => __( 'Low', 'cjaddons' ),
		),
		'default_placeholders' => array(
			'6' => __('Must be replied within 6 hours.', 'cjaddons'),
			'12' => __('Must be replied within 12 hours.', 'cjaddons'),
			'24' => __('Must be replied within 24 hours.', 'cjaddons'),
			'48' => __('Must be replied within 48 hours.', 'cjaddons'),
		),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_allowed_file_types',
		'label' => __( 'Allowed File Types', 'cjaddons' ),
		'info' => sprintf( __( 'Specify file extensions allowed as an attachment.<br>Make sure the extensions are allowed by WordPress as listed on <a href="%s" target="_blank">this page</a>.', 'cjaddons' ), 'https://codex.wordpress.org/Uploading_Files' ),
		'suffix' => '',
		'prefix' => '',
		'params' => array(
			'placeholder' => 'jpg|png|gif'
		),
		'default' => 'jpg|png|gif|pdf|txt|zip',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'number',
		'id' => 'cjsupport_auto_close_ticket',
		'label' => __( 'Auto Close Tickets after', 'cjaddons' ),
		'info' => __( 'System will auto close ticket if no response from client for specified days.', 'cjaddons' ),
		'suffix' => 'days',
		'prefix' => '',
		'default' => '2',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'sub-heading',
		'id' => 'cjsupport_google_recaptcha_heading',
		'label' => '',
		'info' => __( 'Specify Site Key and Secret Key to use Google reCaptcha on New Ticket form.', 'cjaddons' ),
		'prefix' => '',
		'default' => __('Google reCaptcha', 'cjaddons'),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_google_recaptcha_key',
		'label' => __('Site Key', 'cjaddons'),
		'info' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_google_recaptcha_secret',
		'label' => __('Secret Key', 'cjaddons'),
		'info' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
);

$form_builder_installed = 0;
$form_builder_forms = array();
if( isset( $cjaddons_item_vars['module_info']['addon-form-builder'] ) && is_array( $cjaddons_item_vars['module_info']['addon-form-builder'] ) ) {
	$form_builder_installed = 1;
	$args = array(
		'posts_per_page' => - 1,
		'post_type' => 'cj-custom-forms',
		'post_status' => 'publish',
		'orderby' => 'post_title',
		'order' => 'ASC',
	);
	$form_builder_forms = $this->getPosts( $args, 'ID', 'post_title' );
}
if( empty( $form_builder_forms ) ) {
	$form_builder_forms[0] = __( 'Form Builder Addon is not installed.', 'cjaddons' );
}

$cjaddons_options[ $file_name ]['cjsupport_form_builder_heading'] = array(
	'id' => 'cjsupport_form_builder_heading',
	'type' => ($form_builder_installed) ? 'sub-heading' : 'hidden',
	'label' => '',
	'info' => '',
	'default' => __( 'Additional Form Fields', 'cjaddons' ),
	'options' => '', // array in case of dropdown, checkbox and radio buttons
);
$cjaddons_options[ $file_name ]['cjsupport_form_builder_form_id'] = array(
	'id' => 'cjsupport_form_builder_form_id',
	'type' => ($form_builder_installed) ? 'dropdown' : 'hidden',
	'label' => __( 'Form Builder Form ID', 'cjaddons' ),
	'info' => '',
	'default' => 0,
	'options' => $form_builder_forms, // array in case of dropdown, checkbox and radio buttons
);