<?php
global $cjaddons_options;
$file_name = str_replace( '.php', '', basename( __FILE__ ) );
$ticket_variables_content = '';
$variables = array(
	'ticket_variables_html' => '<div class="mt-0 mb-20 text-bold fs-18">Ticket Variables</div>',
	'TICKET_UID' => __( 'Renders ticket unique identifier.', 'cjaddons' ),
	'TICKET_SUBJECT' => __( 'Renders ticket title.', 'cjaddons' ),
	'TICKET_COMMENT' => __( 'Renders ticket content.', 'cjaddons' ),
	'TICKET_URL' => __( 'Renders ticket url.', 'cjaddons' ),
	'TICKET_DEPARTMENT_NAME' => __( 'Renders ticket department name.', 'cjaddons' ),
	'TICKET_PRODUCT_NAME' => __( 'Renders ticket product name.', 'cjaddons' ),
	'TICKET_CLIENT_NAME' => __( 'Renders ticket client full name.', 'cjaddons' ),
	'TICKET_AGENT_NAMES' => __( 'Renders ticket agents full name.', 'cjaddons' ),
	'comment_variables_html' => '<hr><div class="mt-10 mb-20 text-bold fs-18">Comment Variables</div>',
	'COMMENT_CONTENT' => __( 'Renders ticket content.', 'cjaddons' ),
	'COMMENT_AUTHOR_NAME' => __( 'Renders comment author display name.', 'cjaddons' ),
);
foreach( $variables as $key => $value ) {
	if( strpos($key, '_html') > 0 ) {
		$ticket_variables_content .= $value;
	} else {
		$ticket_variables_content .= '<div class="mb-15"><code data-clipboard-text="%%' . $key . '%%" data-clipboard-confirmation="' . __( 'Copied to clipboard!', 'cjaddons' ) . '">%%' . $key . '%%</code><br><span class="inline-block mt-3 opacity-50">' . $value . '</span></div>';
	}
}

$cjaddons_options[ $file_name ] = array(
	array(
		'type' => 'heading',
		'id' => 'cjsupport-email-variables-heading',
		'label' => __( 'Dynamic Variables', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'info',
		'id' => 'cjsupport-email-variables-info',
		'label' => __( 'Variables', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $ticket_variables_content,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
);