<?php
global $cjaddons_options;
$file_name = str_replace( '.php', '', basename( __FILE__ ) );
$sync_products_url = $this->queryString( $this->callbackUrl( 'addon-supportezzy', 'cjsupport-integration-envato' ) ) . 'envato-sync=products';

$button_field_type = ($this->savedOption( 'cjsupport_envato_username' ) == '' || $this->savedOption( 'cjsupport_envato_token' ) == '') ? 'hidden' : 'info';

$cjaddons_options[ $file_name ] = array(
	array(
		'type' => 'heading',
		'id' => 'cjsupport-envato',
		'label' => __( 'Envato Integration', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_envato_username',
		'label' => __( 'Envato Username', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'password',
		'id' => 'cjsupport_envato_token',
		'label' => __( 'Access Token', 'cjaddons' ),
		'info' => sprintf( __( '<a href="%s" target="_blank">Click here</a> to create a personal access token with following scopes:<br><span class="block mt-5 mb-0 color-dark">1. View your item\'s sales history.</span>', 'cjaddons' ), 'https://build.envato.com/create-token/' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => $button_field_type,
		'id' => 'cjsupport_envato_sync_products',
		'label' => __( 'Sync Products', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '<a href="' . $sync_products_url . '" class="button is-info">' . __( 'Sync Envato Products', 'cjaddons' ) . '</a>',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_verify_envato_licence_code',
		'label' => __( 'Verify Envato License Code', 'cjaddons' ),
		'info' => __( 'If Yes, Users will be asked to verify their purchase code for Envato product tickets.<br>System will also display important information fetched from Envato site under ticket information.', 'cjaddons' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays( 'yes-no' ),
	),
);