<?php
global $cjaddons_options;
$file_name = str_replace( '.php', '', basename( __FILE__ ) );

$intro = sprintf(__('You can use One Signal Push Notifications service which is completely free. <br>
			Check out these links to setup One Signal App for your website.
			<a href="%s" target="_blank">Web Push SDK Setup (HTTP)</a>, 
			<a href="%s" target="_blank">Web Push SDK Setup (HTTPS)</a><br>
			There\'s no need to add any code to your website, just provide the information below after you create an One Signal App.
			', 'cjaddons'),'https://documentation.onesignal.com/docs/web-push-sdk-setup-http', 'https://documentation.onesignal.com/docs/web-push-sdk-setup-https');


$cjaddons_options[ $file_name ] = array(
	array(
		'type' => 'heading',
		'id' => 'cjsupport-one-signal',
		'label' => __( 'Push Notifications', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'info-full',
		'id' => 'cjsupport-one-signal-intro',
		'label' => __( 'Setup Instructions', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $intro,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'sub-heading',
		'id' => 'cjsupport-one-signal-setup',
		'label' => __( 'One Signal Setup', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_one_signal_status',
		'label' => __( 'Push Notifications', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'enable',
		'options' => $this->arrays('enable-disable'), // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_one_signal_app_id',
		'label' => __( 'APP ID', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_one_signal_api_key',
		'label' => __( 'API KEY', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_one_signal_auto_register',
		'label' => __( 'Enable auto registration?', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays('yes-no'),
	),
	array(
		'type' => 'sub-heading',
		'id' => 'cjsupport-one-signal-notify-button',
		'label' => __( 'Notification Button', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_one_signal_notify_button_status',
		'label' => __( 'Show notification button', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays('yes-no'),
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_one_signal_notify_button_size',
		'label' => __( 'Notifications button size', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'medium',
		'options' => array(
			'small' => __('Small', 'cjaddons'),
			'medium' => __('Medium', 'cjaddons'),
			'large' => __('Large', 'cjaddons'),
		),
	),
	array(
		'type' => 'dropdown',
		'id' => 'cjsupport_one_signal_notify_button_credits',
		'label' => __( 'Show credits?', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->arrays('yes-no'),
	),
	array(
		'type' => 'sub-heading',
		'id' => 'cjsupport-one-signal-messages',
		'label' => __( 'Default Messages', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'text',
		'id' => 'cjsupport_one_signal_action_message',
		'label' => __( 'Action Message', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __('We would like to show you notifications for updates on your support tickets and tasks.', 'cjaddons'),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
	array(
		'type' => 'textarea',
		'id' => 'cjsupport_one_signal_welcome_message',
		'label' => __( 'Welcome Notification Message', 'cjaddons' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __('Thank you for subscribing!', 'cjaddons'),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	),
);