<?php
if( ! class_exists( 'cjaddons_rest_cjsupport_faqs' ) ) {
	class cjaddons_rest_cjsupport_faqs {

		public $helpers, $module_dir, $routes, $api_url, $module_info;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->module_info = $this->helpers->moduleInfo( basename( $this->helpers->module_dir ) );
			$this->api_url = '';
			if( function_exists( 'using_index_permalinks' ) ) {
				$this->api_url = rest_url( 'cjaddons' ) . '/';
			}
			$this->routes = array(
				'cjsupport-faqs-categories' => array(
					'endpoint' => $this->module_info['module_id'] . '/faqs-categories',
					'name' => sprintf( __( '%s Login', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'getFaqCategories'), // callback function
					),
					'permissions' => function ( $request ) {
						return true;
						/*$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );
						return ( ! empty( $user )) ? true : false;*/
					},
				),
				'cjsupport-faqs' => array(
					'endpoint' => $this->module_info['module_id'] . '/faqs',
					'name' => sprintf( __( '%s Login', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'getFaqs'), // callback function
					),
					'permissions' => function ( $request ) {
						return true;
						/*$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );
						return ( ! empty( $user )) ? true : false;*/
					},
				),
				'cjsupport-faq' => array(
					'endpoint' => $this->module_info['module_id'] . '/faq',
					'name' => sprintf( __( '%s Ticket', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'faq'), // callback function
					),
					'permissions' => function ( $request ) {
						return true;
						/*$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );
						return ( ! empty( $user )) ? true : false;*/
					},
				),
			);
			add_filter( 'cjaddons_register_api_route', array($this, 'registerRoute') );
		}

		public function registerRoute( $routes ) {
			$routes = array_merge( $routes, $this->routes );

			return $routes;
		}

		public function getFaqCategories( $request ) {
			$categories = $this->helpers->getTerms( 'cjsupport_faq_category' );
			$data = $categories;
			if( isset( $request['include_posts'] ) && $request['include_posts'] == 1 ) {
				foreach( $categories as $key => $category ) {
					$query_args = array(
						'post_type' => 'cjsupport_faqs',
						'posts_per_page' => - 1,
						'orderby' => 'post_date',
						'order' => 'DESC',
						'tax_query' => array(
							array(
								'taxonomy' => 'cjsupport_faq_category',
								'field' => 'slug',
								'terms' => $category['slug'],
							)
						),
					);
					$posts = get_posts( $query_args );
					if( ! empty( $posts ) ) {
						foreach( $posts as $p_key => $post ) {
							$post_info = $this->helpers->postInfo( $post->ID );
							$data[ $category['term_id'] ]['posts'][] = $post_info;
						}
					}
				}
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function getFaqs( $request ) {
			$data = array();
			$query_args = array(
				'post_type' => 'cjsupport_faqs',
				'posts_per_page' => - 1,
				'orderby' => 'post_date',
				'order' => 'DESC',
			);
			if( isset( $request['query'] ) && is_array( $request['query'] ) && ! empty( $request['query'] ) ) {
				foreach( $request['query'] as $k => $v ) {
					$query_args[ $k ] = $v;
				}
			}

			$query_args['paged'] = (isset( $query_args['paged'] )) ? $query_args['paged'] : 1;
			$posts = array();
			$data['query_args'] = $query_args;
			$the_query = new WP_Query( $query_args );
			if( $the_query->have_posts() ) {
				$count = - 1;
				while( $the_query->have_posts() ) {
					$count ++;
					$the_query->the_post();
					global $post;
					$posts[ $count ] = $this->helpers->postInfo( $post->ID );
					$posts[ $count ]['post_content'] = wpautop( $posts[ $count ]['post_content'] );
				}
				if( is_array( $posts ) && ! empty( $posts ) ) {
					$data['posts'] = $posts;
					$data['query_args'] = $query_args;
					$data['post_count'] = $the_query->post_count;
					$data['total_posts'] = (int) $the_query->found_posts;

					$data['pagination'] = array();
					// pagination data
					$total_pages = $the_query->max_num_pages;
					$current_page = (int) $the_query->query['paged'];
					$next_page = $the_query->query['paged'] + 1;
					$previous_page = $the_query->query['paged'] - 1;
					if( $next_page > $total_pages ) {
						$next_page = null;
					}
					if( $previous_page <= 0 ) {
						$previous_page = null;
					}
					$data['pagination']['total_pages'] = $total_pages;
					$data['pagination']['current_page'] = $current_page;
					$data['pagination']['next_page'] = $next_page;
					$data['pagination']['previous_page'] = $previous_page;
				}

				wp_reset_postdata();
			}

			return $this->helpers->apiResponse( $request, $data );
		}

	}

	cjaddons_rest_cjsupport_faqs::getInstance();
}