<?php
if( ! class_exists( 'cjaddons_supportezzy_api_module_info' ) ) {
	class cjaddons_supportezzy_api_module_info {

		public $helpers, $module_dir, $api_namespace;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->module_dir = dirname( dirname( __FILE__ ) );
			$this->api_namespace = $this->helpers->itemInfo( 'text_domain' ) . '/' . basename( dirname( dirname( __FILE__ ) ) );
			add_action( 'rest_api_init', array($this, 'registerApiRoutes') );
		}

		public function registerApiRoutes() {
			register_rest_route( $this->api_namespace, 'module-info', array(
				'methods' => WP_REST_Server::READABLE,
				'callback' => array($this, 'moduleInfo'),
			) );
		}

		public function moduleInfo() {
			$response = $this->helpers->moduleInfo( basename( $this->module_dir ) );
			$response['api_url'] = $this->helpers->apiUrl( $this->api_namespace );

			return rest_ensure_response( $response );
		}

	}

	cjaddons_supportezzy_api_module_info::getInstance();
}