<?php
if( ! class_exists( 'cjaddons_rest_cjsupport_user' ) ) {
	class cjaddons_rest_cjsupport_user {

		public $helpers, $module_dir, $routes, $api_url, $module_info;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->module_info = $this->helpers->moduleInfo( basename( $this->helpers->module_dir ) );
			$this->api_url = '';
			if( function_exists( 'using_index_permalinks' ) ) {
				$this->api_url = rest_url( 'cjaddons' ) . '/';
			}
			$this->routes = array(
				'cjsupport-me' => array(
					'endpoint' => $this->module_info['module_id'] . '/me',
					'name' => sprintf( __( '%s Login', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'addon-supportezzy' ),
					'methods' => array(
						'post' => array($this, 'me'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-get-users' => array(
					'endpoint' => $this->module_info['module_id'] . '/get-users',
					'name' => sprintf( __( '%s Get Users', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'addon-supportezzy' ),
					'methods' => array(
						'post' => array($this, 'getUsers'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-tickets-filters' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-filters-tickets',
					'name' => sprintf( __( '%s User Filters (Tickets)', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'addon-supportezzy' ),
					'methods' => array(
						'post' => array($this, 'userTicketsFilters'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-update-meta' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-update-meta',
					'name' => sprintf( __( '%s User Update Meta', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'updateUserMeta'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-get-meta' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-get-meta',
					'name' => sprintf( __( '%s Get user meta', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'getUserMeta'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				// notifications
				'cjsupport-user-get-reminders' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-get-reminders',
					'name' => sprintf( __( '%s User get reminders', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'getReminders'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-add-reminder' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-add-reminder',
					'name' => sprintf( __( '%s User add reminder', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'addReminder'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-delete-reminder' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-delete-reminder',
					'name' => sprintf( __( '%s User add reminder', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'deleteReminder'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-save-quick-text' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-save-quick-text',
					'name' => sprintf( __( '%s Save quick text', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'saveQuickText'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-get-quick-text' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-get-quick-text',
					'name' => sprintf( __( '%s Get user\'s quick text', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'getQuickText'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-user-remove-quick-text' => array(
					'endpoint' => $this->module_info['module_id'] . '/user-remove-quick-text',
					'name' => sprintf( __( '%s Remove user\'s quick text', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => '',
					'methods' => array(
						'post' => array($this, 'removeQuickText'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
			);
			add_filter( 'cjaddons_register_api_route', array($this, 'registerRoute') );
		}

		public function registerRoute( $routes ) {
			$routes = array_merge( $routes, $this->routes );

			return $routes;
		}

		public function me( $request ) {
			$token = $request->get_header( 'x_authorization' );
			$fields = $request['fields'];
			$user_info = $this->helpers->getUserByToken( $token );
			$data = array();
			if( ! empty( $user_info ) ) {
				$data['access_token'] = $user_info['access_token'];
				$default_fields = explode( ',', $this->helpers->userInfoDefaultFields() );
				foreach( $default_fields as $key => $value ) {
					$value = trim( $value );
					$data[ $value ] = (isset( $user_info[ $value ] )) ? $user_info[ $value ] : '';
				}
				if( ! empty( $fields ) ) {
					$fields = explode( ',', $fields );
					foreach( $fields as $key => $value ) {
						$value = trim( $value );
						$data[ $value ] = $user_info[ $value ];
					}
				}
				$user_roles = $this->helpers->userRole( $user_info['ID'] );
				$data['roles'] = $user_roles;

				$data['is_agent'] = (is_array( $user_roles ) && in_array( 'support_agent', $user_roles )) ? 1 : 0;
				$data['is_client'] = (is_array( $user_roles ) && ! in_array( 'support_agent', $user_roles ) && ! in_array( 'administrator', $user_roles )) ? 1 : 0;
				$data['is_admin'] = (is_array( $user_roles ) && in_array( 'administrator', $user_roles )) ? 1 : 0;

				if( ! empty( $data ) ) {
					foreach( $data as $key => $value ) {
						if( ! is_array( $value ) ) {
							$data[ $key ] = urldecode( $value );
						}
					}
				}
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function updateUserMeta( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$data['success'] = update_user_meta( $user_info['ID'], $request['meta_key'], $request['meta_value'] );

			return $this->helpers->apiResponse( $request, $data );
		}

		public function getUserMeta( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$data['meta_value'] = (isset( $user_info[ $request['meta_key'] ] )) ? $user_info[ $request['meta_key'] ] : '';

			return $this->helpers->apiResponse( $request, $data );
		}

		public function userTicketsFilters( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$data = array();
			if( ! empty( $user_info ) ) {
				$filters = get_user_meta( $user_info['ID'], 'cjsupport_tickets_filters', true );
				if( $filters == '' ) {
					$data['not_found'] = __( '<b>No custom filters found!</b><br>You can save custom filters under the "New" tab.', 'addon-supportezzy' );
				}
				if( is_array( $filters ) && ! empty( $filters ) ) {
					$data = $filters;
				}
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function getUsers( $request ) {
			$data = array();
			$users_query_array = array();
			if( isset( $request['query_args'] ) && is_array( $request['query_args'] ) ) {
				foreach( $request['query_args'] as $arg_key => $arg_value ) {
					$users_query_array[ $arg_key ] = $arg_value;
				}
			}
			$all_users = get_users( $users_query_array );
			if( ! empty( $all_users ) ) {
				foreach( $all_users as $key => $user ) {
					$data[ $user->ID ] = $this->helpers->userInfo( $user->ID, $request['fields'] );
				}
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		// reminders
		public function getReminders( $request ) {
			$api_user_info = $this->helpers->getApiUserInfo( $request );
			$user_reminders = get_user_meta( $api_user_info['ID'], 'cjsupport_reminders', true );
			$user_reminders_array = array();
			if( is_array( $user_reminders ) && ! empty( $user_reminders ) ) {
				foreach( $user_reminders as $key => $reminder ) {
					$user_reminders_array[ $reminder['notification_id'] ] = $reminder;
					$user_reminders_array[ $reminder['notification_id'] ]['title'] = urldecode( $reminder['title'] );
					$user_reminders_array[ $reminder['notification_id'] ]['date'] = date( 'c', strtotime( $reminder['date'] ) );
					if( time() > strtotime( $reminder['date'] ) ) {
						unset( $user_reminders_array[ $reminder['notification_id'] ] );
					}
				}
				update_user_meta( $api_user_info['ID'], 'cjsupport_reminders', $user_reminders_array );
			}

			$data = get_user_meta( $api_user_info['ID'], 'cjsupport_reminders', true );

			return $this->helpers->apiResponse( $request, $data );
		}

		public function addReminder( $request ) {
			$api_user_info = $this->helpers->getApiUserInfo( $request );
			$user_reminders = get_user_meta( $api_user_info['ID'], 'cjsupport_reminders', true );
			$user_reminders = ( ! is_array( $user_reminders )) ? array() : $user_reminders;
			$user_reminders[ $request['notification_id'] ]['notification_id'] = $request['notification_id'];
			$user_reminders[ $request['notification_id'] ]['ticket_id'] = $request['ticket_id'];
			$user_reminders[ $request['notification_id'] ]['title'] = urldecode( $request['notification_title'] );
			$user_reminders[ $request['notification_id'] ]['date'] = date( 'c', strtotime( $request['notification_date'] ) );
			update_user_meta( $api_user_info['ID'], 'cjsupport_reminders', $user_reminders );
			$user_reminders = get_user_meta( $api_user_info['ID'], 'cjsupport_reminders', true );
			$data = $user_reminders;

			return $this->helpers->apiResponse( $request, $data );
		}

		public function deleteReminder( $request ) {
			$data = array();
			$one_signal = cjaddons_supportezzy_one_signal::getInstance();
			$api_user_info = $this->helpers->getApiUserInfo( $request );
			$one_signal->deleteNotification( $request['notification_id'] );
			$user_reminders = get_user_meta( $api_user_info['ID'], 'cjsupport_reminders', true );
			unset( $user_reminders[ $request['notification_id'] ] );
			update_user_meta( $api_user_info['ID'], 'cjsupport_reminders', $user_reminders );
			$user_reminders = get_user_meta( $api_user_info['ID'], 'cjsupport_reminders', true );
			$data = $user_reminders;

			return $this->helpers->apiResponse( $request, $data );
		}

		public function saveQuickText( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$data = array();
			if( ! empty( $user_info ) ) {
				$user_quick_text = get_user_meta( $user_info['ID'], 'cjsupport_quick_text', true );
				$user_quick_text = ($user_quick_text == '') ? array() : $user_quick_text;
				$unique_string = $this->helpers->uniqueString( 'QT-' );
				$user_quick_text[ $unique_string ] = $request['content'];
				update_user_meta( $user_info['ID'], 'cjsupport_quick_text', $user_quick_text );
				$user_quick_text = get_user_meta( $user_info['ID'], 'cjsupport_quick_text', true );
				$data = $user_quick_text;
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function getQuickText( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$data = array();
			if( ! empty( $user_info ) ) {
				$user_quick_text = get_user_meta( $user_info['ID'], 'cjsupport_quick_text', true );
				$data = $user_quick_text;
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function removeQuickText( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$data = array();
			if( ! empty( $user_info ) ) {
				$user_quick_text = get_user_meta( $user_info['ID'], 'cjsupport_quick_text', true );
				unset( $user_quick_text[ $request['key'] ] );
				update_user_meta( $user_info['ID'], 'cjsupport_quick_text', $user_quick_text );
				$user_quick_text = get_user_meta( $user_info['ID'], 'cjsupport_quick_text', true );
				$data = $user_quick_text;
			}

			return $this->helpers->apiResponse( $request, $data );
		}

	}

	cjaddons_rest_cjsupport_user::getInstance();
}