<?php
error_reporting(0);
require_once sprintf( '%s/autoload/one-signal.php', $this->helpers->module_dir );
$one_signal = cjaddons_supportezzy_one_signal::getInstance();
$app_page = $this->helpers->savedOption( 'cjsupport_page_app' );
$app_url = get_permalink( $app_page );
?><!DOCTYPE html>
<html class="supportezzy-app-wrapper">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $page_info['post_title']; ?></title>
    <script type="text/javascript" src="https://www.google.com/recaptcha/api.js"></script>
    <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js" async></script>
	<?php wp_head() ?>
	<?php do_action( 'supportezzy_head' ); ?>
	<?php if( $one_signal->isReady() ) {
		if( is_ssl() ) {
			$required_files = array(
				'manifest.json',
				'OneSignalSDKWorker.js',
				'OneSignalSDKUpdaterWorker.js',
			);
			$missing_files = array();
			foreach( $required_files as $key => $required_file ) {
				if( ! file_exists( ABSPATH . '/' . $required_file ) ) {
					$missing_files[] = sprintf( __( '%s file not found.', 'cjaddons' ), site_url( '/' ) . $required_file );
				}
			}
			if( ! empty( $missing_files ) ) {
				$message = sprintf( __( '<p><b style="color:red;">Missing required files!</b><br>%s</p>Please check <a href="%s">One Signal Web Push SDK Setup (HTTPS)</a>', 'cjaddons' ), implode( '<br>', $missing_files ), 'https://documentation.onesignal.com/docs/web-push-sdk-setup-https' );
				wp_die( $message );
			}
		}

		?>
        <script>
            var OneSignal = window.OneSignal || [];
            OneSignal.push(["init", {
                appId: "<?php echo $one_signal->info( 'app_id' ) ?>",
                autoRegister: <?php echo ($this->helpers->savedOption( 'cjsupport_one_signal_auto_register' ) == 'yes') ? 'true' : 'false'; ?>,
	            <?php if(!is_ssl()){ ?>
                subdomainName: '<?php echo site_url() ?>',
	            <?php } ?>
                notifyButton: {
                    position: 'bottom-left',
                    enable: <?php echo ($this->helpers->savedOption( 'cjsupport_one_signal_notify_button_status' ) == 'yes') ? 'true' : 'false'; ?>,
                    size: '<?php echo ($this->helpers->savedOption( 'cjsupport_one_signal_notify_button_size' ) != '') ? $this->helpers->savedOption( 'cjsupport_one_signal_notify_button_size' ) : 'large'; ?>',
                    showCredit: <?php echo ($this->helpers->savedOption( 'cjsupport_one_signal_notify_button_credits' ) == 'yes') ? true : 'false'; ?>,
                },
                promptOptions: {
                    actionMessage: '<?php echo $this->helpers->savedOption( 'cjsupport_one_signal_action_message' ); ?>'
                },
                welcomeNotification: {
                    "title": "<?php echo get_bloginfo( 'name' ); ?>",
                    "message": '<?php echo $this->helpers->savedOption( 'cjsupport_one_signal_welcome_message' ); ?>',
                    // "url": "" /* Leave commented for the notification to not open a window on Chrome and Firefox (on Safari, it opens to your webpage) */
                },
            }]);
			<?php if($this->helpers->app_url != ''){ ?>
            setTimeout(function () {
                OneSignal.setDefaultNotificationUrl("<?php echo $app_url; ?>");
            }, 100);
			<?php } ?>
        </script>
	<?php } ?>
</head>
<body class="supportezzy-app cssjockey-ui">