<?php
if( ! class_exists( 'cjaddons_supportezzy_envato' ) ) {
	class cjaddons_supportezzy_envato {
		private static $instance;
		public $helpers, $api_url, $personal_token, $envato_username;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_helpers::getInstance();
			$this->api_url = 'https://api.envato.com/';
			$this->personal_token = $this->helpers->savedOption( 'cjsupport_envato_token' );
			$this->envato_username = $this->helpers->savedOption( 'cjsupport_envato_username' );
			add_action( 'admin_init', array($this, 'adminInit') );
		}

		public function isReady() {
			if( $this->envato_username != '' && $this->personal_token != '' ) {
				return true;
			}

			return false;
		}

		public function api( $method = 'get', $route = '', $fields = array() ) {
			if( ! $this->isReady() ) {
				return false;
			}

			$url = $this->api_url . $route;

			$args = array(
				'headers' => array(
					'Authorization' => 'Bearer ' . $this->personal_token
				)
			);
			if( $method == 'get' ) {
				$response = $this->helpers->wpRemoteGet( $url, $fields, $args );

				return $response;
			}
			if( $method == 'post' ) {
				$response = $this->helpers->wpRemotePost( $url, $fields, $args );

				return $response;
			}
		}

		public function adminInit() {
			// sync products to supportezzy products
			if( isset( $_GET['envato-sync'] ) && $_GET['envato-sync'] == 'products' ) {
				$response = $this->api( 'get', 'v1/market/user-items-by-site:' . $this->envato_username . '.json' );
				$response = json_decode( $response );

				if( isset( $response->error ) ) {
					wp_die( $response->error );
				}

				$user_sites = array();
				if( ! isset( $response->error ) || (isset( $response->success ) && $response->success == 0) ) {
					foreach( $response as $key => $data ) {
						if( ! empty( $data ) ) {
							foreach( $data as $site_key => $site_data ) {
								$user_sites[ $site_data->site ] = $site_data->site;
							}
						}
					}
				}

				$user_items = array();
				if( ! empty( $user_sites ) ) {
					foreach( $user_sites as $key => $site_name ) {
						$items_response = $this->api( 'get', "v1/market/new-files-from-user:{$this->envato_username},{$site_name}.json" );
						$items_response = json_decode( $items_response );
						if( isset( $items_response->success ) && $items_response->success == 0 ) {
							wp_die( $items_response->data );
						}
						foreach( $items_response as $t_key => $items ) {
							if( ! empty( $items ) ) {
								foreach( $items as $item_key => $item ) {
									$user_items[ $item->id ] = (array) $item;
								}
							}
						}
					}
				}

				if( ! empty( $user_items ) ) {
					foreach( $user_items as $key => $item ) {
						$term_slug = 'envato-' . $item['id'];
						$check_existing = get_term_by( 'slug', $term_slug, 'cjsupport_products' );
						if( ! $check_existing ) {
							wp_insert_term( $term_slug, 'cjsupport_products', array('name' => $item['item']) );
						} else {
							wp_update_term( $check_existing->term_id, 'cjsupport_products', array('name' => $item['item']) );
						}
					}
				}
				$location = admin_url( 'edit-tags.php?taxonomy=cjsupport_products&post_type=cjsupport' );
				wp_redirect( $location );
				die();
			}
		}

	}

	cjaddons_supportezzy_envato::getInstance();
}