<?php
$current_user = $this->helpers->getApiUserInfo( $request );
$user_roles = $this->helpers->userRole( $current_user['ID'] );
$all_agents = $this->helpers->supportAgentsArray();
$is_agent = (is_array( $user_roles ) && in_array( 'support_agent', $user_roles )) ? 1 : 0;
$is_client = (is_array( $user_roles ) && ! in_array( 'support_agent', $user_roles ) && ! in_array( 'administrator', $user_roles )) ? 1 : 0;
$is_admin = (is_array( $user_roles ) && in_array( 'administrator', $user_roles )) ? 1 : 0;

$ticket_info = $this->helpers->postInfo($request['ticket_id']);

$form_fields = array(
	array(
		'id' => '_uid',
		'type' => 'text-readonly',
		'label' => __( 'Ticket Unique ID', 'addon-supportezzy' ),
		'info' => '',
		'default' => $ticket_info['_uid'],
		'container_class' => 'column is-12',
		'options' => '',
	),
	array(
		'id' => '_department',
		'type' => (!$is_client) ? 'dropdown' : 'hidden',
		'info' => '',
		'label' => __( 'Department', 'addon-supportezzy' ),
		'default' => (isset($ticket_info['taxonomies']) && is_array($ticket_info['taxonomies']['cjsupport_departments']) && !empty($ticket_info['taxonomies']['cjsupport_departments'])) ? $ticket_info['taxonomies']['cjsupport_departments'][0]['term_slug'] : '',
		'container_class' => 'column is-6',
		'options' => $this->helpers->getTaxonomyArray( 'cjsupport_departments' ),
	),
	array(
		'id' => '_product',
		'type' => (!$is_client) ? 'dropdown' : 'hidden',
		'info' => '',
		'label' => __( 'Product', 'addon-supportezzy' ),
		'default' => (isset($ticket_info['taxonomies']) && is_array($ticket_info['taxonomies']['cjsupport_departments']) && !empty($ticket_info['taxonomies']['cjsupport_departments'])) ? $ticket_info['taxonomies']['cjsupport_products'][0]['term_slug'] : '',
		'container_class' => 'column is-6',
		'options' => $this->helpers->getTaxonomyArray( 'cjsupport_products' ),
	),
	array(
		'id' => 'post_status',
		'type' => 'dropdown',
		'label' => __( 'Ticket Status', 'addon-supportezzy' ),
		'info' => '',
		'default' => $ticket_info['post_status'],
		'container_class' => 'column is-6',
		'options' => array(
			'publish' => __('Inbox', 'addon-supportezzy'),
			'closed' => __('Archive', 'addon-supportezzy'),
		),
	),
	array(
		'id' => '_priority',
		'type' => 'dropdown',
		'label' => __( 'Ticket Priority', 'addon-supportezzy' ),
		'info' => '',
		'default' => $ticket_info['_priority'],
		'container_class' => 'column is-6',
		'options' => $this->helpers->savedOption( 'cjsupport-tickets-priority' ),
	),
);