<?php
$current_user = $this->helpers->getApiUserInfo( $request );
$current_user_id = (isset( $current_user['ID'] )) ? $current_user['ID'] : 0;
$user_roles = $this->helpers->userRole( $current_user_id );
$all_agents = $this->helpers->supportAgentsArray();
$is_agent = (is_array( $user_roles ) && in_array( 'support_agent', $user_roles )) ? 1 : 0;
$is_client = (is_array( $user_roles ) && ! in_array( 'support_agent', $user_roles ) && ! in_array( 'administrator', $user_roles )) ? 1 : 0;
$is_admin = (is_array( $user_roles ) && in_array( 'administrator', $user_roles )) ? 1 : 0;

$departments = $this->helpers->getTaxonomyArray( 'cjsupport_departments' );
$products = $this->helpers->getTaxonomyArray( 'cjsupport_products' );

$form_fields = array();
if( is_array( $user_roles ) && ! $is_client ) {
	$form_fields['post_author'] = array(
		'id' => 'post_author',
		'type' => 'auto-complete',
		'label' => __( 'To', 'cjaddons' ),
		'params' => array(
			'class' => 'selectize',
			'required' => 1,
		),
		'settings' => array(
			'url' => admin_url( 'admin-ajax.php' ) . '?action=cjaddons_query_users',
			'post_data' => array(
				'orderby' => 'login',
				'order' => 'ASC',
				'search' => '*input_query*',
			),
			'key_field' => 'ID',
			'value_field' => 'display_name',
			'search_field' => 'user_login',
		),
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	);
}

$form_fields['post_title'] = array(
	'id' => 'post_title',
	'type' => 'text',
	'label' => __( 'Title', 'cjaddons' ),
	'params' => array(
		'class' => 'quick-search',
		'required' => 1,
	),
	'default' => '',
	'options' => '',
);
$form_fields['post_content'] = array(
	'id' => 'post_content',
	'type' => 'textarea',
	'label' => __( 'Description', 'cjaddons' ),
	'params' => array(
		'required' => 1,
	),
	'default' => "",
	'options' => '',
);
if( $this->helpers->savedOption( 'cjsupport_show_departments' ) == 'yes' && is_array( $departments ) && ! empty( $departments ) ) {
	$form_fields['_department'] = array(
		'id' => '_department',
		'type' => 'dropdown',
		'label' => __( 'Select a department', 'cjaddons' ),
		'info' => '',
		'default' => '',
		'options' => $departments,
	);
}
if( $this->helpers->savedOption( 'cjsupport_show_products' ) == 'yes' && is_array( $products ) && ! empty( $products ) ) {
	$form_fields['_product'] = array(
		'id' => '_product',
		'type' => 'dropdown',
		'label' => __( 'Select a product', 'cjaddons' ),
		'default' => '',
		'options' => $this->helpers->getTaxonomyArray( 'cjsupport_products' ),
	);
}
$form_fields['_priority'] = array(
	'id' => '_priority',
	'type' => 'dropdown',
	'label' => __( 'Priority', 'cjaddons' ),
	'info' => '',
	'default' => '24',
	'container_class' => 'column is-12',
	'options' => $this->helpers->savedOption( 'cjsupport-tickets-priority' ),
);
$form_fields['first_name'] = array(
	'id' => 'first_name',
	'type' => (isset( $api_user_info['user_email'] ) && $api_user_info['user_email'] != '') ? 'hidden' : 'text',
	'label' => __( 'First Name', 'cjaddons' ),
	'params' => array('required' => 1),
	'container_class' => 'column is-6',
	'default' => (isset( $api_user_info['first_name'] )) ? $api_user_info['first_name'] : '',
	'options' => '',
);
$form_fields['last_name'] = array(
	'id' => 'last_name',
	'type' => (isset( $api_user_info['user_email'] ) && $api_user_info['user_email'] != '') ? 'hidden' : 'text',
	'label' => __( 'Last Name', 'cjaddons' ),
	'params' => array('required' => 1),
	'container_class' => 'column is-6',
	'default' => (isset( $api_user_info['last_name'] )) ? $api_user_info['last_name'] : '',
	'options' => '',
);
$form_fields['user_email'] = array(
	'id' => 'user_email',
	'type' => (isset( $api_user_info['user_email'] ) && $api_user_info['user_email'] != '') ? 'hidden' : 'text',
	'label' => __( 'Your email address', 'cjaddons' ),
	'params' => array('required' => 1),
	'default' => (isset( $api_user_info['user_email'] )) ? $api_user_info['user_email'] : '',
	'options' => '',
);

$additional_fields = array();
$form_builder_form_info = $this->helpers->postInfo( $this->helpers->savedOption( 'cjsupport_form_builder_form_id' ) );
if( ! empty( $form_builder_form_info ) && isset( $form_builder_form_info['_form_fields'] ) && class_exists( 'cjaddons_form_builder_helpers' ) ) {
	$form_builder_helpers = cjaddons_form_builder_helpers::getInstance();
	$form_fields['form_builder_form_id'] = array(
		'id' => 'form_builder_form_id',
		'type' => 'hidden',
		'label' => '',
		'info' => '',
		'default' => $form_builder_form_info['ID'],
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	);
	if( is_serialized( $form_builder_form_info['_form_fields'] ) ) {
		$additional_fields_array = unserialize( $form_builder_form_info['_form_fields'] );
		if( is_array( $additional_fields_array ) && ! empty( $additional_fields_array ) ) {
			foreach( $additional_fields_array as $key => $value ) {
				foreach( $value as $f_key => $field ) {
					$form_fields[ $field['id'] ] = $field;
					$form_fields[ $field['id'] ]['id'] = 'form_builder_' . $field['id'];
					if( $f_key == 'special-qna' ) {
						$form_fields[ $field['id'] ]['params'] = array(
							'required' => 1
						);
					}
					if( $f_key == 'special-google_recaptcha' ) {
						unset( $form_fields[ $field['id'] ] );
					}
				}
			}
		}
	}
}

