<?php
if( ! class_exists( 'cjaddons_supportezzy_one_signal' ) ) {

	class cjaddons_supportezzy_one_signal {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_helpers::getInstance();
		}

		public function info( $var = null ) {
			$info = array(
				'app_id' => $this->helpers->savedOption( 'cjsupport_one_signal_app_id' ),
				'api_key' => $this->helpers->savedOption( 'cjsupport_one_signal_api_key' ),
				'notify_button_status' => $this->helpers->savedOption( 'cjsupport_one_signal_notify_button_status' ),
				'notify_button_size' => $this->helpers->savedOption( 'cjsupport_one_signal_notify_button_size' ),
				'notify_button_credits' => $this->helpers->savedOption( 'cjsupport_one_signal_notify_button_credits' ),
				'api_url' => 'https://onesignal.com/api/v1/',
			);

			return (is_null( $var )) ? $info : $info[ $var ];
		}

		public function isReady() {
			if( $this->helpers->savedOption( 'cjsupport_one_signal_status' ) == 'enable' && $this->info( 'app_id' ) != '' && $this->info( 'api_key' ) != '' ) {
				return true;
			}

			return false;
		}

		public function deviceType() {
			$this->helpers = cjaddons_helpers::getInstance();
			$browser_type = $this->helpers->getBrowser( null, 'type' );
			$return = array(
				'iOS' => 0,
				'ANDROID' => 1,
				'AMAZON' => 2,
				'WINDOWSPHONE (MPNS)' => 3,
				'CHROME APPS / EXTENSIONS' => 4,
				'google-chrome' => 5,
				'WINDOWSPHONE (WNS)' => 6,
				'SAFARI' => 7,
				'FIREFOX' => 8,
				'MACOS' => 9,
			);

			return $return[ $browser_type ];
		}

		public function sendUserNotification( $user_ids = array(), $content = array(), $params = array() ) {

			$player_ids = array();
			foreach( $user_ids as $key => $id ) {
				$one_signal_id = get_user_meta( $id, 'one_signal_id', true );
				if( $one_signal_id ) {
					$player_ids[] = $one_signal_id;
				}
			}

			if( empty( $player_ids ) ) {
				return false;
			}

			$fields = array(
				'app_id' => $this->info( 'app_id' ),
				'contents' => str_replace( '+', ' ', $content ),
				'include_player_ids' => $player_ids,
			);
			if( ! empty( $params ) ) {
				foreach( $params as $key => $param ) {
					$fields[ $key ] = $param;
				}
			}
			$fields = json_encode( $fields );
			$headers = array(
				'headers' => array('Content-Type' => 'application/json; charset=utf-8')
			);
			$response = $this->helpers->wpRemotePost( $this->info( 'api_url' ) . '/notifications', $fields, $headers );

			return $response;
		}

		public function getNotification( $notification_id ) {
			$headers = array(
				'headers' => array(
					'Content-Type' => 'application/json; charset=utf-8',
					'Authorization' => 'Basic ' . $this->info( 'api_key' ),
				)
			);
			$response = $this->helpers->wpRemoteGet( $this->info( 'api_url' ) . '/notifications/' . $notification_id . '?app_id=' . $this->info( 'app_id' ), null, $headers );

			return json_decode( $response );
		}

		public function deleteNotification( $notification_id ) {
			$headers = array(
				'method' => 'DELETE',
				'headers' => array(
					'Content-Type' => 'application/json; charset=utf-8',
					'Authorization' => 'Basic ' . $this->info( 'api_key' ),
				)
			);
			$response = $this->helpers->wpRemoteGet( $this->info( 'api_url' ) . '/notifications/' . $notification_id . '?app_id=' . $this->info( 'app_id' ), null, $headers );

			return json_decode( $response );
		}

	}
}