<?php
if( ! class_exists( 'cjaddons_supportezzy_setup' ) ) {

	class cjaddons_supportezzy_setup {
		private static $instance;
		public $helpers, $render_app, $support_page, $module_info;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->render_app = 0;
			$this->support_page = $this->helpers->savedOption( 'cjsupport_page_app' );
			$this->module_info = $this->helpers->moduleInfo();
			add_action( 'template_redirect', array($this, 'renderApp') );
			add_action( 'wp_enqueue_scripts', array($this, 'filterStylesAndScripts'), 99 );
			add_action( 'show_admin_bar', array($this, 'disableAdminBar') );
			add_action( 'init', array($this, 'initCallback'), 0 );
			add_action( 'admin_head', array($this, 'disableBackendTicketsAccess') );
			// migration
			add_action( 'admin_notices', array($this, 'migrations') );
			add_action( 'admin_notices', array($this, 'initialSetup') );

			add_action( 'wp_ajax_nopriv_cjsupport_upload_file', array($this, 'processAttachment') );
			add_action( 'wp_ajax_cjsupport_upload_file', array($this, 'processAttachment') );

			add_filter( 'cjaddons_locale', array($this, 'locale'), 10, 1 );
			add_filter( 'wp_footer', array($this, 'displayWidget') );

			add_action( 'save_post', array($this, 'faqCategoriesSetup'), 10, 1 );
			add_action( 'wp_head', array($this, 'redirectToApp') );
		}

		public function disableBackendTicketsAccess() {
			if( $this->support_page != '' ) {
				$redirect = get_permalink( $this->support_page );
			} else {
				$redirect = $this->helpers->callbackUrl( 'addon-supportezzy', 'cjsupport-configuration-app', 'cjaddons-addon-supportezzy' );
			}
			$current_screen = get_current_screen();
			$redirect_to_app = 0;
			if( $current_screen->post_type == 'cjsupport' && $current_screen->base == 'edit' ) {
				$redirect_to_app = 1;
			}
			if( $current_screen->post_type == 'cjsupport' && $current_screen->base == 'post' && $current_screen->action == 'add' ) {
				$redirect_to_app = 1;
			}
			if( $redirect_to_app ) {
				wp_redirect( $redirect );
				die();
			}
		}

		public function redirectToApp() {
			if( class_exists( 'cjaddons_helpers' ) ) {
				$support_page = $this->helpers->savedOption( 'cjsupport_page_app' );
				if( is_singular( 'cjsupport' ) && $support_page != '' ) {
					global $post;
					$page_url = get_permalink( $support_page );
					wp_redirect( $page_url . 'tickets/' . $post->ID );
					die();
				}
			}
		}

		public function initCallback() {
			// register ticket status closed
			$args = array(
				'label' => _x( 'Closed', 'Status General Name', 'addon-supportezzy' ),
				'label_count' => _n_noop( 'Closed (%s)', 'Closed (%s)', 'addon-supportezzy' ),
				'public' => true,
				'show_in_admin_all_list' => true,
				'show_in_admin_status_list' => true,
				'exclude_from_search' => true,
			);
			register_post_status( 'closed', $args );

			// register user role 'agent'
			add_role( 'support_agent', 'Support Agent', array('read' => true, 'level_0' => true) );
		}

		public function migrations() {
			$module_info = $this->helpers->moduleInfo();
			$migration_file = sprintf( $this->helpers->module_dir . '/autoload/migrations/migration-%s.php', $module_info['module_version'] );
			if( file_exists( $migration_file ) ) {
				require_once $migration_file;
			}
		}

		public function initialSetup() {
			$support_page = $this->helpers->savedOption( 'cjsupport_page_app' );
			$messages = array();
			if( $support_page == '' ) {
				$messages[] = sprintf( __( '<a href="%s">Click here</a> to select the support page.', 'addon-supportezzy' ), $this->helpers->callbackUrl( 'addon-supportezzy', 'cjsupport-configuration-app', 'cjaddons-addon-supportezzy' ) );
			}
			if( $support_page != '' && ! get_post( $support_page ) ) {
				$messages[] = sprintf( __( '<a href="%s">Click here</a> to select the support page.', 'addon-supportezzy' ), $this->helpers->callbackUrl( 'addon-supportezzy', 'cjsupport-configuration-app', 'cjaddons-addon-supportezzy' ) );
			}
			// agents message
			$agents = get_users( array(
				'role__in' => array('support_agent')
			) );

			if( empty( $agents ) ) {
				$admin_email = get_option( 'admin_email' );
				$admin_info = $this->helpers->userInfo( $admin_email );
				$admin = new WP_User( $admin_info['ID'] );
				$admin->add_role( 'support_agent' );
				$agents = get_users( array(
					'role__in' => array('support_agent')
				) );
				if( empty( $agents ) ) {
					$messages[] = sprintf( __( '<a href="%s">Click here</a> to select support staff.', 'addon-supportezzy' ), $this->helpers->callbackUrl( 'addon-supportezzy', 'cjsupport-configuration-staff', 'cjaddons-addon-supportezzy' ) );
				}
			}

			$agents = get_users( array(
				'role__in' => array('support_agent')
			) );

			if( ! empty( $messages ) ) {
				echo $this->helpers->adminNotice( 'cjsupport_select_app_page', 'error', implode( '<br>', $messages ), __( 'SupportEzzy Setup', 'addon-supportezzy' ), false );
			}

			if(count($agents) == 1){
				$admin_email = get_option('admin_email');
				if($agents[0]->user_email === $admin_email){
					$message = sprintf(__('All tickets will be assigned to the admin account (%s).', 'cjaddons'), $admin_email);
					$url = $this->helpers->callbackUrl('addon-supportezzy', 'cjsupport-configuration-staff', 'cjaddons-addon-supportezzy');
					$message .= '<p class="cssjockey-ui">'.sprintf(__('<a href="%s" class="button is-small is-primary" href="">Manage Support Staff</a>', 'cjaddons'), $url).'</p>';
					echo $this->helpers->adminNotice( 'cjsupport_notice_admin_as_agent', 'warning', $message, __( 'SupportEzzy', 'addon-supportezzy' ), true );
				}
			}

		}

		public function disableAdminBar() {
			if( $this->support_page != '' && is_singular( 'page' ) && is_page( $this->support_page ) ) {
				return false;
			}
		}

		public function filterStylesAndScripts() {
			if( $this->support_page != '' && is_singular( 'page' ) && is_page( $this->support_page ) ) {
				$this->render_app = 1;
			}
			if( $this->render_app ) {
				global $wp_styles, $wp_scripts;
				$registered_styles = array_keys( $wp_styles->registered );
				$registered_scripts = array_keys( $wp_scripts->registered );

				foreach( $registered_styles as $key => $handle ) {
					if( ! strstr( $handle, 'cjaddons' ) ) {
						wp_dequeue_style( $handle );
					}
				}
				foreach( $registered_scripts as $key => $handle ) {
					if( ! strstr( $handle, 'cjaddons' ) ) {
						wp_dequeue_script( $handle );
					}
				}
			}
		}

		public function renderApp() {
			$this->helpers->autoCloseTickets();
			if( is_404() ) {
				$app_page_link = get_permalink( $this->support_page );
				if( strstr( $this->helpers->currentUrl(), $app_page_link ) ) {
					wp_redirect( $app_page_link );
				}
			}

			if( $this->support_page != '' && is_singular( 'page' ) && is_page( $this->support_page ) ) {
				$this->render_app = 1;
			}
			if( $this->render_app ) {
				$page_info = $this->helpers->postInfo( $this->support_page );
				require_once 'app/header.php';
				require_once 'app/index.php';
				require_once 'app/footer.php';
				die();
			}
		}

		public function processAttachment() {
			$upload_dir = WP_CONTENT_DIR . '/uploads/supportezzy';
			$return = array();
			if( ! isset( $_POST['delete_attachment'] ) ) {
				if( isset( $_FILES ) ) {
					foreach( $_FILES as $key => $file ) {
						$upload_data = $this->helpers->uploadFile( $_FILES['file'], null, null, $_POST['allowed_file_types'], null, 'guid', $upload_dir );
						if( is_array( $upload_data ) ) {
							$return[ $file['name'] ]['file_name'] = $file['name'];
							$return[ $file['name'] ]['errors'] = implode( '<br>', $upload_data['errors'] );
						} else {
							$return[ $file['name'] ]['file_name'] = $file['name'];
							$return[ $file['name'] ]['file_url'] = $upload_data;
						}
					}
				}
				echo json_encode( $return );
				die();
			} else {
				$file_url = $_POST['delete_attachment'];
				$file_path = str_replace( WP_CONTENT_URL, WP_CONTENT_DIR, $file_url );
				unlink( $file_path );
				die();
			}
		}

		public function locale() {
			global $cjaddons_item_vars, $wpdb;
			$dir_name = 'addon-supportezzy';
			$options_table = $wpdb->prefix . $cjaddons_item_vars['info']['options_table'];
			$saved_options = $wpdb->get_results( "SELECT * FROM $options_table" );
			$options = array();
			if( is_array( $saved_options ) && ! empty( $saved_options ) ) {
				foreach( $saved_options as $key => $option ) {
					if( is_serialized( $option->option_value ) && @unserialize( $option->option_value ) && $option->option_name != 'cjsupport_footer_widget' ) {
						$options[ $option->option_name ] = @unserialize( $option->option_value );
					} else {
						$options[ $option->option_name ] = $option->option_value;
					}
				}
			}
			$app_url = get_permalink( $options['cjsupport_page_app'] );
			$login_url = wp_login_url( $app_url );
			if( isset( $options['cjsupport_login_url'] ) && $options['cjsupport_login_url'] != '' ) {
				$login_url = $this->helpers->queryString( $options['cjsupport_login_url'] ) . 'redirect_to=' . urlencode( $app_url );
			}
			$edit_profile_url = admin_url( 'profile.php' );
			if( isset( $options['cjsupport_edit_profile_url'] ) && $options['cjsupport_edit_profile_url'] != '' ) {
				$edit_profile_url = $options['cjsupport_edit_profile_url'];
			}

			$extra_nav_menu = $this->helpers->savedOption( 'cjsupport_nav_menu' );
			$extra_nav_menu_links = wp_get_nav_menu_items( $extra_nav_menu );

			$cjaddons_item_vars['locale'][ $dir_name ] = array(
				'nav_menu_links' => $extra_nav_menu_links,
				'show_faqs' => ($this->helpers->savedOption( 'cjsupport_show_faqs' ) != 'no') ? 1 : 0,
				'logo_text' => (isset( $options['cjsupport_company_name'] ) && $options['cjsupport_company_name'] != '') ? $options['cjsupport_company_name'] : get_bloginfo( 'name' ),
				'logo_image' => (isset( $options['cjsupport_company_logo'] ) && $options['cjsupport_company_logo'] != '') ? $options['cjsupport_company_logo'] : '',
				'logo_type' => (isset( $options['cjsupport_logo_type'] ) && $options['cjsupport_logo_type'] != '') ? $options['cjsupport_logo_type'] : 'text',
				'tickets' => __( 'Tickets', 'addon-supportezzy' ),
				'faq' => __( 'FAQ', 'addon-supportezzy' ),
				'frequently_asked_questions' => __( 'Frequently asked questions', 'addon-supportezzy' ),
				'no_faq_found' => __( 'No FAQs found.', 'addon-supportezzy' ),
				'login' => __( 'Login', 'addon-supportezzy' ),
				'you' => __( 'You', 'addon-supportezzy' ),
				'redirecting' => __( 'Please wait, redirecting...', 'addon-supportezzy' ),
				'update_ticket_info' => __( 'Update Ticket Info', 'addon-supportezzy' ),
				'inbox' => __( 'Inbox', 'addon-supportezzy' ),
				'yours' => __( 'Yours', 'addon-supportezzy' ),
				'archive' => __( 'Archive', 'addon-supportezzy' ),
				'custom' => __( 'Custom', 'addon-supportezzy' ),
				'created_by' => __( 'Created by', 'addon-supportezzy' ),
				'last_comment_by' => __( ', last comment by', 'addon-supportezzy' ),
				'not_assigned' => __( 'Not Assigned', 'addon-supportezzy' ),
				'awaiting_response' => __( 'Awaiting Response', 'addon-supportezzy' ),
				'starred' => __( 'Starred', 'addon-supportezzy' ),
				'delayed' => __( 'Delayed', 'addon-supportezzy' ),
				'no_tickets_found' => __( 'No tickets found.', 'addon-supportezzy' ),
				// push notification
				'push_notifications_not_supported' => __( '<b>Push notifications are not supported</b><br>You would need to check your email to track updates.', 'addon-supportezzy' ),
				'notification_not_sent' => __( 'Unable to set reminder, please verify integration settings.', 'addon-supportezzy' ),
				// verification envato
				'envato_verification' => __( 'Envato Verification', 'addon-supportezzy' ),
				'envato_verification_pending' => __( 'User has not verified envato license code.', 'addon-supportezzy' ),
				'verification_required' => __( 'Verification Required', 'addon-supportezzy' ),
				'enter_envato_purchase_code' => __( 'Enter Envato Purchase Code', 'addon-supportezzy' ),
				'verify' => __( 'Verify', 'addon-supportezzy' ),
				'envato_link_find_purchase_code' => __( "Where's my purchase code?", 'addon-supportezzy' ),
				'envato_purchase_code_url' => 'https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-',
				'verification_information' => __( "Verification Information", 'addon-supportezzy' ),
				'support_until' => __( "Support valid till:", 'addon-supportezzy' ),
				'support_expired_on' => __( "Support expired on:", 'addon-supportezzy' ),
				'your_profile' => __( "Your Profile", 'addon-supportezzy' ),
				'custom_filters' => __( "Custom Filters", 'addon-supportezzy' ),
				'quick_text' => __( "Quick Text", 'addon-supportezzy' ),
				'quick_text_info' => __( "You can save quick text and use the same by typing /qt while commenting on a ticket.", 'addon-supportezzy' ),
				'quick_text_placeholder' => __( "Specify content that you would like to use a quick text.", 'addon-supportezzy' ),
				'no_quick_text' => __( "<b>Nothing found!</b><br>Looks like you have not saved any quick text snippets.", 'addon-supportezzy' ),
				'reminders' => __( "Reminders", 'addon-supportezzy' ),
				'new' => __( "New", 'addon-supportezzy' ),
				'add_new' => __( "Add New", 'addon-supportezzy' ),
				'saved' => __( "Saved", 'addon-supportezzy' ),
				'no_reminders' => __( "No reminders found.", 'addon-supportezzy' ),
				'save_changes' => __( "Save Changes", 'addon-supportezzy' ),
				'search_user_placeholder' => __( "Type username, email or keywords to search..", 'addon-supportezzy' ),
				'no_users_selected' => __( "No user selected", 'addon-supportezzy' ),
				'search_results' => __( "Search Results", 'addon-supportezzy' ),
				'qt_button_text' => __( "Add Quick Text", 'addon-supportezzy' ),
				'cancel' => __( "Cancel", 'addon-supportezzy' ),
				'update' => __( "Update", 'addon-supportezzy' ),
				'logout' => __( "Logout", 'addon-supportezzy' ),
				'search_placeholder' => __( "Search..", 'addon-supportezzy' ),
				'submit_new_ticket' => __( "Submit new ticket", 'addon-supportezzy' ),
				'submit_ticket' => __( "Submit Ticket", 'addon-supportezzy' ),
				'show_details' => __( "Show Details", 'addon-supportezzy' ),
				'load_more' => __( "Load More", 'addon-supportezzy' ),
				'reply' => __( "Reply", 'addon-supportezzy' ),
				'assign' => __( "Assign", 'addon-supportezzy' ),
				'set_reminder' => __( "Set Reminder", 'addon-supportezzy' ),
				'add_reminder_placeholder' => __( "Add comment...", 'addon-supportezzy' ),
				'send' => __( "Send", 'addon-supportezzy' ),
				'ticket_information' => __( "Ticket Information", 'addon-supportezzy' ),
				'additional_information' => __( "Additional Information", 'addon-supportezzy' ),
				'conversation_between' => __( "Conversation between", 'addon-supportezzy' ),
				'additional_ticket_info' => __( "Additional Information", 'addon-supportezzy' ),
				'apply' => __( "Apply", 'addon-supportezzy' ),
				'is_iframe' => (isset( $_GET['cjsupport-iframe'] ) && $_GET['cjsupport-iframe'] == 'active') ? 1 : 0,
				'at_who_info' => __( 'Type <code class="color-red p-2">@{username}</code> to include support agents in this conversation.<br>
									 Type <code class="color-red p-2">/faq{search-query}</code> to include support agents in this conversation.<br>
									 Type <code class="color-red p-2">/qt{search-query}</code> to include saved quick text in this conversation.<br>
									 ', 'addon-supportezzy' ),

				'home_url' => (isset( $options['cjsupport_home_url'] ) && $options['cjsupport_home_url'] != '') ? $options['cjsupport_home_url'] : site_url(),
				'app_url' => $app_url,
				'login_url' => (isset( $_GET['cjsupport-iframe'] ) && $_GET['cjsupport-iframe'] == 'active') ? $this->helpers->queryString( $login_url ) . 'cjsupport-iframe=active' : $login_url,
				'edit_profile_url' => $edit_profile_url,
				'cjsupport_show_departments' => (isset( $options['cjsupport_show_departments'] ) && $options['cjsupport_show_departments'] != '') ? $options['cjsupport_show_departments'] : 'yes',
				'cjsupport_show_products' => (isset( $options['cjsupport_show_products'] ) && $options['cjsupport_show_products'] != '') ? $options['cjsupport_show_products'] : 'yes',
				'cjsupport_user_must_login' => (isset( $options['cjsupport_user_must_login'] )) ? $options['cjsupport_user_must_login'] : 'no',
				'cjsupport_google_recaptcha_key' => (isset( $options['cjsupport_google_recaptcha_key'] )) ? $options['cjsupport_google_recaptcha_key'] : '',
			);

			return $cjaddons_item_vars['locale'];
		}

		public function displayWidget() {
			$app_page_id = $this->helpers->savedOption( 'cjsupport_page_app' );
			if( $app_page_id == '' ) {
				return;
			}
			if( is_singular( 'page' ) && is_page( $app_page_id ) ) {
				return;
			}

			$app_in_footer = $this->helpers->savedOption( 'cjsupport_footer_widget' );
			if( isset( $app_in_footer['selected_value'] ) && $app_in_footer['selected_value'] == 'no' ) {
				return;
			}
			$widget_options = $this->helpers->getGroupOption( 'cjsupport_footer_widget' );

			$app_url = get_permalink( $app_page_id );
			ob_start();
			require_once 'html/frontend-widget.php';
			echo ob_get_clean();
		}

		public function faqCategoriesSetup( $post_id ) {

			if( wp_is_post_revision( $post_id ) ) {
				return;
			}
			$post_type = get_post_type( $post_id );
			if( "cjsupport_faqs" != $post_type ) {
				return;
			}
			$general_faq = get_term_by( 'slug', 'general-faqs', 'cjsupport_faq_category' );
			if( ! $general_faq ) {
				wp_insert_term( 'General Questions', 'cjsupport_faq_category', array(
					'slug' => 'general-faqs',
				) );
			}
			$general_faq = get_term_by( 'slug', 'general-faqs', 'cjsupport_faq_category' );
			$post_info = $this->helpers->postInfo( $post_id );
			if( ! isset( $post_info['taxonomies'] ) ) {
				wp_set_post_terms( $post_id, $general_faq->term_id, 'cjsupport_faq_category', false );
			}
		}

	}

	cjaddons_supportezzy_setup::getInstance();
}