<?php
require_once sprintf('%s/helpers.php', dirname(dirname(__FILE__)));

if (!class_exists('cjaddons_metabox_sample')) {
    class cjaddons_metabox_sample
    {
	
		private static $instance;
        public $helpers;
	
		public static function getInstance() {
			if( ! isset(self::$instance) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
    	
        public function __construct()
        {
            $this->helpers = cjaddons_supportezzy_helpers::getInstance();
            add_action('cmb2_admin_init', array($this, 'init'));
        }

        public function init()
        {
            $prefix = '_cjaddons_';
            /**
             * Initiate the metabox
             */
            $cmb = new_cmb2_box(array(
                'id' => 'test_metabox',
                'title' => esc_attr__('Test Metabox', 'cmb2'),
                'object_types' => array('page'),
                'context' => 'normal',
                'priority' => 'high',
                'show_names' => true,
            ));

            $cmb->add_field(array(
                'name' => esc_attr__('Test Text', 'cmb2'),
                'desc' => esc_attr__('field description (optional)', 'cmb2'),
                'id' => $prefix . 'text',
                'type' => 'text',
                'show_on_cb' => 'cmb2_hide_if_no_cats',
            ));

            $cmb->add_field(array(
                'name' => esc_attr__('Website URL', 'cmb2'),
                'desc' => esc_attr__('field description (optional)', 'cmb2'),
                'id' => $prefix . 'url',
                'type' => 'text_url',
            ));

            $cmb->add_field(array(
                'name' => esc_attr__('Test Text Email', 'cmb2'),
                'desc' => esc_attr__('field description (optional)', 'cmb2'),
                'id' => $prefix . 'email',
                'type' => 'text_email',
            ));
        }
    }
	
	// cjaddons_metabox_sample::getInstance();
    
}