<?php
if( ! class_exists( 'cjaddons_supportezzy_helpers' ) ) {
	class cjaddons_supportezzy_helpers extends cjaddons_helpers {
		private static $instance;
		public $module_dir, $module_url, $app_url, $app_page;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			parent::__construct();
			$this->module_dir = wp_normalize_path( dirname( __FILE__ ) );
			$this->module_url = str_replace( WP_CONTENT_DIR, WP_CONTENT_URL, $this->module_dir );
			$this->app_page = $this->savedOption( 'cjsupport_page_app' );
			$this->app_url = '';
			if( function_exists( 'get_page_permastruct' ) ) {
				if( $this->app_page != '' ) {
					$this->app_url = get_permalink( $this->app_page );
				}
			}
		}

		public function moduleInfo( $module_key = null ) {
			$module_key = basename( $this->module_dir );

			return parent::moduleInfo( $module_key );
		}

		public function userInfoDefaultFields() {
			$return = 'ID,user_login,user_email,first_name,last_name,display_name,user_avatar,gravatar';

			return $return;
		}

		public function ticketInfo( $ticket_id ) {
			$envato = cjaddons_supportezzy_envato::getInstance();
			$post_info = $this->postInfo( $ticket_id );
			$post_excerpt = $post_info['post_excerpt'];
			//$post_excerpt = str_replace( "\n", ' ', $post_excerpt );
			$priority_array = $this->savedOption( 'cjsupport-tickets-priority' );
			$comment_count_label = '';
			if( $post_info['comment_count'] == 0 ) {
				$comment_count_label = __( 'No comments yet', 'cjaddons' );
			}
			if( $post_info['comment_count'] == 1 ) {
				$comment_count_label = __( '1 Comment', 'cjaddons' );
			}
			if( $post_info['comment_count'] > 1 ) {
				$comment_count_label = sprintf( __( '%s Comments', 'cjaddons' ), $post_info['comment_count'] );
			}

			$priority = (int) (isset( $post_info['_priority'] ) && $post_info['_priority'] != '') ? $post_info['_priority'] : 24;
			$return = array(
				'ID' => $post_info['ID'],
				'uid' => $post_info['_uid'],
				'post_title' => $post_info['post_title'],
				'post_date' => $post_info['post_date'],
				'post_excerpt' => $post_excerpt,
				'post_content' => $post_info['post_content'],
				'comment_count' => (int) $post_info['comment_count'],
				'comment_count_label' => $comment_count_label,
				'priority' => $priority,
				'priority_label' => $priority_array[ $priority ],
				'post_status' => $post_info['post_status'],
				'ticket_url' => $this->app_url . '#/tickets/' . $post_info['ID'],
			);
			$return['client_info'] = $this->userInfo( $post_info['post_author'], array('ID', 'user_login', 'user_email', 'display_name', 'gravatar') );
			$return['client_info']['designation'] = __( 'Client', 'cjaddons' );

			if( isset( $post_info['_attachments'] ) && is_array( $post_info['_attachments'] ) && ! empty( $post_info['_attachments'] ) ) {
				$return['_attachments'] = $post_info['_attachments'];
			}

			if(isset($post_info['_starred_by']) && $post_info['_starred_by'] == 'none'){
				update_post_meta($post_info['ID'], '_starred_by', '');
				$post_info = $this->postInfo($post_info['ID']);
			}
			if(isset($post_info['_starred_by']) && !is_array($post_info['_starred_by']) && strpos($post_info['_starred_by'], ',') !== 0){
				$starred_by = explode(',', $post_info['_starred_by']);
				$stars = array();
				foreach($starred_by as $star_key => $star_value){
					if($star_value !== 'none'){
						$user_info = $this->userInfo($star_value);
						if(!empty($user_info)){
							$stars[$user_info['ID']] = $user_info['user_email'];
						}
					}
					update_post_meta($post_info['ID'], '_starred_by', $stars);
				}
				$post_info = $this->postInfo($post_info['ID']);
			}

			$return['_starred_by'] = (isset($post_info['_starred_by'])) ? $post_info['_starred_by'] : array();

			if( is_array( $post_info['_assigned_to'] ) && ! empty( $post_info['_assigned_to'] ) ) {
				foreach( $post_info['_assigned_to'] as $assigned_user_id => $assigned_user_login ) {
					$return['assigned_to'][ $assigned_user_id ] = $this->userInfo( $assigned_user_id, array('ID', 'user_login', 'user_email', 'display_name', 'gravatar') );
					$return['assigned_to'][ $assigned_user_id ]['designation'] = __( 'Support Staff', 'cjaddons' );
				}
			}

			$last_comment = get_comments( array(
				'post_id' => $post_info['ID'],
				'orderby' => 'comment_date',
				'type' => 'comment',
				'order' => 'DESC',
				'number' => 1,
			) );

			$return['last_comment'] = array();
			if( ! empty( $last_comment ) ) {
				$comment = (array) $last_comment[0];
				$return['last_comment']['comment_ID'] = $comment['comment_ID'];
				$return['last_comment']['comment_date'] = $comment['comment_date'];
				$return['last_comment']['comment_content'] = $this->trimChars( html_entity_decode( strip_tags( $comment['comment_content'] ) ), 260, '...' );
				$return['last_comment']['user_info'] = $this->userInfo( $comment['comment_author'], array('ID', 'display_name') );
			}
			if( isset( $post_info['taxonomies']['cjsupport_departments'] ) && ! empty( $post_info['taxonomies']['cjsupport_departments'] ) ) {
				foreach( $post_info['taxonomies']['cjsupport_departments'] as $department_key => $department ) {
					$return['departments'][ $department['term_slug'] ] = html_entity_decode( $department['term_name'] );
				}
			}
			$return['verification_type'] = '';
			if( isset( $post_info['taxonomies']['cjsupport_products'] ) && ! empty( $post_info['taxonomies']['cjsupport_products'] ) ) {
				foreach( $post_info['taxonomies']['cjsupport_products'] as $product_key => $product ) {
					if( $envato->isReady() && $this->savedOption( 'cjsupport_verify_envato_licence_code' ) == 'yes' && strpos( 'envato', $product['term_slug'] ) >= 0 ) {
						$return['verification_type'] = 'envato';
					}
					$return['products'][ $product['term_slug'] ] = html_entity_decode( $product['term_name'] );
				}
			}

			$return['envato_purchase_info'] = (isset( $post_info['envato_purchase_info'] )) ? $post_info['envato_purchase_info'] : '';
			$return['envato_purchase_code'] = (isset( $post_info['envato_purchase_code'] )) ? $post_info['envato_purchase_code'] : '';

			$actual_last_comment = get_comments( array(
				'post_id' => $post_info['ID'],
				'orderby' => 'comment_date',
				'order' => 'DESC',
				'number' => 1,
			) );

			$return['awaiting_response'] = 0;
			if( empty( $actual_last_comment ) ) {
				$return['awaiting_response'] = 1;
			}

			if( ! empty( $actual_last_comment ) ) {
				$actual_comment = (array) $actual_last_comment[0];
				if( $return['client_info']['user_login'] == $actual_comment['comment_author'] ) {
					$return['awaiting_response'] = 1;
				}
			}

			if( $return['awaiting_response'] == 1 ) {
				$check_date = ( ! empty( $actual_comment )) ? $actual_comment['comment_date'] : $post_info['post_date'];
				$check_time = strtotime( $check_date );
				$check_time = $check_time + ($priority * 3600);
				$time_now = time();
				$return['priority_delayed'] = ($time_now > $check_time) ? 1 : 0;
				$return['priority_delayed_time'] = $time_now - $check_time;
				$return['priority_delayed_label'] = __( 'DELAYED', 'cjaddons' );
			}

			$return['post_title'] = html_entity_decode( $return['post_title'] );
			$return['post_excerpt'] = html_entity_decode( $return['post_excerpt'] );
			$return['post_content'] = html_entity_decode( $return['post_content'] );
			$form_builder_form = $this->savedOption( 'cjsupport_form_builder_form_id' );
			$return['form_builder_fields'] = array();
			if( $form_builder_form != '' ) {
				$form_builder_form_info = $this->postInfo( $form_builder_form );
				if( ! empty( $form_builder_form_info['_form_fields'] ) && isset( $form_builder_form_info['_form_fields'] ) ) {
					$form_fields = (is_serialized( $form_builder_form_info['_form_fields'] )) ? unserialize( $form_builder_form_info['_form_fields'] ) : $form_builder_form_info['_form_fields'];
					$exclude_fields = array('special-qna', 'special-google_recaptcha');
					if( ! empty( $form_fields ) ) {
						foreach( $form_fields as $field_key => $fields_array ) {
							foreach( $fields_array as $fields_array_key => $fields_array_value ) {
								if( ! in_array( $fields_array_key, $exclude_fields ) && isset( $post_info[ 'form_builder_' . $fields_array_value['id'] ] ) ) {
									$return['form_builder_fields'][ $fields_array_value['id'] ] = array(
										'label' => $fields_array_value['label'],
										'value' => $post_info[ 'form_builder_' . $fields_array_value['id'] ],
									);
								}
							}
						}
					}
				}
			}
			if(empty($return['form_builder_fields'])){
				unset($return['form_builder_fields']);
			}

			if( ! empty( $return ) ) {
				foreach( $return as $key => $value ) {
					if( is_string( $value ) && $value != '' ) {
						$return[ $key ] = urldecode( $value );
					}
				}
			}

			return $return;
		}

		public function assignTicketTo( $ticket_info = array() ) {
			global $wpdb;
			$return = '';
			$assignment_type = $this->getGroupOption( 'cjsupport_ticket_assignment' );

			$assignment_type_key = array_keys( $assignment_type )[0];
			switch( $assignment_type_key ) {
				case 'keep_unassigned':
					$return = '';
					break;
				case 'agent_id':
					$agent_info = $this->userInfo( $assignment_type['agent_id'] );
					$return = array();
					$return[ $agent_info['ID'] ] = $agent_info['user_login'];
					break;
				case 'agent_with_least_tickets':
					$all_agents = $this->supportAgentsArray();
					$result = array();
					if( is_array( $all_agents ) ) {
						foreach( $all_agents as $key => $agent ) {
							$agent_info = get_user_by( 'ID', $key );
							$query = $wpdb->get_var("SELECT COUNT(post_id) FROM $wpdb->postmeta WHERE meta_key = '_assigned_to' AND meta_value LIKE '%{$agent_info->user_login}%'");
							$result[ $query ] = array($agent_info->ID => $agent_info->user_login);
						}
						$min = min( array_keys( $result ) );
						$return = $result[ $min ];
					}
					break;
				case 'taxonomy_assignment':
					$ticket_department = (isset( $ticket_info['_department'] )) ? $ticket_info['_department'] : '';
					$ticket_product = (isset( $ticket_info['_product'] )) ? $ticket_info['_product'] : '';
					$include = array('all', $ticket_department, $ticket_product);
					$include = array_filter( $include );
					$all_agents = $this->supportAgentsArray();
					$eligible_agents = array();
					if( is_array( $all_agents ) && ! empty( $all_agents ) ) {
						foreach( $all_agents as $key => $agent ) {
							$agent_departments = get_user_meta( $key, 'cjsupport_departments', true );
							$agent_products = get_user_meta( $key, 'cjsupport_products', true );
							$intersect_departments = array_intersect( $agent_departments, $include );
							$intersect_products = array_intersect( $agent_products, $include );
							if( ! empty( $intersect_departments ) && ! empty( $intersect_products ) ) {
								$eligible_agents[ $key ] = $key;
							}
						}
						if( ! empty( $eligible_agents ) ) {
							$result = array();
							foreach( $eligible_agents as $key => $agent ) {
								$agent_info = get_user_by( 'ID', $agent );
								$query = $wpdb->get_var( "SELECT COUNT(post_id) FROM $wpdb->postmeta WHERE meta_key = '_assigned_to' AND meta_value LIKE '%{$agent_info->user_login}%'" );
								$result[ $query ] = array($agent_info->ID => $agent_info->user_login);
							}
							$min = min( array_keys( $result ) );
							$return = $result[ $min ];
						}
					} else {
						$return = '';
					}

					break;
				default:
					$return = '';
			}

			return $return;
		}

		public function supportAgentsArray() {
			$return = array();
			$agents = get_users( array(
				'role__in' => array('support_agent')
			) );
			if( ! empty( $agents ) ) {
				foreach( $agents as $key => $agent ) {
					$return[ $agent->ID ] = $agent->display_name;
				}
			}

			return $return;
		}

		public function parseFaqString( $string, $match = array() ) {
			preg_match( '#\{(.*?)\}#', $string, $match );
			if( is_array( $match ) && ! empty( $match ) ) {
				$str_array = explode( ':', $match[1] );
				$post_info = $this->postInfo( $str_array[1] );
				$replace = '<a href="' . $post_info['permalink'] . '" target="_blank">' . $post_info['post_title'] . '</a>';
				if( is_array( $match ) && isset( $match[0] ) ) {
					$string = str_replace( array($match[0]), $replace, $string );
				}
			}

			return $string;
		}

		public function parseUserTagString( $str ) {
			$str = preg_replace( '/(^|\s)@([a-z0-9_]+)/i', '$1<a target="_blank" href="#user/$2">@$2</a>', $str );

			return $str;
		}

		public function parseTicketVariables( $message, $ticket_id ) {
			$ticket_info = $this->ticketInfo( $ticket_id );
			$ticket_url = $this->app_url . '#/tickets/' . $ticket_info['ID'];
			$agent_names = array();
			if( ! empty( $ticket_info['assigned_to'] ) ) {
				foreach( $ticket_info['assigned_to'] as $agent_id => $agent_info ) {
					$agent_names[] = $agent_info['display_name'];
				}
			}
			$ticket_department_labels = '';
			if( isset( $ticket_info['departments'] ) && is_array( $ticket_info['departments'] ) ) {
				$ticket_department_labels = implode( ', ', $ticket_info['departments'] );
			}
			$ticket_product_labels = '';
			if( isset( $ticket_info['products'] ) && is_array( $ticket_info['products'] ) ) {
				$ticket_product_labels = implode( ', ', $ticket_info['products'] );
			}
			$message = str_replace( '%%TICKET_UID%%', $ticket_info['uid'], $message );
			$message = str_replace( '%%TICKET_SUBJECT%%', $ticket_info['post_title'], $message );
			$message = str_replace( '%%TICKET_COMMENT%%', $ticket_info['post_content'], $message );
			$message = str_replace( '%%TICKET_URL%%', $ticket_url, $message );
			$message = str_replace( '%%TICKET_DEPARTMENT_NAME%%', $ticket_department_labels, $message );
			$message = str_replace( '%%TICKET_PRODUCT_NAME%%', $ticket_product_labels, $message );
			$message = str_replace( '%%TICKET_CLIENT_NAME%%', $ticket_info['client_info']['display_name'], $message );
			$message = str_replace( '%%TICKET_AGENT_NAMES%%', implode( ', ', $agent_names ), $message );

			return $message;
		}

		public function parseCommentVariables( $message, $comment_id ) {
			$comment_info = $this->commentInfo( $comment_id );
			$message = str_replace( '%%COMMENT_CONTENT%%', $comment_info['comment_content'], $message );
			$message = str_replace( '%%COMMENT_AUTHOR_NAME%%', $comment_info['user_info']['display_name'], $message );
			$ticket_info = $this->ticketInfo( $comment_info['comment_post_ID'] );
			$message = $this->parseTicketVariables( $message, $ticket_info['ID'] );

			return $message;
		}

		public function noReplyEmailAddress( $custom = null ) {
			$company_email = $this->savedOption( 'cjsupport_company_email' );
			$domain = '';
			if( $company_email != '' && strpos( $company_email, '@' ) ) {
				$no_reply_email = explode( '@', $company_email );

				$domain = $no_reply_email[1];
			}
			if( $company_email == '' ) {
				$domain = $_SERVER['HTTP_HOST'];
			}
			$email = (is_null( $custom )) ? 'no-reply@' : $custom . '@';

			return $email . $domain;
		}

		public function getReplyToAddress( $ticket_info ) {

			if( $this->savedOption( 'cjsupport_company_email' ) == '' ) {
				return $this->noReplyEmailAddress();
			}
			$imap_connections = $this->savedOption( 'cjsupport_imap_accounts' );
			if( empty( $imap_connections ) ) {
				return $this->noReplyEmailAddress();
			}
			$department_emails = array();
			if( is_array( $imap_connections ) && ! empty( $imap_connections ) ) {
				foreach( $imap_connections as $imap_key => $imap_connection ) {
					$department_emails[ $imap_connection['departments'] ] = $imap_connection['imap_email_address'];
				}
			}

			if( ! isset( $ticket_info['departments'] ) && isset( $department_emails['all'] ) ) {
				return $department_emails['all'];
			}
			if( isset( $ticket_info['departments'] ) && is_array( $ticket_info['departments'] ) && ! empty( $ticket_info['departments'] ) ) {
				foreach( $ticket_info['departments'] as $ticket_department => $value ) {
					if( isset( $department_emails[ $ticket_department ] ) ) {
						return $department_emails[ $ticket_department ];
					}
				}
				foreach( $ticket_info['departments'] as $ticket_department => $value ) {
					if( isset( $department_emails['all'] ) ) {
						return $department_emails['all'];
					}
				}
				$count = 0;
				foreach( $ticket_info['departments'] as $ticket_department => $value ) {
					$count ++;
					if( $count == 1 ) {
						return reset( $department_emails );
					}
				}
			}

			return $this->noReplyEmailAddress();
		}

		public function processNewTicketEmails( $ticket_id ) {
			$ticket_info = $this->ticketInfo( $ticket_id );
			$company_name = $this->savedOption( 'cjsupport_company_name' );
			$reply_to_address = $this->getReplyToAddress( $ticket_info );
			$message_sep = '';
			if( strpos( $reply_to_address, 'no-reply' ) !== false ) {
				$reply_msg = sprintf( __( '<hr><p>Do not reply to this email<br><a href="%s">Click here</a> to add another comment instead.</p>', 'cjaddons' ), $ticket_info['ticket_url'] );
			} else {
				$message_sep = '<div style="color:#CCCCCC;">-- PLEASE REPLY ABOVE THIS MESSAGE --</div>';
				$reply_msg = sprintf( __( '<hr><p>You can reply to this email or <br><a href="%s">Click here</a> to add another comment.</p>', 'cjaddons' ), $ticket_info['ticket_url'] );
			}

			// send email to agents
			if( isset( $ticket_info['assigned_to'] ) && is_array( $ticket_info['assigned_to'] ) && ! empty( $ticket_info['assigned_to'] ) ) {
				$agent_subject = $this->savedOption( 'cjsupport_new_ticket_email_subject_agent' );
				$agent_subject = $this->parseTicketVariables( $agent_subject, $ticket_info['ID'] );
				$agent_message = $this->savedOption( 'cjsupport_new_ticket_email_message_agent' );
				$agent_message = $this->parseTicketVariables( $agent_message, $ticket_info['ID'] );
				foreach( $ticket_info['assigned_to'] as $key => $agent ) {
					$email_data = array(
						'to' => $agent['user_email'],
						'from_name' => $ticket_info['client_info']['display_name'],
						'from_email' => $ticket_info['client_info']['user_email'],
						'subject' => '[' . $ticket_info['uid'] . '] ' . $agent_subject,
						'message' => $message_sep . $agent_message . $reply_msg,
						'headers' => array(
							'Reply-To' => $reply_to_address
						)
					);
					$this->sendEmail( $email_data );
				}
			}

			// send email to client
			$client_subject = $this->savedOption( 'cjsupport_new_ticket_email_subject_client' );
			$client_subject = $this->parseTicketVariables( $client_subject, $ticket_info['ID'] );
			$client_message = $this->savedOption( 'cjsupport_new_ticket_email_message_client' );
			$client_message = $this->parseTicketVariables( $client_message, $ticket_info['ID'] );
			$email_data = array(
				'to' => $ticket_info['client_info']['user_email'],
				'from_name' => $company_name,
				'from_email' => $reply_to_address,
				'subject' => '[' . $ticket_info['uid'] . '] ' . $client_subject,
				'message' => $message_sep . $client_message . $reply_msg,
				'headers' => array(
					'Reply-To' => $reply_to_address
				)
			);

			$this->sendEmail( $email_data );
		}

		public function processNewCommentEmails( $comment_id ) {
			$one_signal = cjaddons_supportezzy_one_signal::getInstance();
			$comment_info = $this->commentInfo( $comment_id );

			$message_sep = '';

			$ticket_info = $this->ticketInfo( $comment_info['comment_post_ID'] );

			$company_name = $this->savedOption( 'cjsupport_company_name' );
			$reply_to_address = $this->getReplyToAddress( $ticket_info );
			if( strpos( $reply_to_address, 'no-reply' ) !== false ) {
				$reply_msg = sprintf( __( '<hr><p>Do not reply to this email<br><a href="%s">Click here</a> to add another comment instead.</p>', 'cjaddons' ), $ticket_info['ticket_url'] );
			} else {
				$message_sep = '<div style="color:#CCCCCC;">-- PLEASE REPLY ABOVE THIS MESSAGE --</div>';
				$reply_msg = sprintf( __( '<hr><p>You can reply to this email or <br><a href="%s">Click here</a> to add another comment.</p>', 'cjaddons' ), $ticket_info['ticket_url'] );
			}

			$user_roles = $this->userRole( $comment_info['user_id'] );
			$author_is_agent = (is_array( $user_roles ) && in_array( 'support_agent', $user_roles )) ? 1 : 0;
			$author_is_client = (is_array( $user_roles ) && ! in_array( 'support_agent', $user_roles ) && ! in_array( 'administrator', $user_roles )) ? 1 : 0;
			$author_is_admin = (is_array( $user_roles ) && in_array( 'administrator', $user_roles )) ? 1 : 0;

			if( $author_is_admin == 1 && $author_is_agent == 0 && $author_is_client == 0 ) {
				$subject_admin = $this->savedOption( 'cjsupport_new_comment_email_subject_agent' );
				$subject_admin = $this->parseCommentVariables( $subject_admin, $comment_id );
				$message_admin = $this->savedOption( 'cjsupport_new_comment_email_message_agent' );
				$message_admin = $this->parseCommentVariables( $message_admin, $comment_id );
				$email_data = array(
					'to' => $ticket_info['client_info']['user_email'],
					'from_name' => $company_name,
					'from_email' => $this->getReplyToAddress( $ticket_info ),
					'subject' => '[' . $ticket_info['uid'] . '] ' . $subject_admin,
					'message' => $message_sep . $message_admin . $reply_msg,
					'headers' => array(
						'Reply-To' => $this->getReplyToAddress( $ticket_info ),
					)
				);
				$one_signal->sendUserNotification( array($ticket_info['client_info']['ID']), array('en' => $subject_admin), array('url' => $ticket_info['ticket_url']) );
				$this->sendEmail( $email_data );

				foreach( $ticket_info['assigned_to'] as $key => $agent ) {
					$subject_agent = $this->savedOption( 'cjsupport_new_comment_email_subject_agent' );
					$subject_agent = $this->parseCommentVariables( $subject_agent, $comment_id );
					$message_agent = $this->savedOption( 'cjsupport_new_comment_email_message_agent' );
					$message_agent = $this->parseCommentVariables( $message_agent, $comment_id );
					$email_data = array(
						'to' => $agent['user_email'],
						'from_name' => $ticket_info['client_info']['display_name'],
						'from_email' => $ticket_info['client_info']['user_email'],
						'subject' => '[' . $ticket_info['uid'] . '] ' . $subject_agent,
						'message' => $message_sep . $message_agent . $reply_msg,
						'headers' => array(
							'Reply-To' => $this->getReplyToAddress( $ticket_info ),
						)
					);
					$one_signal->sendUserNotification( array($agent['ID']), array('en' => $subject_agent), array('url' => $ticket_info['ticket_url']) );
					$this->sendEmail( $email_data );
				}
			}

			// send email to client
			if( $author_is_agent == 1 ) {
				$subject_client = $this->savedOption( 'cjsupport_new_comment_email_subject_client' );
				$subject_client = $this->parseCommentVariables( $subject_client, $comment_id );
				$message_client = $this->savedOption( 'cjsupport_new_comment_email_message_client' );
				$message_client = $this->parseCommentVariables( $message_client, $comment_id );
				$email_data = array(
					'to' => $ticket_info['client_info']['user_email'],
					'from_name' => $company_name,
					'from_email' => $this->getReplyToAddress( $ticket_info ),
					'subject' => '[' . $ticket_info['uid'] . '] ' . $subject_client,
					'message' => $message_sep . $message_client . $reply_msg,
					'headers' => array(
						'Reply-To' => $this->getReplyToAddress( $ticket_info ),
					)
				);
				$one_signal->sendUserNotification( array($ticket_info['client_info']['ID']), array('en' => $subject_client), array('url' => $ticket_info['ticket_url']) );
				$this->sendEmail( $email_data );
			}

			// send email to agents
			if( $author_is_client == 1 && isset( $ticket_info['assigned_to'] ) && is_array( $ticket_info['assigned_to'] ) && ! empty( $ticket_info['assigned_to'] ) ) {
				foreach( $ticket_info['assigned_to'] as $key => $agent ) {
					$subject_agent = $this->savedOption( 'cjsupport_new_comment_email_subject_agent' );
					$subject_agent = $this->parseCommentVariables( $subject_agent, $comment_id );
					$message_agent = $this->savedOption( 'cjsupport_new_comment_email_message_agent' );
					$message_agent = $this->parseCommentVariables( $message_agent, $comment_id );
					$email_data = array(
						'to' => $agent['user_email'],
						'from_name' => $ticket_info['client_info']['display_name'],
						'from_email' => $ticket_info['client_info']['user_email'],
						'subject' => '[' . $ticket_info['uid'] . '] ' . $subject_agent,
						'message' => $message_sep . $message_agent . $reply_msg,
						'headers' => array(
							'Reply-To' => $this->getReplyToAddress( $ticket_info ),
						)
					);
					$one_signal->sendUserNotification( array($agent['ID']), array('en' => $subject_agent), array('url' => $ticket_info['ticket_url']) );
					$this->sendEmail( $email_data );
				}
			}
		}

		public function autoCloseTickets() {
			$days = $this->savedOption( 'cjsupport_auto_close_ticket' );
			if( $days != '' ) {
				$now = time() - ($days * 24 * 3600);
				$close_date = $this->wpDate( $now, 'M d, Y H:i:s', true );
				$date_query = array(
					'relation' => 'AND',
					array(
						'before' => $close_date,
						'inclusive' => true,
					),
				);
				$comments = get_comments( array(
					'orderby' => 'comment_date',
					'order' => 'DESC',
					'post_type' => 'cjsupport',
					'post_status' => 'publish',
					'author__in' => array_keys( $this->supportAgentsArray() ),
					'date_query' => $date_query,
				) );
				if( ! empty( $comments ) ) {
					foreach( $comments as $key => $comment ) {

						$auto_close_disabled = get_post_meta( $comment->comment_post_ID, 'disable_auto_close', true );
						if( $auto_close_disabled == '' ) {
							$this->dbUpdate( 'posts', array(
								'post_status' => 'closed'
							), 'ID', $comment->comment_post_ID );
							// add auto close comment
							$time = current_time( 'mysql', 0 );
							$message = __( 'Automatically closed by system', 'cjaddons' );
							$no_reply_email = $this->noReplyEmailAddress( 'system' );
							$comment_data = array(
								'comment_post_ID' => $comment->comment_post_ID,
								'comment_author' => 'system',
								'comment_author_email' => $no_reply_email,
								'comment_content' => $message,
								'comment_type' => 'note',
								'user_id' => 0,
								'comment_date' => $time,
								'comment_approved' => 1,
							);
							wp_insert_comment( $comment_data );
						}
					}
				}
			}
		}

	}
}