<?php
/*
 * Class name should be cjaddons_NAME_shortcode
 * Shortcode Tag will be cjaddons_NAME
 * */
if( ! class_exists( 'cjaddons_sample_shortcode' ) ) {
	class cjaddons_sample_shortcode {

		public $defaults, $helpers, $render_forms, $textdomain, $shortcode_tag;

		private static $instance;

		public function defaults() {

			$defaults['info'] = array(
				'single' => true,
				'tag' => $this->shortcode_tag,
				'name' => esc_attr__( 'Sample Shortcode', $this->textdomain ),
				'description' => esc_attr__( '', $this->textdomain ),
				'screenshot' => $this->getScreenshotUrl(),
				'default_content' => '',
				'group' => ucwords(trim(str_replace(array('addon-', '-'), ' ', basename($this->helpers->module_dir)))),
				'textdomain' => 'cjaddons',
				'item_name' => $this->helpers->itemInfo( 'item_name' ),
				'preview' => true,
			);
			$defaults['options'] = array(
				array(
					'type' => 'text',
					'id' => 'textbox',
					'label' => __( 'Text box', 'cjaddons' ),
					'label_suffix' => '<i>' . __( 'This is label suffix', 'cjaddons' ) . '</i>',
					'info' => __( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'cjaddons' ),
					'suffix' => 'suffix',
					'prefix' => '<i class="fa fa-user"></i>',
					'params' => array('placeholder' => 'this is placeholder'),
					'default' => 'default value',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
			);

			return $defaults;
		}

		public static function getInstance() {

			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {

			$this->shortcode_tag = str_replace( '_shortcode', '', get_class( $this ) );
			add_shortcode( $this->shortcode_tag, array($this, 'run') );
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->textdomain = $this->helpers->itemInfo( 'text_domain' );
			$this->defaults = $this->defaults();
		}

		public function getScreenshotUrl() {

			$screen_shot_url = null;
			$screen_shot_path = dirname( __FILE__ ) . '/screenshot.svg';
			if( file_exists( $screen_shot_path ) ) {
				$screen_shot_url = str_replace( WP_CONTENT_DIR, WP_CONTENT_URL, $screen_shot_path );

				return $screen_shot_url;
			}
			$screen_shot_path = dirname( __FILE__ ) . '/screenshot.png';
			if( file_exists( $screen_shot_path ) ) {
				$screen_shot_url = str_replace( WP_CONTENT_DIR, WP_CONTENT_URL, $screen_shot_path );

				return $screen_shot_url;
			}
			$screen_shot_path = dirname( __FILE__ ) . '/screenshot.jpg';
			if( file_exists( $screen_shot_path ) ) {
				$screen_shot_url = str_replace( WP_CONTENT_DIR, WP_CONTENT_URL, $screen_shot_path );

				return $screen_shot_url;
			}

			return $screen_shot_url;
		}

		public function run( $atts, $content = null ) {

			$defaults = array();
			$shortcode_params = $this->defaults();
			foreach( $shortcode_params['options'] as $key => $param ) {
				$default_key = str_replace( '-', '_', $param['id'] );
				$default_value = (is_array( $param['default'] )) ? implode( '|', $param['default'] ) : $param['default'];
				$defaults[ $default_key ] = $default_value;
			}
			$instance = shortcode_atts( $defaults, $atts );
			$output = '';
			$content_file_path = dirname( __FILE__ ) . '/content.php';
			if( file_exists( $content_file_path ) ) {
				ob_start();
				require($content_file_path);
				$output .= ob_get_clean();
				$output = apply_filters( 'cjaddons_shortcode_before_output', $output, $shortcode_params );
				$output = apply_filters( 'cjaddons_shortcode_after_output', $output, $shortcode_params );
			} else {
				$output .= '<div class="alert alert-info">';
				$output .= sprintf( __( 'Shortcode content file not found.<br>%s', 'cjaddons' ), str_replace( dirname( dirname( __FILE__ ) ), '', $content_file_path ) );
				$output .= '</div>';
			}

			return $output;
		}

	}

	cjaddons_sample_shortcode::getInstance();
}