<?php
$file_name = str_replace( '.php', '', basename( __FILE__ ) );
$cjsupport_imap = cjaddons_supportezzy_imap::getInstance();
if( ! $cjsupport_imap->imap_enabled ) {
	echo $this->helpers->alert( 'danger', __( 'PHP Imap extension is not installed on your web server.<br>Please contact your hosting provider to get this extension installed and activated.', 'addon-supportezzy' ), '', '' );

	return;
}

$departments = $this->helpers->getTaxonomyArray( 'cjsupport_departments' );
$departments['all'] = __( 'All Departments', 'addon-supportezzy' );

$products = $this->helpers->getTaxonomyArray( 'cjsupport_products' );
$products['all'] = __( 'All Products', 'addon-supportezzy' );

$action_url = $this->helpers->queryString( $this->helpers->callbackUrl( 'addon-supportezzy', 'cjsupport-configuration-imap' ) );
$imap_connections = $this->helpers->savedOption( 'cjsupport_imap_accounts' );
if( ! is_array( $imap_connections ) ) {
	$imap_connections = array();
}
$imap_message = '';
if( $cjsupport_imap->imap_enabled ) {
	$imap_message = '<span class="color-success">' . __( 'PHP Imap extension is installed and ready to use.', 'addon-supportezzy' ) . '</span>';
}
// test and add imap account
if( isset( $_POST['add_imap_account'] ) ) {
	$email_address = $_POST['imap_email_address'];
	$password = $_POST['imap_password'];
	$server = $_POST['imap_server_port'];
	try {
		$connection = @imap_open( "{" . $server . "/imap/ssl}INBOX", $email_address, $password );
		if( ! $connection ) {
			$imap_error = imap_last_error();
			echo $this->helpers->alert( 'danger', $imap_error, '', '' );
		}
		if( $connection ) {
			echo $this->helpers->alert( 'success', __( 'Connection established and saved.', 'addon-supportezzy' ), '', '' );
			unset( $_POST['add_imap_account'] );
			$imap_connections[ $email_address ] = $_POST;
			$this->helpers->updateOption( 'cjsupport_imap_accounts', $imap_connections );
			foreach( $_POST as $key => $value ) {
				$_POST[ $key ] = '';
			}
			imap_close( $connection );
		}
	} catch( Exception $e ) {
		echo $this->helpers->alert( 'danger', $e->getMessage(), '', '' );
	}
}

// test and update imap account
if( isset( $_POST['update_imap_account'] ) ) {
	$email_address = $_POST['imap_email_address'];
	$password = $_POST['imap_password'];
	$server = $_POST['imap_server_port'];
	try {
		$connection = @imap_open( "{" . $server . "/imap/ssl}INBOX", $email_address, $password );
		if( ! $connection ) {
			echo $this->helpers->alert( 'danger', __( 'Connection to mail server failed.', 'addon-supportezzy' ), '', '' );
		}
		if( $connection ) {
			echo $this->helpers->alert( 'success', __( 'Connection established and saved.', 'addon-supportezzy' ), '', '' );
			unset( $_POST['update_imap_account'] );
			$imap_connections[ $email_address ] = $_POST;
			$this->helpers->updateOption( 'cjsupport_imap_accounts', $imap_connections );
			foreach( $_POST as $key => $value ) {
				$_POST[ $key ] = '';
			}
			imap_close( $connection );
		}
	} catch( Exception $e ) {
		echo $this->helpers->alert( 'danger', $e->getMessage(), '', '' );
	}
}

// delete imap account{
if( isset( $_GET['delete_imap_account'] ) ) {
	unset( $imap_connections[ $_GET['delete_imap_account'] ] );
	$this->helpers->updateOption( 'cjsupport_imap_accounts', $imap_connections );
	wp_redirect( $action_url );
	exit;
}

?>
<table class="cj-table">
    <caption class="color-dark">
		<?php _e( 'Imap Configuration', 'addon-supportezzy' ) ?>
        <div class="pt-5">
            <small class="fs-14"><?php echo $imap_message; ?></small>
            <br>
	        <div class="pt-5 color-red fs-14">
		        <?php _e('We recommend using separate email account via IMAP because all incoming emails to the mailbox will be converted into tickets or comments.', 'addon-supportezzy') ?>
            </div>
        </div>
    </caption>
    <thead>
    <tr>
        <td colspan="5">
	        <div class="text-bold"><?php _e('Setup CRON Job:', 'addon-supportezzy') ?></div>
            <div class="pt-3">
	            <?php
                $cron_url = $this->helpers->queryString(site_url()).'supportezzy_process_imap=1';
                echo sprintf(__('<a href="%s" target="_blank">Click here</a> to create a free account with EasyCron.com and use the following URL to setup the cron job.', 'addon-supportezzy'), 'https://www.easycron.com');
                ?>

                <div class="p-10 bg-light mt-10">
                    <span class="icon is-small"><?php echo $cron_url; ?> <a href="#" data-clipboard-text="<?php echo $cron_url; ?>" data-clipboard-confirmation='<i class="ml-10 fa fa-check color-success"></i>'><i class="ml-10 fa fa-copy"></i></a></span>
                </div>

            </div>
        </td>
    </tr>
    <tr>
        <th width="18%"><?php _e( 'Email Address', 'addon-supportezzy' ) ?></th>
        <th width="18%"><?php _e( 'Password', 'addon-supportezzy' ) ?></th>
        <th width="18%"><?php _e( 'Imap Server Name and Port', 'addon-supportezzy' ) ?></th>
        <th width="31%"><?php _e( 'Select Departments', 'addon-supportezzy' ) ?></th>
        <th width="15%" class="text-center"><?php _e( 'Actions', 'addon-supportezzy' ) ?></th>
    </tr>
    </thead>
    <tbody>
    <form method="post">
        <tr>
            <td>
                <input name="imap_email_address" type="text" class="input mb-0" placeholder="<?php _e( 'you@domain.com', 'addon-supportezzy' ) ?>" value="<?php echo $this->helpers->postDefault( 'imap_email_address', '' ) ?>" required/>
            </td>
            <td>
                <input name="imap_password" type="password" class="input mb-0" placeholder="<?php _e( '**********', 'addon-supportezzy' ) ?>" value="<?php echo $this->helpers->postDefault( 'imap_password', '' ) ?>" required/>
            </td>
            <td>
                <input name="imap_server_port" type="text" class="input mb-0" placeholder="<?php _e( 'imap.domain.com:993', 'addon-supportezzy' ) ?>" value="<?php echo $this->helpers->postDefault( 'imap_server_port', '' ) ?>" required/>
            </td>
            <td>
				<?php
				$departments_field = array(
					'id' => 'departments',
					'type' => 'dropdown',
					'label' => '',
					'params' => array(
						'required' => 1,
						'class' => 'selectize'
					),
					'default' => 'all',
					'options' => $departments,
				);
				echo $this->helpers->formField( $departments_field );
				?>
            </td>
            <td class="text-center">
                <button name="add_imap_account" type="submit" class="button is-fullwidth is-success"><?php _e( 'Test & Add Account', 'addon-supportezzy' ) ?></button>
            </td>
        </tr>
    </form>

	<?php if( ! empty( $imap_connections ) ) { ?>

        <tr>
            <th colspan="5"><?php _e( 'Saved Connections', 'addon-supportezzy' ) ?></th>
        </tr>

		<?php foreach( $imap_connections as $key => $imap_connection ) {
			?>
            <form method="post">
                <tr>
                    <td>
                        <input name="imap_email_address" type="text" class="input mb-0" placeholder="<?php _e( 'you@domain.com', 'addon-supportezzy' ) ?>" value="<?php echo $imap_connection['imap_email_address'] ?>" required/>
                    </td>
                    <td>
                        <input name="imap_password" type="password" class="input mb-0" placeholder="<?php _e( '**********', 'addon-supportezzy' ) ?>" value="<?php echo $imap_connection['imap_password'] ?>" required/>
                    </td>
                    <td>
                        <input name="imap_server_port" type="text" class="input mb-0" placeholder="<?php _e( 'imap.domain.com:993', 'addon-supportezzy' ) ?>" value="<?php echo $imap_connection['imap_server_port'] ?>" required/>
                    </td>
                    <td>
						<?php
						$departments_field = array(
							'id' => 'departments',
							'type' => 'dropdown',
							'label' => '',
							'params' => array(
								'required' => 1,
								'class' => 'selectize'
							),
							'default' => $imap_connection['departments'],
							'options' => $departments,
						);
						echo $this->helpers->formField( $departments_field );
						?>
                    </td>
                    <td class="text-center">
                        <div class="columns is-gapless">
                            <div class="column is-6">
                                <div class="mr-3">
                                    <button name="update_imap_account" type="submit" class="button is-info is-fullwidth"><?php _e( 'Update', 'addon-supportezzy' ) ?></button>
                                </div>
                            </div>
                            <div class="column is-6">
                                <div class="ml-3">
                                    <a href="<?php echo $action_url . 'delete_imap_account=' . $key ?>" type="submit" class="button is-primary is-fullwidth cj-confirm" data-confirm="<?php _e( "Are you sure?\nThis will stop new tickets and all communication for this email address.", 'addon-supportezzy' ) ?>"><?php _e( 'Delete', 'addon-supportezzy' ) ?></a>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
            </form>
		<?php } ?>
	<?php } ?>

    </tbody>

</table>