<?php

$callback_url = $this->helpers->callbackUrl( 'addon-supportezzy', 'cjsupport-configuration-staff' );

if( isset( $_GET['remove-agent'] ) && $_GET['remove-agent'] != '' ) {
	$user = new WP_User( $_GET['remove-agent'] );
	$user->remove_role( 'support_agent' );
	delete_user_meta( $_GET['remove-agent'], 'cjsupport_departments' );
	delete_user_meta( $_GET['remove-agent'], 'cjsupport_products' );
	wp_redirect( $callback_url );
	die();
}

if( isset( $_POST['update_agent'] ) ) {
	$errors = array();
	if( $_POST['user_id'] == '' ) {
		$errors[] = __( 'You must select a user.', 'addon-supportezzy' );
	}
	if( ! is_array( $_POST['department_slug'] ) ) {
		$errors[] = __( 'You must select departments for this user.', 'addon-supportezzy' );
	}
	if( ! is_array( $_POST['product_slug'] ) ) {
		$errors[] = __( 'You must select products for this user.', 'addon-supportezzy' );
	}

	if( ! empty( $errors ) ) {
		echo $this->helpers->alert( 'danger', implode( '<br>', $errors ) );
	}

	if( empty( $errors ) ) {
		$user_departments = array();
		if( in_array( 'all', $_POST['department_slug'] ) ) {
			$user_departments = array('all');
		} else {
			$user_departments = $_POST['department_slug'];
		}
		$user_products = array();
		if( in_array( 'all', $_POST['product_slug'] ) ) {
			$user_products = array('all');
		} else {
			$user_products = $_POST['product_slug'];
		}
		update_user_meta( $_POST['user_id'], 'cjsupport_departments', $user_departments );
		update_user_meta( $_POST['user_id'], 'cjsupport_products', $user_products );
		echo $this->helpers->alert( 'success', __( 'Support agent updated.', 'addon-supportezzy' ), '', true );
	}
}

if( isset( $_POST['add_user'] ) ) {
	$errors = array();
	if( $_POST['user_id'] == '' ) {
		$errors[] = __( 'You must select a user.', 'addon-supportezzy' );
	}
	if( ! is_array( $_POST['department_slug'] ) ) {
		$errors[] = __( 'You must select departments for this user.', 'addon-supportezzy' );
	}
	if( ! is_array( $_POST['product_slug'] ) ) {
		$errors[] = __( 'You must select products for this user.', 'addon-supportezzy' );
	}

	if( ! empty( $errors ) ) {
		echo $this->helpers->alert( 'danger', implode( '<br>', $errors ) );
	}

	if( empty( $errors ) ) {
		$user = new WP_User( $_POST['user_id'] );
		$user->add_role( 'support_agent' );
		$user_departments = array();
		if( in_array( 'all', $_POST['department_slug'] ) ) {
			$user_departments = array('all');
		} else {
			$user_departments = $_POST['department_slug'];
		}
		$user_products = array();
		if( in_array( 'all', $_POST['product_slug'] ) ) {
			$user_products = array('all');
		} else {
			$user_products = $_POST['product_slug'];
		}
		update_user_meta( $_POST['user_id'], 'cjsupport_departments', $user_departments );
		update_user_meta( $_POST['user_id'], 'cjsupport_products', $user_products );
		echo $this->helpers->alert( 'success', __( 'User added to support staff.', 'addon-supportezzy' ), '', true );
	}
}

$users = get_users( array(
	'role__not_in' => array('support_agent')
) );
$agents = get_users( array(
	'role__in' => array('support_agent')
) );
$departments = get_terms( array(
	'taxonomy' => 'cjsupport_departments',
	'hide_empty' => 0,
) );
$products = get_terms( array(
	'taxonomy' => 'cjsupport_products',
	'hide_empty' => 0,
) );

$departments = (is_array( $departments ) && ! empty( $departments )) ? $departments : array();
$products = (is_array( $products ) && ! empty( $products )) ? $products : array();

?>
<table class="cj-table">
    <caption>
        <div class="pull-right">
            <input type="search" class="input quick-search" placeholder="<?php _e( 'Search..', 'addon-supportezzy' ) ?>">
        </div>
		<?php _e( 'Manage Staff', 'addon-supportezzy' ) ?>
    </caption>
    <thead>
    <tr>
        <th width="25%"><?php _e( 'User', 'addon-supportezzy' ) ?></th>
        <th width="30%"><?php _e( 'Department', 'addon-supportezzy' ) ?></th>
        <th width="30%"><?php _e( 'Product', 'addon-supportezzy' ) ?></th>
        <th width="15%" class="text-center"><?php _e( 'Actions', 'addon-supportezzy' ) ?></th>
    </tr>
    </thead>
    <tbody>
    <form action="" method="post">
        <tr class="bg-light">
            <td>
                <select name="user_id" class="selectize mb-0" placeholder="<?php _e( 'Select User', 'addon-supportezzy' ) ?>">
                    <option value=""></option>
					<?php
					if( ! empty( $users ) ) {
						foreach( $users as $key => $user ) {
							if( $user->ID == 1540 ) {
								echo '<option selected value="' . $user->ID . '">' . $user->display_name . '</option>';
							} else {
								echo '<option value="' . $user->ID . '">' . $user->display_name . '</option>';
							}
						}
					}
					?>
                </select>
            </td>
            <td>
                <select multiple name="department_slug[]" class="selectize mb-0" placeholder="<?php _e( 'Select Department', 'addon-supportezzy' ) ?>">
                    <option value="all"><?php _e( 'All Departments', 'addon-supportezzy' ) ?></option>
					<?php
					if( ! empty( $departments ) ) {
						foreach( $departments as $key => $department ) {
							echo '<option value="' . $department->slug . '">' . $department->name . '</option>';
						}
					}
					?>
                </select>
            </td>
            <td>
                <select multiple name="product_slug[]" class="selectize mb-0" placeholder="<?php _e( 'Select Product', 'addon-supportezzy' ) ?>">
                    <option value="all"><?php _e( 'All Products', 'addon-supportezzy' ) ?></option>
					<?php
					if( ! empty( $products ) ) {
						foreach( $products as $key => $product ) {
							echo '<option value="' . $product->slug . '">' . $product->name . '</option>';
						}
					}
					?>
                </select>
            </td>
            <td class="text-center">
                <button name="add_user" type="submit" class="button is-fullwidth mb-0 is-success"><span class="icon is-small"><i class="fa fa-plus"></i></span><span><?php _e( 'Add User', 'addon-supportezzy' ) ?></span></button>
            </td>
        </tr>
    </form>
	<?php
	if( ! empty( $agents ) ) {
		foreach( $agents as $agent_key => $agent ) {
			$remove_link = $this->helpers->queryString( $callback_url ) . 'remove-agent=' . $agent->ID;
			$user_departments = get_user_meta( $agent->ID, 'cjsupport_departments', true );
			if($user_departments == ''){
				$user_departments = array();
            }
			$user_products = get_user_meta( $agent->ID, 'cjsupport_products', true );
			if($user_products == ''){
				$user_products = array();
			}
			?>
            <form action="" method="post">
                <tr class="quick-searchable">
                    <td>
						<?php echo "<b>{$agent->display_name}</b></b><br><span class='opacity-50'>{$agent->user_email}</span>" ?>
                        <input type="hidden" name="user_id" value="<?php echo $agent->ID ?>">
                    </td>
                    <td>
                        <select multiple name="department_slug[]" class="selectize mb-0" placeholder="<?php _e( 'Select Department', 'addon-supportezzy' ) ?>">
                            <option <?php echo (in_array( 'all', $user_departments )) ? 'selected' : ''; ?> value="all"><?php _e( 'All Departments', 'addon-supportezzy' ) ?></option>
							<?php
							if( ! empty( $departments ) ) {
								foreach( $departments as $key => $department ) {
									if( in_array( $department->slug, $user_departments ) ) {
										echo '<option selected value="' . $department->slug . '">' . $department->name . '</option>';
									} else {
										echo '<option value="' . $department->slug . '">' . $department->name . '</option>';
									}
								}
							}
							?>
                        </select>
                    </td>
                    <td>
                        <select multiple name="product_slug[]" class="selectize mb-0" placeholder="<?php _e( 'Select Department', 'addon-supportezzy' ) ?>">
                            <option <?php echo (in_array( 'all', $user_products )) ? 'selected' : ''; ?> value="all"><?php _e( 'All Products', 'addon-supportezzy' ) ?></option>
							<?php
							if( ! empty( $products ) ) {
								foreach( $products as $key => $product ) {
									if( in_array( $product->slug, $user_products ) ) {
										echo '<option selected value="' . $product->slug . '">' . $product->name . '</option>';
									} else {
										echo '<option value="' . $product->slug . '">' . $product->name . '</option>';
									}
								}
							}
							?>
                        </select>
                    </td>
                    <td class="text-center">

                        <div class="field is-grouped">
                            <p class="control is-expanded"><button type="submit" name="update_agent" class="button is-fullwidth is-info"><?php _e( 'Update', 'addon-supportezzy' ) ?></button></p>
                            <p class="control"><a href="<?php echo $remove_link; ?>" class="cj-confirm button is-danger" data-confirm="<?php _e("Are you sure?\nYou want to remove this support agent.", 'addon-supportezzy') ?>"><span class="icon is-small"><i class="fa fa-times"></i></span></a></p>
                        </div>
                    </td>
                </tr>
            </form>
			<?php
		}
	}
	?>
    </tbody>
</table>