<?php
if( ! class_exists( 'cjaddons_rest_cjsupport_auth' ) ) {
	class cjaddons_rest_cjsupport_auth {

		public $helpers, $module_dir, $routes, $api_url, $module_info;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->module_info = $this->helpers->moduleInfo( basename( $this->helpers->module_dir ) );
			$this->api_url = '';
			if( function_exists( 'using_index_permalinks' ) ) {
				$this->api_url = rest_url( 'cjaddons' ) . '/';
			}
			$this->routes = array(
				'cjsupport-login' => array(
					'endpoint' => $this->module_info['module_id'] . '/login',
					'name' => sprintf( __( '%s Login', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'addon-supportezzy' ),
					'methods' => array(
						'post' => array($this, 'login'), // callback function
					),
					'permissions' => function () {
						return true;
						// return current_user_can( 'manage_options' );
					},
				),
				'cjsupport-logout' => array(
					'endpoint' => $this->module_info['module_id'] . '/logout',
					'name' => sprintf( __( '%s Login', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'addon-supportezzy' ),
					'methods' => array(
						'get' => array($this, 'logout'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-me' => array(
					'endpoint' => $this->module_info['module_id'] . '/me',
					'name' => sprintf( __( '%s Login', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'addon-supportezzy' ),
					'methods' => array(
						'post' => array($this, 'me'), // callback function
					),
					'permissions' => function ( $request ) {
						$token = $request->get_header( 'x_authorization' );
						$user = $this->helpers->getUserByToken( $token );

						return ( ! empty( $user )) ? true : false;
					},
				),
			);
			add_filter( 'cjaddons_register_api_route', array($this, 'registerRoute') );
		}

		public function registerRoute( $routes ) {
			$routes = array_merge( $routes, $this->routes );

			return $routes;
		}

		public function login( $request ) {
			$auth = $this->helpers->login( $request['user_login'], $request['user_pass'] );
			$data = [];
			if( $auth ) {
				$fields = $request['fields'];
				$user_info = $this->helpers->userInfo( $auth );
				$data['access_token'] = $user_info['access_token'];
				$default_fields = explode( ',', $this->helpers->userInfoDefaultFields() );
				foreach( $default_fields as $key => $value ) {
					$value = trim( $value );
					$data[ $value ] = (isset($user_info[ $value ])) ? $user_info[ $value ] : '';
				}
				if( ! empty( $fields ) ) {
					$fields = explode( ',', $fields );
					foreach( $fields as $key => $value ) {
						$value = trim( $value );
						$data[ $value ] = $user_info[ $value ];
					}
				}
				$user_roles = $this->helpers->userRole( $user_info['ID'] );
				$data['roles'] = $user_roles;

				$data['is_agent'] = (is_array( $user_roles ) && in_array( 'support_agent', $user_roles )) ? 1 : 0;
				$data['is_client'] = (is_array( $user_roles ) && ! in_array( 'support_agent', $user_roles ) && ! in_array( 'administrator', $user_roles )) ? 1 : 0;
				$data['is_admin'] = (is_array( $user_roles ) && in_array( 'administrator', $user_roles )) ? 1 : 0;

				return $this->helpers->apiResponse( $request, $data );
			}
		}

		public function logout( $request ) {
			wp_logout();
			$data['logged_out'] = 1;

			return $this->helpers->apiResponse( $request, $data );
		}

	}

	cjaddons_rest_cjsupport_auth::getInstance();
}