<?php
if( ! class_exists( 'cjaddons_rest_cjsupport_notifications' ) ) {
	class cjaddons_rest_cjsupport_notifications {

		public $helpers, $module_dir, $routes, $api_url, $module_info, $one_signal;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->module_info = $this->helpers->moduleInfo( basename( $this->helpers->module_dir ) );
			require_once sprintf( '%s/autoload/one-signal.php', $this->helpers->module_dir );
			$this->one_signal = cjaddons_supportezzy_one_signal::getInstance();
			$this->api_url = '';
			if( function_exists( 'using_index_permalinks' ) ) {
				$this->api_url = rest_url( 'cjaddons' ) . '/';
			}
			$this->routes = array(
				'cjsupport-send-user-notification' => array(
					'endpoint' => $this->module_info['module_id'] . '/send-user-notification',
					'name' => sprintf( __( '%s Notifications - Add Device', 'addon-supportezzy' ), $this->module_info['module_name'] ),
					'description' => __( 'Adds a device.', 'addon-supportezzy' ),
					'methods' => array(
						'post' => array($this, 'sendUserNotification'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
			);
			add_filter( 'cjaddons_register_api_route', array($this, 'registerRoute') );
		}

		public function registerRoute( $routes ) {
			$routes = array_merge( $routes, $this->routes );

			return $routes;
		}

		public function sendUserNotification( $request ) {
			$data = array();
			$errors = array();
			if( $request['message'] == '' ) {
				$errors[] = __( 'You must specify notes for the reminder.', 'cjaddons' );
			}
			if( $request['params']['send_after'] == '' ) {
				$errors[] = __( 'You must specify date and time for the reminder.', 'cjaddons' );
			}
			if( ! empty( $errors ) ) {
				return $this->helpers->apiResponse( $request, array('errors' => implode( '<br>', $errors )) );
			}

			if( empty( $errors ) ) {
				$content['en'] = $request['message'];
				$params = $request['params'];
				$data['send_after'] = (string) $request['params']['send_after'];
				$data['notification'] = $this->one_signal->sendUserNotification( $request['user_ids'], $content, $params );

				return $this->helpers->apiResponse( $request, $data );
			}
		}
	}

	cjaddons_rest_cjsupport_notifications::getInstance();
}