<?php
if( ! class_exists( 'cjaddons_rest_cjsupport_tickets' ) ) {
	class cjaddons_rest_cjsupport_tickets {

		public $helpers, $module_dir, $routes, $api_url, $module_info;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->module_info = $this->helpers->moduleInfo( basename( $this->helpers->module_dir ) );
			$this->api_url = '';
			if( function_exists( 'using_index_permalinks' ) ) {
				$this->api_url = rest_url( 'cjaddons' ) . '/';
			}
			$this->routes = array(
				'cjsupport-tickets' => array(
					'endpoint' => $this->module_info['module_id'] . '/tickets',
					'name' => sprintf( __( '%s Login', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'getTickets'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo($request);

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-ticket' => array(
					'endpoint' => $this->module_info['module_id'] . '/ticket',
					'name' => sprintf( __( '%s Ticket', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'ticket'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo($request);

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-ticket-update-data' => array(
					'endpoint' => $this->module_info['module_id'] . '/ticket-update-data',
					'name' => sprintf( __( '%s Update Ticket Meta', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'ticketsUpdateData'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo($request);

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-ticket-create' => array(
					'endpoint' => $this->module_info['module_id'] . '/ticket-create',
					'name' => sprintf( __( '%s Create ticket', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( '', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'createTicket'), // callback function
					),
					'permissions' => function ( $request ) {
						return true;
					},
				),
				'cjsupport-ticket-toggle-star' => array(
					'endpoint' => $this->module_info['module_id'] . '/ticket-toggle-star',
					'name' => sprintf( __( '%s Toggle Star', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( '', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'toggleTicketStars'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-comments' => array(
					'endpoint' => $this->module_info['module_id'] . '/comments',
					'name' => sprintf( __( '%s Comments', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'getComments'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo($request);

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-add-comment' => array(
					'endpoint' => $this->module_info['module_id'] . '/add-comment',
					'name' => sprintf( __( '%s Comments', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Accept user_login and user_pass to authenticate a user.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'addComment'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-update-comment' => array(
					'endpoint' => $this->module_info['module_id'] . '/update-comment',
					'name' => sprintf( __( '%s Rate Comment', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Updates comment rating.', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'updateCommentInfo'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				),
				'cjsupport-verify-envato-purchase-code' => array(
					'endpoint' => $this->module_info['module_id'] . '/verify-envato-purchase-code',
					'name' => sprintf( __( '%s Verify Envato', 'cjaddons' ), $this->module_info['module_name'] ),
					'description' => __( 'Verify envato purchase code', 'cjaddons' ),
					'methods' => array(
						'post' => array($this, 'verifyEnvatoPurchaseCode'), // callback function
					),
					'permissions' => function ( $request ) {
						$user = $this->helpers->getApiUserInfo( $request );

						return ( ! empty( $user )) ? true : false;
					},
				)
			);
			add_filter( 'cjaddons_register_api_route', array($this, 'registerRoute') );
		}

		public function registerRoute( $routes ) {
			$routes = array_merge( $routes, $this->routes );

			return $routes;
		}

		public function createTicket( $request ) {
			$errors = array();
			$user_info = $this->helpers->getApiUserInfo( $request );

			$post_data = $request->get_params();

			if( isset( $post_data['post_author'] ) && $post_data['post_author'] == '' ) {
				$errors['post_author'] = __( 'Please select a client account for which you would like to create this ticket.', 'cjaddons' );
			}

			// check if user_email is specified.
			$author_info = array();
			if( isset( $request['user_email'] ) ) {
				$author_email = $request['user_email'];
				$author_info = $this->helpers->userInfo( $author_email );
				if( empty( $author_info ) ) {
					$author_login = $this->helpers->uniqueUsername( $author_email );
					$author_pass = wp_generate_password( 12, true );
					$author_data = array(
						'first_name' => (isset( $request['first_name'] )) ? $request['first_name'] : '',
						'last_name' => (isset( $request['last_name'] )) ? $request['last_name'] : '',
					);
					$this->helpers->createNewAccount( $author_login, $author_email, $author_pass, $author_data, true, 'both' );
					$author_info = $this->helpers->userInfo( $author_login );
				}
			}

			if( isset( $author_info['cjaddons_user_salt'] ) && $author_info['cjaddons_user_salt'] != '' ) {
				$salt = base64_decode( $author_info['cjaddons_user_salt'] );
				$this->helpers->loginWithSalt( $author_info['ID'], $salt );
			}

			$author_info = $this->helpers->userInfo( $author_info['ID'] );
			$required_fields = array('first_name', 'last_name', 'user_email', 'post_title', 'post_content');
			foreach( $required_fields as $key => $required_field ) {
				if( ! isset( $request[ $required_field ] ) ) {
					$errors['required_fields'] = __( 'Missing required fields.', 'cjaddons' );
				}
			}

			if( isset( $request['post_title'] ) && $request['post_title'] == '' ) {
				$errors['post_title'] = __( 'You must specify ticket title.', 'cjaddons' );
			}
			if( isset( $request['post_content'] ) && $request['post_content'] == '' ) {
				$errors['post_content'] = __( 'You must specify ticket description.', 'cjaddons' );
			}

			$api_key = $this->helpers->savedOption( 'cjsupport_google_recaptcha_key' );
			$api_secret = $this->helpers->savedOption( 'cjsupport_google_recaptcha_secret' );
			if( $api_key != '' && $api_secret != '' ) {
				$reCAPTCHA = new reCAPTCHA( $api_key, $api_secret );
				$theme = 'light';
				$language = 'en';
				$reCAPTCHA->setTheme( $theme );
				$reCAPTCHA->setLanguage( $language );
				if( ! $reCAPTCHA->isValid( $request['g-recaptcha-response'] ) ) {
					$errors['cjsupport_google_recaptcha'] = __( 'You must verify that you are human.', 'cjaddons' );
				}
			}

			// form builder checks
			if( isset( $request['form_builder_form_id'] ) && $request['form_builder_form_id'] != '' && class_exists( 'cjaddons_form_builder_helpers' ) ) {
				$form_builder_helpers = cjaddons_form_builder_helpers::getInstance();
				$form_id = $request['form_builder_form_id'];
				$form_info = $this->helpers->postInfo( $form_id );
				if( isset( $form_info['_form_fields'] ) ) {
					$form_fields = $form_builder_helpers->getFormFields( $form_id );
					$validation_rules = array();
					foreach( $form_fields as $key => $form_field ) {
						if( isset( $form_field['validation_rules'] ) ) {
							$validation_rules[ 'form_builder_' . $form_field['id'] ] = $form_builder_helpers->prepareValidationRules( $form_field['validation_rules'] );
						}
					}
					$form_options = array();
					foreach( $form_fields as $key => $field ) {
						$form_options[ 'form_builder_' . $field['id'] ] = $field;
						$form_options[ 'form_builder_' . $field['id'] ]['id'] = 'form_builder_' . $field['id'];
					}
					$validation_errors = $this->helpers->validateFormWithGump( $post_data, $validation_rules, $form_options, 'messages' );
					if( ! empty( $validation_errors ) ) {
						$errors = $validation_errors;
					}

					if( isset( $form_options['form_builder_qna_answer'] ) && isset( $form_options['form_builder_qna_answer']['answer'] ) ) {
						if( isset( $post_data['form_builder_qna_answer'] ) && $post_data['form_builder_qna_answer'] != $form_options['form_builder_qna_answer']['answer'] ) {
							$errors['form_builder_qna_answer'] = __( 'Invalid answer, please check and try again.', 'cjaddons' );
						}
					}
				}
			}

			// if errors return api error
			if( ! empty( $errors ) ) {
				$data = array(
					'messages' => implode( '<br>', $errors ),
					'error_fields' => array_keys( $errors ),
				);

				return $this->helpers->apiError( $request, 206, implode( '<br>', $errors ), 206, $data );
			}

			$new_ticket_data = array(
				'post_title' => urldecode( trim( $request['post_title'] ) ),
				'post_name' => sanitize_title( trim( $request['post_title'] ) ),
				'post_type' => 'cjsupport',
				'post_content' => wpautop( urldecode( $request['post_content'] ) ),
				'post_author' => (isset( $request['post_author'] ) && $request['post_author'] != '') ? $request['post_author'] : $author_info['ID'],
				'post_status' => 'publish',
			);
			$new_ticket_data['meta_input']['_uid'] = strtoupper( $this->helpers->uniqueString() );
			$new_ticket_data['meta_input']['_priority'] = (isset( $request['_priority'] )) ? $request['_priority'] : 24;
			$new_ticket_data['meta_input']['_department'] = (isset( $request['_department'] )) ? $request['_department'] : '';
			$new_ticket_data['meta_input']['_product'] = (isset( $request['_product'] )) ? $request['_product'] : '';
			$new_ticket_data['meta_input']['cjsupport_migrated'] = 1;
			$new_post_id = wp_insert_post( $new_ticket_data );
			if( isset( $request['_department'] ) && $request['_department'] != '' && $request['_department'] != 'all' ) {
				wp_set_object_terms( $new_post_id, $request['_department'], 'cjsupport_departments', false );
			}
			if( isset( $request['_product'] ) && $request['_product'] != '' && $request['_product'] != 'all' ) {
				wp_set_object_terms( $new_post_id, $request['_product'], 'cjsupport_products', false );
			}

			if( isset( $request['attachments'] ) && ! empty( $request['attachments'] ) ) {
				$data['attachments'] = $request['attachments'];
				update_post_meta( $new_post_id, '_attachments', $request['attachments'] );
			}

			if( isset( $request['additional_data'] ) && is_array( $request['additional_data'] ) && ! empty( $request['additional_data'] ) ) {
				foreach( $request['additional_data'] as $a_key => $a_value ) {
					update_post_meta( $new_post_id, $a_key, $a_value );
				}
			}

			$ticket_info = $this->helpers->postInfo( $new_post_id );
			$assign_to = $this->helpers->assignTicketTo( $ticket_info );
			update_post_meta( $new_post_id, '_assigned_to', '' );

			if( ! is_array( $assign_to ) ) {
				update_post_meta( $new_post_id, '_assigned_to', '' );
			}
			if( is_array( $assign_to ) && ! empty( $assign_to ) ) {
				update_post_meta( $new_post_id, '_assigned_to', $assign_to );
			}

			if( ! empty( $user_info ) && in_array( $user_info['ID'], $this->helpers->supportAgentsArray() ) ) {
				update_post_meta( $new_post_id, '_assigned_to', array($user_info['ID'] => $user_info['user_login']) );
			}

			$data['access_token'] = $author_info['access_token'];
			$data['ticket_id'] = $new_post_id;

			foreach( $_POST as $key => $value ) {
				if( ! in_array( $key, array_keys( $ticket_info ) ) ) {
					$value = ( ! is_array( $value )) ? urldecode( $value ) : $value;
					update_post_meta( $new_post_id, $key, $value );
				}
			}

			// send emails
			$this->helpers->processNewTicketEmails( $new_post_id );

			return $this->helpers->apiResponse( $request, $data );
		}

		public function getTickets( $request ) {
			$data = array();
			$user_info = $this->helpers->getApiUserInfo( $request );
			$query_args = array(
				'post_type' => 'cjsupport',
				'posts_per_page' => get_option( 'posts_per_page' ),
				'orderby' => 'post_date',
				'order' => 'DESC',
			);

			foreach( $request['query'] as $k => $v ) {
				$query_args[ $k ] = $v;
			}

			if( isset( $request['query']['_assigned_to'] ) && $request['query']['_assigned_to'] != '' ) {
				$query_args['meta_query'][] = array(
					'key' => '_assigned_to',
					'value' => $request['query']['_assigned_to'],
					'compare' => 'LIKE',
				);
			}
			if( isset( $request['query']['_priority'] ) && $request['query']['_priority'] != '' ) {
				$query_args['meta_query'][] = array(
					'key' => '_priority',
					'value' => $request['query']['_priority'],
					'compare' => 'LIKE',
				);
			}
			if( isset( $request['query']['_department'] ) && $request['query']['_department'] != '' ) {
				$query_args['tax_query'][] = array(
					'taxonomy' => 'cjsupport_departments',
					'field' => 'slug',
					'terms' => array($request['query']['_department']),
				);
			}
			if( isset( $request['query']['_product'] ) && $request['query']['_product'] != '' ) {
				$query_args['tax_query'][] = array(
					'taxonomy' => 'cjsupport_products',
					'field' => 'slug',
					'terms' => array($request['query']['_product']),
				);
			}
			if( isset( $request['query']['search'] ) && $request['query']['search'] != '' ) {
				$query_args['s'] = $request['query']['search'];
			}
			if( isset( $request['query']['post_status'] ) && $request['query']['post_status'] != '' ) {
				if( $request['query']['post_status'] == 'any' ) {
					$query_args['post_status'] = array('publish', 'closed');
				} else {
					$query_args['post_status'] = $request['query']['post_status'];
				}
			}

			$start_date = (isset( $request['query']['_start_date'] )) ? $request['query']['_start_date'] : '';
			$start_date = str_replace( '+', ' ', $start_date );

			$end_date = (isset( $request['query']['_end_date'] )) ? $request['query']['_end_date'] : '';
			$end_date = str_replace( '+', ' ', $end_date );

			$query_args['date_query'] = array(
				'after' => $start_date,
				'before' => $end_date,
				'inclusive' => true,
			);

			if( isset( $request['query']['_uid'] ) && $request['query']['_uid'] != '' ) {
				$query_args = array(
					'post_type' => 'cjsupport'
				);
				$query_args['meta_query'][] = array(
					'key' => '_uid',
					'value' => $request['query']['_uid'],
					'compare' => '=',
				);
			}
			$query_args['paged'] = (isset( $query_args['paged'] )) ? $query_args['paged'] : 1;
			if( isset( $request['query']['save_filter'] ) && $request['query']['save_filter'] != '' ) {
				$filter_name = urldecode( $request['query']['save_filter'] );
				$user_filters = get_user_meta( $user_info['ID'], 'cjsupport_tickets_filters', true );
				if( $user_filters == '' ) {
					$user_filters = array();
				}
				$user_filters[ $filter_name ] = $query_args;
				update_user_meta( $user_info['ID'], 'cjsupport_tickets_filters', $user_filters );
			}
			$data['query_args'] = $query_args;
			$the_query = new WP_Query( $query_args );
			$posts = array();
			if( $the_query->have_posts() ) {
				$count = - 1;
				while( $the_query->have_posts() ) {
					$count ++;
					$the_query->the_post();
					global $post;
					$ticket_info = $this->helpers->ticketInfo( $post->ID );
					$posts[ $count ] = $ticket_info;
				}
				if( is_array( $posts ) && ! empty( $posts ) ) {
					$data['posts'] = $posts;
					$data['query_args'] = $query_args;
					$data['post_count'] = $the_query->post_count;
					$data['total_posts'] = (int) $the_query->found_posts;

					$data['pagination'] = array();
					// pagination data
					$total_pages = $the_query->max_num_pages;
					$current_page = (int) $the_query->query['paged'];
					$next_page = $the_query->query['paged'] + 1;
					$previous_page = $the_query->query['paged'] - 1;
					if( $next_page > $total_pages ) {
						$next_page = null;
					}
					if( $previous_page <= 0 ) {
						$previous_page = null;
					}
					$data['pagination']['total_pages'] = $total_pages;
					$data['pagination']['current_page'] = $current_page;
					$data['pagination']['next_page'] = $next_page;
					$data['pagination']['previous_page'] = $previous_page;
				}

				wp_reset_postdata();
			}

			$total_query_args = array(
				'post_type' => 'cjsupport',
				'post_status' => 'publish',
				'posts_per_page' => - 1,
			);
			$total_inbox = get_posts( $total_query_args );
			$total_yours = get_posts( array(
				'post_type' => 'cjsupport',
				'post_status' => 'publish',
				'posts_per_page' => - 1,
				'meta_query' => array(
					array(
						'key' => '_assigned_to',
						'value' => $user_info['user_login'],
						'compare' => 'LIKE',
					)
				),
			) );
			$total_not_assigned = get_posts( array(
				'post_type' => 'cjsupport',
				'post_status' => 'publish',
				'posts_per_page' => - 1,
				'meta_query' => array(
					array(
						'key' => '_assigned_to',
						'value' => '',
						'compare' => '=',
					)
				),
			) );

			// awaiting response and delayed
			$total_user_published_posts = get_posts( array(
				'post_type' => 'cjsupport',
				'post_status' => 'publish',
				'posts_per_page' => - 1,
				/*'meta_query' => array(
					array(
						'key' => '_assigned_to',
						'value' => $user_info['user_login'],
						'compare' => 'LIKE',
					)
				),*/
			) );
			$total_awaiting_response = array();
			$awaiting_response_posts = array();
			$delayed_posts = array();
			$now = time();
			foreach( $total_user_published_posts as $tpp_key => $tpp_post ) {
				$ticket_priority = get_post_meta( $tpp_post->ID, '_priority', true );
				if( $ticket_priority == '' ) {
					$ticket_priority = 48;
				}
				if( $tpp_post->comment_count == 0 ) {
					$ticket_post_info = $this->helpers->ticketInfo( $tpp_post->ID );
					// awaiting response
					$total_awaiting_response[] = 1;
					$awaiting_response_posts[] = $ticket_post_info;
					// delayed
					$answer_time = strtotime( $tpp_post->post_date ) + ($ticket_priority + 3600);
					if( $now > $answer_time ) {
						$delayed_posts[ $tpp_post->ID ] = $ticket_post_info;
					}
				}
				$last_comment = get_comments( array(
					'post_id' => $tpp_post->ID,
					'orderby' => 'comment_date',
					'order' => 'DESC',
					'number' => 1,
				) );
				if( ! empty( $last_comment ) ) {
					foreach( $last_comment as $lc_key => $lc_value ) {
						if( $lc_value->user_id == $tpp_post->post_author ) {
							$ticket_post_info = $this->helpers->ticketInfo( $tpp_post->ID );
							$answer_time = strtotime( $lc_value->comment_date ) + ($ticket_priority + 3600);
							if( $now > $answer_time ) {
								$delayed_posts[ $tpp_post->ID ] = $ticket_post_info;
							}
							$total_awaiting_response[] = 1;
							$awaiting_response_posts[] = $ticket_post_info;
						}
					}
				}
			}
			if( isset( $request['query']['awaiting_response'] ) && $request['query']['awaiting_response'] == 1 ) {
				$data['posts'] = array();
				$data['posts'] = $awaiting_response_posts;
				$data['pagination'] = array();
			}
			if( isset( $request['query']['delayed'] ) && $request['query']['delayed'] == 1 ) {
				$data['posts'] = array();
				$data['posts'] = $delayed_posts;
				$data['pagination'] = array();
			}

			$data['filter_bar_numbers']['inbox'] = count( $total_inbox );
			$data['filter_bar_numbers']['yours'] = count( $total_yours );
			$data['filter_bar_numbers']['not_assigned'] = count( $total_not_assigned );
			$data['filter_bar_numbers']['awaiting_response'] = count( $total_awaiting_response );
			$data['filter_bar_numbers']['delayed'] = count( $delayed_posts );

			return $this->helpers->apiResponse( $request, $data );
		}

		public function ticket( $request ) {
			$data = $this->helpers->ticketInfo( $request['ticket_id'] );
			$ticket_content = strip_tags( $data['post_content'], '<p><a><img><br>' );
			//$ticket_content = preg_replace( '#<br />(\s*<br />)+#', '<br />', $ticket_content );
			$ticket_content = str_replace( array('&nbsp;', "&nbsp;", "\n", "\t"), '', $ticket_content );
			$data['post_content'] = $ticket_content;

			return $this->helpers->apiResponse( $request, $data );
		}

		public function ticketsUpdateData( $request ) {
			$time = current_time( 'mysql', 0 );
			$user_info = $this->helpers->getApiUserInfo( $request );
			$ticket_info = $this->helpers->ticketInfo( $request['post_id'] );

			if( isset( $request['post_data']['post_status'] ) && $request['post_data']['post_status'] == 'closed' ) {
				// add note
				update_post_meta( $request['post_id'], 'disable_auto_close', 1 );
				$message = sprintf( __( '%s closed the ticket.', 'cjaddons' ), $user_info['display_name'] );
				$comment_data = array(
					'comment_post_ID' => $ticket_info['ID'],
					'comment_author' => $user_info['user_login'],
					'comment_author_email' => $user_info['user_email'],
					'comment_content' => $message,
					'comment_type' => 'note',
					'user_id' => $user_info['ID'],
					'comment_date' => $time,
					'comment_approved' => 1,
				);
				wp_insert_comment( $comment_data );
			}

			if( isset( $request['post_data']['post_status'] ) && $request['post_data']['post_status'] == 'publish' ) {
				// add note
				update_post_meta( $request['post_id'], 'disable_auto_close', 1 );
				$message = sprintf( __( '%s opened the ticket.', 'cjaddons' ), $user_info['display_name'] );
				$comment_data = array(
					'comment_post_ID' => $ticket_info['ID'],
					'comment_author' => $user_info['user_login'],
					'comment_author_email' => $user_info['user_email'],
					'comment_content' => $message,
					'comment_type' => 'note',
					'user_id' => $user_info['ID'],
					'comment_date' => $time,
					'comment_approved' => 1,
				);
				wp_insert_comment( $comment_data );
			}

			// update assigned users
			if( isset( $request['post_data']['_assigned_to'] ) ) {
				// user added
				if( is_array( $ticket_info['assigned_to'] ) && count( $ticket_info['assigned_to'] ) < count( $request['post_data']['_assigned_to'] ) ) {
					$new_users = array();
					foreach( $request['post_data']['_assigned_to'] as $u_key => $u_value ) {
						if( ! in_array( $u_key, array_keys( $ticket_info['assigned_to'] ) ) ) {
							$new_user_display_names = $this->helpers->userInfo( $u_key )['display_name'];
							$new_users[] = $new_user_display_names;
						}
					}
					$message = sprintf( __( '%s added %s', 'cjaddons' ), $user_info['display_name'], implode( ', ', $new_users ) );
					$comment_data = array(
						'comment_post_ID' => $ticket_info['ID'],
						'comment_author' => $user_info['user_login'],
						'comment_author_email' => $user_info['user_email'],
						'comment_content' => $message,
						'comment_type' => 'note',
						'user_id' => $user_info['ID'],
						'comment_date' => $time,
						'comment_approved' => 1,
					);
					wp_insert_comment( $comment_data );
				}

				// user removed
				if( is_array( $ticket_info['assigned_to'] ) && count( $ticket_info['assigned_to'] ) > count( $request['post_data']['_assigned_to'] ) ) {
					$removed_users = array();
					foreach( $ticket_info['assigned_to'] as $u_key => $u_value ) {
						if( ! in_array( $u_key, array_keys( $request['post_data']['_assigned_to'] ) ) ) {
							$new_user_display_names = $this->helpers->userInfo( $u_key )['display_name'];
							$removed_users[] = $new_user_display_names;
						}
					}
					$message = sprintf( __( '%s removed %s', 'cjaddons' ), $user_info['display_name'], implode( ', ', $removed_users ) );
					$comment_data = array(
						'comment_post_ID' => $ticket_info['ID'],
						'comment_author' => $user_info['user_login'],
						'comment_author_email' => $user_info['user_email'],
						'comment_content' => $message,
						'comment_type' => 'note',
						'user_id' => $user_info['ID'],
						'comment_date' => $time,
						'comment_approved' => 1,
					);
					wp_insert_comment( $comment_data );
				}
			}

			$this->helpers->updatePostInfo( $request['post_id'], $request['post_data'] );
			$data['success'] = 1;

			return $this->helpers->apiResponse( $request, $data );
		}

		public function getComments( $request ) {
			$data = array();
			$number_of_comments = 3;
			$query_args = array(
				'status' => 'all',
				'number' => $number_of_comments,
				'orderby' => 'comment_date',
				'order' => 'DESC',
			);

			if( isset( $request['query_args'] ) && is_array( $request['query_args'] ) && ! empty( $request['query_args'] ) ) {
				foreach( $request['query_args'] as $key => $query_arg ) {
					$query_args[ $key ] = $query_arg;
				}
			}

			$data['query_args'] = $query_args;

			$total_query_args = $query_args;
			$total_query_args['number'] = '';

			$comments = get_comments( $query_args );
			$total_comments = get_comments( $total_query_args );

			$data['total_comments'] = count( $total_comments );
			$data['hidden_comments'] = count( $total_comments ) - count( $comments );

			if( ! empty( $comments ) ) {
				foreach( $comments as $key => $comment ) {
					$data['comments'][ $comment->comment_ID ] = $this->helpers->commentInfo( $comment->comment_ID, array(), explode( ',', $this->helpers->userInfoDefaultFields() ) );
					$comment_content = strip_tags( $data['comments'][ $comment->comment_ID ]['comment_content'], '<p><a><img><br>' );
					//$comment_content = preg_replace( '#<br />(\s*<br />)+#', '<br />', $comment_content );
					$comment_content = str_replace( array('&nbsp;'), '', $comment_content );
					//$comment_content = preg_replace('/(^|\s)\{/faq:([0-9]+:+([A-Za-z0-9\s.?!@#$%^&*()_+]+))/i','', $comment_content);
					$data['comments'][ $comment->comment_ID ]['comment_content'] = $comment_content;
				}
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function addComment( $request ) {
			$errors = array();
			if( $request['comment_content'] == '' ) {
				$errors['comment_content'] = __( 'Comment field cannot be blank.', 'cjaddons' );
			}

			if( ! empty( $errors ) ) {
				$data = array();
				$data['errors'] = implode( '<br>', $errors );

				return $this->helpers->apiResponse( $request, $data );
			} else {
				$time = current_time( 'mysql', 0 );
				$api_user_info = $this->helpers->getApiUserInfo( $request );
				$comment_content = $this->helpers->parseUserTagString( $request['comment_content'] );
				$comment_content = $this->helpers->parseFaqString( $comment_content );

				// update ticket assignments
				preg_match_all( '/(^|\s)@([a-z0-9_]+)/i', $request['comment_content'], $match );
				if( is_array( $match[0] ) ) {
					$assigned_to = get_post_meta( $request['comment_post_ID'], '_assigned_to', true );
					foreach( $match[0] as $key => $match ) {
						$user_login = str_replace( '@', '', $match );
						$user_login = trim( $user_login );
						$assigned_user_info = $this->helpers->userInfo( $user_login );
						if( ! empty( $assigned_user_info ) ) {
							$assigned_to[ $assigned_user_info['ID'] ] = $assigned_user_info['user_login'];
						}
					}
					update_post_meta( $request['comment_post_ID'], '_assigned_to', $assigned_to );
				}

				$data = array(
					'comment_post_ID' => $request['comment_post_ID'],
					'comment_author' => $api_user_info['user_login'],
					'comment_author_email' => $api_user_info['user_email'],
					'comment_content' => $comment_content,
					'comment_type' => $request['comment_type'],
					'user_id' => $api_user_info['ID'],
					'comment_date' => $time,
					'comment_approved' => 1,
				);
				$comment_id = wp_insert_comment( $data );
				$data['success'] = $comment_id;

				// attachments
				if( isset( $request['attachments'] ) && ! empty( $request['attachments'] ) ) {
					$data['attachments'] = $request['attachments'];
					update_comment_meta( $comment_id, '_attachments', $request['attachments'] );
				}

				// archive ticket
				if( isset( $request['archive_ticket'] ) && $request['archive_ticket'] == 1 ) {
					$this->helpers->dbUpdate( 'posts', array('post_status' => 'closed'), 'ID', $request['comment_post_ID'] );
				}

				$this->helpers->processNewCommentEmails( $comment_id );
			}

			return $this->helpers->apiResponse( $request, $data );
		}

		public function updateCommentInfo( $request ) {
			$data = $this->helpers->updateCommentInfo( $request['comment_id'], $request['data'] );

			return $this->helpers->apiResponse( $request, $data );
		}

		public function verifyEnvatoPurchaseCode( $request ) {
			$envato = cjaddons_supportezzy_envato::getInstance();
			$response = $envato->api( 'get', 'v3/market/author/sale?code=' . $request['code'] );
			$response = json_decode( $response );

			if( isset( $response->error ) ) {
				$data['error'] = $response->description;

				return $this->helpers->apiResponse( $request, $data );
			}

			if( ! isset( $response->error ) ) {
				$ticket_info = $this->helpers->ticketInfo( $request['ticket_id'] );
				$product_slug = 'envato-' . $response->item->id;
				if( in_array( $product_slug, array_keys( $ticket_info['products'] ) ) ) {
					update_post_meta( $ticket_info['ID'], 'envato_purchase_info', $response );
					update_post_meta( $ticket_info['ID'], 'envato_purchase_code', $request['code'] );
					$data['success'] = 1;

					return $this->helpers->apiResponse( $request, $data );
				} else {
					$data['error'] = __( 'Invalid purchase code! <br>This code belongs to another product.', 'cjaddons' );

					return $this->helpers->apiResponse( $request, $data );
				}
			}
		}

		public function toggleTicketStars( $request ) {
			$user_info = $this->helpers->getApiUserInfo( $request );
			$ticket_stars = get_post_meta( $request['ticket_id'], '_starred_by', true );
			if( ! is_array( $ticket_stars ) ) {
				$ticket_stars = array();
			}
			if( $request['action'] == 'add' ) {
				$ticket_stars[ $user_info['ID'] ] = $user_info['user_email'];
			}
			if( $request['action'] == 'remove' ) {
				unset( $ticket_stars[ $user_info['ID'] ] );
			}
			update_post_meta( $request['ticket_id'], '_starred_by', $ticket_stars );
			$data = $this->helpers->ticketInfo( $request['ticket_id'] );

			return $this->helpers->apiResponse( $request, $data );
		}

	}

	cjaddons_rest_cjsupport_tickets::getInstance();
}