const state = {
    sidebar_main_nav: 0,
    sidebar_organization: 0,
    sidebar_user: 0,
    loading: 0,
    top_nav: 1,
    current_user: {},
    redirect: {},
    toggle_modal: '',
    window_width: '',
    toggle_custom_filters: 0,
    quick_text_modal: 0,
    notification: {
        message: '',
        close: 1,
        css_class: '',
        auto_hide: 0,
    },
};

const getters = {
    sidebar_main_nav: state => state.sidebar_main_nav,
    sidebar_organization: state => state.sidebar_organization,
    sidebar_user: state => state.sidebar_user,
    loading: state => state.loading,
    top_nav: state => state.top_nav,
    current_user: state => state.current_user,
    redirect: state => state.redirect,
    toggle_modal: state => state.toggle_modal,
    window_width: state => state.window_width,
    notification: state => state.notification,
    toggle_custom_filters: state => state.toggle_custom_filters,
    quick_text_modal: state => state.quick_text_modal,
};

const mutations = {
    TOGGLE_SIDEBAR (state, sidebar) {
        state[sidebar] = !state[sidebar]
    },
    HIDE_SIDEBAR (state, sidebar) {
        state[sidebar] = 0
    },
    TOGGLE_LOADING (state, payload) {
        state.loading = payload
    },
    TOGGLE_TOPNAV (state, payload) {
        state.top_nav = payload
    },
    CURRENT_USER (state, payload) {
        payload['is_client'] = parseInt(payload['is_client']);
        payload['is_agent'] = parseInt(payload['is_agent']);
        payload['is_admin'] = parseInt(payload['is_admin']);
        state.current_user = payload
    },
    REDIRECT (state, payload) {
        state.redirect = payload
    },
    TOGGLE_MODAL (state, payload) {
        state.toggle_modal = payload
    },
    TOGGLE_QUICK_TEXT_MODAL (state, payload) {
        state.quick_text_modal = payload
    },
    TOGGLE_WINDOW_WIDTH (state, payload) {
        state.window_width = payload
    },
    TOGGLE_CUSTOM_FILTERS (state, payload) {
        state.toggle_custom_filters = payload
    },
    TOGGLE_NOTIFICATION (state, payload) {
        if (typeof payload === 'object') {
            Object.keys(payload).forEach(function (v) {
                state.notification[v] = payload[v];
            });
        }
    },
};

const actions = {};

export default {
    state, mutations, getters, actions
}