<?php
$current_user = $this->helpers->getApiUserInfo( $request );
$user_roles = $this->helpers->userRole( $current_user['ID'] );
$all_agents = $this->helpers->supportAgentsArray();
$is_agent = (in_array( 'support_agent', $user_roles )) ? 1 : 0;
$is_client = ( ! in_array( 'support_agent', $user_roles ) && ! in_array( 'administrator', $user_roles )) ? 1 : 0;
$is_admin = (in_array( 'administrator', $user_roles )) ? 1 : 0;
$departments = $this->helpers->getTaxonomyArray( 'cjsupport_departments' );
$products = $this->helpers->getTaxonomyArray( 'cjsupport_products' );

$form_fields = array();

$form_fields['author'] = array(
	'id' => 'author',
	'type' => ( ! $is_client) ? 'user' : 'hidden',
	'label' => __( 'Created By', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-full',
	'params' => array(
		'class' => 'selectize'
	),
	'options' => '',
);

$form_fields['search'] = array(
	'id' => 'search',
	'type' => 'text',
	'label' => __( 'Search keywords..', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-12',
	'options' => '',
);

$form_fields['_uid'] = array(
	'id' => '_uid',
	'type' => ( ! $is_client) ? 'text' : 'hidden',
	'label' => __( 'Ticket ID', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-6',
	'options' => '',
);

$form_fields['_assigned_to'] = array(
	'id' => '_assigned_to',
	'type' => ( ! $is_client) ? 'dropdown' : 'hidden',
	'label' => __( 'Assigned To', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-6',
	'options' => $all_agents,
);

$form_fields['post_status'] = array(
	'id' => 'post_status',
	'type' => 'dropdown',
	'label' => __( 'Search in', 'cjaddons' ),
	'default' => 'any',
	'container_class' => 'column is-6',
	'options' => array(
		'any' => __( 'All Tickets', 'cjaddons' ),
		'publish' => __( 'Inbox', 'cjaddons' ),
		'closed' => __( 'Archives', 'cjaddons' ),
	),
);
$form_fields['_priority'] = array(
	'id' => '_priority',
	'type' => 'dropdown',
	'label' => __( 'Priority', 'cjaddons' ),
	'default' => '',
	'params' => array(
		'placeholder' => __( 'Select priority', 'cjaddons' )
	),
	'container_class' => 'column is-6',
	'options' => $this->helpers->savedOption( 'cjsupport-tickets-priority' ),
);
if( $this->helpers->savedOption( 'cjsupport_show_departments' ) == 'yes' && is_array( $departments ) && ! empty( $departments ) ) {
	$form_fields['_department'] = array(
		'id' => '_department',
		'type' => ( ! $is_client) ? 'dropdown' : 'hidden',
		'label' => __( 'Select a department', 'cjaddons' ),
		'info' => '',
		'default' => '',
		'options' => $departments,
	);
}
if( $this->helpers->savedOption( 'cjsupport_show_products' ) == 'yes' && is_array( $products ) && ! empty( $products ) ) {
	$form_fields['_product'] = array(
		'id' => '_product',
		'type' => ( ! $is_client) ? 'dropdown' : 'hidden',
		'label' => __( 'Select a product', 'cjaddons' ),
		'default' => '',
		'options' => $this->helpers->getTaxonomyArray( 'cjsupport_products' ),
	);
}

$form_fields['_start_date'] = array(
	'id' => '_start_date',
	'type' => 'date',
	'label' => __( 'Submitted on or after', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-6',
	'options' => '',
);

$form_fields['_end_date'] = array(
	'id' => '_end_date',
	'type' => 'date',
	'label' => __( 'Submitted on or before', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-6',
	'options' => '',
);

$form_fields['save_filter'] = array(
	'id' => 'save_filter',
	'type' => 'text',
	'label' => __( 'Save this filter?', 'cjaddons' ),
	'default' => '',
	'container_class' => 'column is-12',
	'params' => array(
		'class' => 'is-info mb-20',
		'placeholder' => __( 'Enter a unique name for this filter to save.', 'cjaddons' ),
	),
	'options' => array('yes' => __( 'Yes', 'cjaddons' )),
);
