<?php
if( ! class_exists( 'cjaddons_supportezzy_imap' ) ) {
	class cjaddons_supportezzy_imap {
		private static $instance;

		public $mailbox, $username, $password, $encryption, $imap_enabled;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_supportezzy_helpers::getInstance();
			$this->imap_enabled = extension_loaded( 'imap' );

			if(!$this->imap_enabled){
				return false;
			}

			require_once sprintf( '%s/lib/php-imap/vendor/autoload.php', $this->helpers->module_dir );
			add_action( 'wp_ajax_nopriv_cjsupport_process_emails', array($this, 'processEmails') );
			add_action( 'wp_ajax_cjsupport_process_emails', array($this, 'processEmails') );
			if( isset( $_GET['supportezzy_process_imap'] ) && $_GET['supportezzy_process_imap'] == 1 ) {
				add_action( 'wp_head', array($this, 'processEmails') );
			}
		}

		public function connect( $email_address, $password, $server ) {
			try {
				$mailbox = new PhpImap\Mailbox( '{' . $server . '/imap/ssl}INBOX', $email_address, $password );

				return $mailbox;
			} catch( Exception $e ) {
				return $e->getMessage();
			}
		}

		public function getMessages( $email_address, $password, $server ) {
			try {
				$attachment_dir = wp_upload_dir();
				$mailbox = new PhpImap\Mailbox( '{' . $server . '/imap/ssl}INBOX', $email_address, $password, $attachment_dir['path'] );
				$mails_ids = $mailbox->searchMailbox( 'UNSEEN' );
				if( ! $mails_ids ) {
					return array();
				}
				$mails = array();
				foreach( $mails_ids as $key => $mail_id ) {
					$mail = $mailbox->getMail( $mail_id );
					foreach( $mail as $mail_key => $mail_value ) {
						$mails[ $mail_id ]['email'][ $mail_key ] = $mail_value;
					}
					$mails[ $mail_id ]['attachments'] = $mail->getAttachments();
				}

				return $mails;
			} catch( Exception $e ) {
				return array();
			}
		}

		public function processEmails() {
			global $wpdb;
			$this->helpers->autoCloseTickets();
			$imap_accounts = $this->helpers->savedOption( 'cjsupport_imap_accounts' );
			$module_info = $this->helpers->moduleInfo();
			if( ! is_array( $imap_accounts ) ) {
				echo json_encode( array('message' => 'no-imap') );
				die();
			}
			if( is_array( $imap_accounts ) && ! empty( $imap_accounts ) ) {
				foreach( $imap_accounts as $key => $account ) {
					$imapMailBox = $this->connect( $account['imap_email_address'], $account['imap_password'], $account['imap_server_port'] );
					$mails = $this->getMessages( $account['imap_email_address'], $account['imap_password'], $account['imap_server_port'] );
					foreach( $mails as $m_key => $mail ) {
						$email = $mail['email'];
						$mail_user_info = $wpdb->get_row( "SELECT * FROM $wpdb->users WHERE user_email = '{$email['fromAddress']}'" );
						$email_content = strip_tags( $email['textHtml'], '<p><a><img><br><pre><code>' );
						$email_content = explode( '-- PLEASE REPLY ABOVE THIS MESSAGE --', $email_content );
						$email_content = $email_content[0];
						preg_match( '#\[(.*?)\]#', $email['subject'], $match );

						$mail_attachments = array();
						if( ! empty( $mail['attachments'] ) ) {
							foreach( $mail['attachments'] as $key => $attachment ) {
								$mail_attachments[] = array(
									'file_name' => $attachment->name,
									'file_url' => str_replace( WP_CONTENT_DIR, WP_CONTENT_URL, $attachment->filePath ),
								);
							}
						}

						if( ! empty( $match ) ) {
							$parent_ticket_uid = trim( $match[1] );
							$parent_ticket_info = $this->helpers->getPostByMetaKey( '_uid', $parent_ticket_uid );
							if( ! empty( $parent_ticket_info ) ) {
								$time = current_time( 'mysql' );
								$comment_data = array(
									'comment_post_ID' => $parent_ticket_info['ID'],
									'comment_author' => $mail_user_info->user_login,
									'comment_author_email' => $mail_user_info->user_email,
									'comment_content' => $email_content,
									'comment_type' => 'comment',
									'user_id' => $mail_user_info->ID,
									'comment_date' => $time,
									'comment_approved' => 1,
								);
								$check_existing = $this->helpers->dbGet( 'commentmeta', '*', array(
									'meta_key' => '_cjsupport_mail_id',
									'meta_value' => $m_key,
								) );
								if( ! $check_existing ) {
									$comment_id = wp_insert_comment( $comment_data );
									update_comment_meta( $comment_id, '_cjsupport_mail_id', $m_key );
									if( ! empty( $mail_attachments ) ) {
										update_comment_meta( $comment_id, '_cjsupport_mail_id', $mail_attachments );
									}
									$this->helpers->processNewCommentEmails( $comment_id );
								}
							}
						} else {
							$ticket_data = array(
								'user_email' => $email['fromAddress'],
								'first_name' => explode( ' ', $email['fromName'] )[0],
								'last_name' => explode( ' ', $email['fromName'] )[1],
								'post_title' => $email['subject'],
								'post_content' => $email_content,
								'_uid' => $this->helpers->uniqueString(),
								'_priority' => 48,
								'_department' => (isset( $account['departments'] )) ? $account['departments'] : '',
								'_product' => (isset( $account['products'] )) ? $account['products'] : '',
								'cjsupport_migrated' => 1,
								'_cjsupport_mail_id' => $m_key,
								'additional_data' => array(
									'_cjsupport_mail_id' => $m_key,
								)
							);
							$check_existing = $this->helpers->getPostByMetaKey( '_cjsupport_mail_id', $m_key );
							if( empty( $check_existing ) ) {
								$route_url = rest_url( 'cjaddons/' . $module_info['module_id'] . '/ticket-create' );
								$this->helpers->wpRemotePost( $route_url, $ticket_data );
							}
						}
						$imapMailBox->markMailAsRead( $m_key );
					}
				}
			}
		}

	}

	cjaddons_supportezzy_imap::getInstance();
}