<?php
if( ! class_exists( 'cjsupport_migration_147' ) ) {
	class cjsupport_migration_147 {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_helpers::getInstance();
			add_action( 'admin_notices', array($this, 'migrate'), 99 );
		}

		public function migrate() {
			global $wpdb;

			if( ! current_user_can( 'manage_options' ) ) {
				return false;
			}

			// delete_option( 'cjsupport_migration_version' );
			$tickets_count = $wpdb->get_var( "SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type = 'cjsupport'" );
			if( $tickets_count == 0 ) {
				return false;
			}
			$migration_checkpoint = (int) get_option( 'cjsupport_migration_version' );
			$migrate_url = $this->helpers->queryString( $this->helpers->callbackUrl( 'addon-supportezzy', 'info', 'cjaddons-addon-supportezzy' ) ) . 'cjsupport_migrate=147';
			if( $migration_checkpoint != 147 ) {
				$message[] = '<div class="notice updated cssjockey-ui">';
				$message[] = '<p class="text-bold">' . __( 'SupportEzzy Upgrade', 'addon-supportezzy' ) . '</p>';
				$message[] = '<p class="text-normal">' . __( 'We need to make some changes to tickets data for this version.<br>To avoid any issues, please take a full backup of your database.', 'addon-supportezzy' ) . '</p>';
				$message[] = '<p class="mb-10"><a class="button is-small is-primary" href="' . $migrate_url . '">' . __( 'Run Migration', 'addon-supportezzy' ) . '</a></p>';
				$message[] = '</div>';
				echo implode( '', $message );
			}

			if( isset( $_GET['cjsupport_migrate'] ) && $_GET['cjsupport_migrate'] == 147 ) {
				if( $migration_checkpoint < 147 ) {
					$tickets = get_posts( array(
						'post_type' => 'cjsupport',
						'posts_per_page' => - 1,
						'post_status' => array('publish', 'closed'),
					) );
					if( ! empty( $tickets ) ) {
						foreach( $tickets as $key => $ticket ) {
							$this->migrateAssignedTo( $ticket->ID );
							$this->migrateTicketAttachments( $ticket->ID );
							$this->migrateCommentAttachments( $ticket->ID );
						}
						update_option( 'cjsupport_migration_version', 147 );
					}
					$redirect = $this->helpers->callbackUrl( 'addon-supportezzy', 'info', 'cjaddons-addon-supportezzy' );
					wp_redirect( $redirect );
					die();
				}
			}
		}

		public function migrateAssignedTo( $post_id ) {
			$assigned_to = get_post_meta( $post_id, '_assigned_to', true );
			if( ! is_array( $assigned_to ) ) {
				$user_info = $this->helpers->userInfo( $assigned_to );
				if( ! empty( $user_info ) ) {
					update_post_meta( $post_id, '_assigned_to', array(
						$user_info['ID'] => $user_info['user_login']
					) );
				} else {
					update_post_meta( $post_id, '_assigned_to', '' );
				}
			}
		}

		public function migrateTicketAttachments( $post_id ) {
			$attachment = get_post_meta( $post_id, '_attachments', true );
			if( $attachment !== '' && ! is_array( $attachment ) ) {
				if( strpos( $attachment, site_url() ) !== false ) {
					$file_name = basename( $attachment );
					$file_url = $attachment;
					$attachment_data = array(
						'file_name' => $file_name,
						'file_url' => $file_url,
					);
					update_post_meta( $post_id, '_attachments', $attachment_data );
				}
				if( $attachment == 'N;' ) {
					delete_post_meta( $post_id, '_attachments' );
				}
			}

			if( is_array( $attachment ) && isset( $attachment[0] ) && $attachment[0] == '' ) {
				delete_post_meta( $post_id, '_attachments' );
			}
		}

		public function migrateCommentAttachments( $post_id ) {

			$comments = $this->helpers->dbSelect( 'comments', '*', array(
				'comment_post_ID' => $post_id
			) );

			if( ! empty( $comments ) ) {
				foreach( $comments as $key => $comment ) {
					$comment_id = $comment['comment_ID'];
					$attachment = get_comment_meta( $comment_id, '_attachments', true );
					if( $attachment !== '' && ! is_array( $attachment ) ) {
						if( strpos( $attachment, site_url() ) !== false ) {
							$file_name = basename( $attachment );
							$file_url = $attachment;
							$attachment_data = array(
								'file_name' => $file_name,
								'file_url' => $file_url,
							);
							update_comment_meta( $comment_id, '_attachments', $attachment_data );
						}
						if( $attachment == 'N;' ) {
							delete_comment_meta( $comment_id, '_attachments' );
						}
					}

					if( is_array( $attachment ) && isset( $attachment[0] ) && $attachment[0] == '' ) {
						delete_comment_meta( $comment_id, '_attachments' );
					}
				}
			}
		}

	}

	cjsupport_migration_147::getInstance();
}