<?php
/*
Plugin Name: WP SupportEzzy
Plugin URI: http://persianscript.ir
Description: This add-on enables a powerful customer support system on your WordPress website using the latest technology.
Author: the CSSJockey Team
Version: 1.5.0
Author URI: http://persianscript.ir
*/
ob_start();
add_action( 'after_theme_setup', function () {
	if( class_exists( 'cjaddons_framework' ) ) {
		require_once 'init.php';
	}
}, 11 );
add_action( 'admin_init', function () {
	if( ! class_exists( 'cjaddons_framework' ) ) {
		add_action( 'admin_notices', function () {
			$plugin_data = get_plugin_data( __FILE__, true, true );
			$link = admin_url( 'plugins.php?page=cjaddons-install-addons' );
			echo '<div class="message error">
			<p>' . sprintf( __( '<b style="color:red;">CSSJockey Add-ons Plugin not found!</b>.<br><b>%s</b> requires our CSSJockey Add-ons WordPress plugin which acts as a framework for all our FREE and PREMIUM add-ons.<br><a href="%s">Click here</a> to install and activate CSSJockey Add-ons WordPress plugin.', 'cjaddons' ), $plugin_data['Name'], $link ) . '</p>
			</div>';
		} );
	}
}, 11 );
require_once dirname( __FILE__ ) . '/cssjockey-addon.php';
add_action( 'tgmpa_register', function () {
	global $cjaddons_item_vars;
	$module_info = $cjaddons_item_vars['module_info'];
	$plugins = array();

	$plugins['cssjockey-add-ons'] = array(
		'name' => 'CSSJockey Add-ons',
		'slug' => 'cssjockey-add-ons',
		'required' => true,
		'force_activation' => true,
	);

	$internal_plugin_dir_path = dirname( __FILE__ ) . '/plugins/';
	$plugin_dirs = preg_grep( '/^([^.])/', scandir( $internal_plugin_dir_path ) );
	foreach( $plugin_dirs as $key => $plugin_file ) {
		if( strstr( $plugin_file, '.zip' ) ) {
			$file_name = str_replace( '.zip', '', $plugin_file );
			$plugins[ $file_name ] = array(
				'name' => $module_info[ $file_name ]['module_name'],
				'slug' => $file_name,
				'required' => true,
				'source' => dirname( __FILE__ ) . '/plugins/' . $plugin_file,
				'force_activation' => true,
				'automatic' => true,
			);
		}
	}

	$config = array(
		'id' => 'cjaddons',
		'default_path' => '',
		'menu' => 'cjaddons-install-addons',
		'parent_slug' => 'plugins.php',
		'capability' => 'manage_options',
		'has_notices' => true,
		'dismissable' => false,
		'dismiss_msg' => '',
		'is_automatic' => true,
		'message' => '',

		'strings' => array(
			'page_title' => __( 'Install CSSJockey Add-ons', 'cjaddons' ),
			'menu_title' => __( 'Install Framework', 'cjaddons' ),
			'installing' => __( 'Installing CSSJockey Add-ons: %s', 'cjaddons' ),
			'updating' => __( 'Updating CSSJockey Add-ons: %s', 'cjaddons' ),
			'oops' => __( 'Something went wrong with the plugin API.', 'cjaddons' ),
			'notice_can_install_required' => _n_noop(
				'This plugin is an add-on which requires %1$s framework plugin to run.',
				'This addon requires the following plugins: %1$s.',
				'cjaddons'
			),
			'install_link' => _n_noop(
				'Begin installing',
				'Begin installing',
				'cjaddons'
			),
			'update_link' => _n_noop(
				'Begin updating',
				'Begin updating frameworks',
				'cjaddons'
			),
			'activate_link' => _n_noop(
				'Begin activating',
				'Begin activating frameworks',
				'cjaddons'
			),
			'return' => __( 'Return to CSSJockey Add-ons Installer', 'cjaddons' ),
			'plugin_activated' => __( 'CSSJockey Add-ons activated successfully.', 'cjaddons' ),
			'activated_successfully' => __( 'The following plugin was activated successfully:', 'cjaddons' ),

			'plugin_already_active' => __( 'No action taken. Plugin %1$s was already active.', 'cjaddons' ),

			'plugin_needs_higher_version' => __( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'cjaddons' ),

			'complete' => __( 'All plugins installed and activated successfully. %1$s', 'cjaddons' ),
			'dismiss' => __( 'Dismiss this notice', 'cjaddons' ),
			'notice_cannot_install_activate' => __( 'There are one or more required or recommended plugins to install, update or activate.', 'cjaddons' ),
			'contact_admin' => __( 'Please contact the administrator of this site for help.', 'cjaddons' ),

			'nag_type' => 'notice-error', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		)
	);

	tgmpa( $plugins, $config );
} );
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), function ( $links ) {
	if( class_exists( 'cjaddons_framework' ) ) {
		$addon_id = basename( dirname( __FILE__ ) );
		$link = get_admin_url( null, 'admin.php?page=cjaddons-' . $addon_id . '&callback=' . $addon_id . '~info' );
		$links[] = '<a href="' . esc_url( $link ) . '">' . __( 'Settings', 'cjaddons' ) . '</a>';
	} else {
		$link = get_admin_url( null, 'plugins.php?page=cjaddons-install-addons' );
		$links[] = '<a href="' . esc_url( $link ) . '">' . __( 'Install Framework', 'cjaddons' ) . '</a>';
	}

	return $links;
} );
$upgrade_check = WP_CONTENT_DIR . '/plugins/cssjockey-add-ons/framework/lib/upgrades/plugin-update-checker.php';
if( file_exists( $upgrade_check ) ) {
	//delete_option( '_site_transient_update_plugins' );
	if( ! class_exists( 'Puc_v4_Factory' ) ) {
		require $upgrade_check;
	}
	$slug = basename( dirname( __FILE__ ) );
	$checkUpdates = Puc_v4_Factory::buildUpdateChecker( 'https://cssjockey.com/io/updates/?action=get_metadata&slug=' . $slug, __FILE__, $slug );
	$checkUpdates->addQueryArgFilter( function ( $queryArgs ) {
		global $cjaddons_item_vars;
		require_once 'config.php';
		$slug = basename( dirname( __FILE__ ) );
		$module_info = $cjaddons_item_vars['module_info'][ $slug ];
		$saved_token = get_option( 'cjaddons_license_' . $module_info['item_id'], false );
		$queryArgs['upgrades_token'] = $module_info['item_id'] . '|' . $saved_token . '|' . site_url();

		return $queryArgs;
	} );
}
add_action( 'plugins_loaded', function(){
	$plugin_name = basename( dirname( __FILE__ ) );
	load_plugin_textdomain( $plugin_name, false, $plugin_name. '/languages' );
}, 99 );
if( ! class_exists( 'cjaddons_framework' ) ) {
	return false;
}