<?php
class rrj_charts
{
	// unique instance of the class
	private static $instance = null;
	
	private function __construct() {
		if ( defined( 'WPB_VC_VERSION' ) ) {
			add_action( 'init', array( $this, 'init' ) );
			
			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
			
			// load all chart elements
			require_once RRJ_AC_PATH . 'elements/line/line-chart.php';
			require_once RRJ_AC_PATH . 'elements/bar/bar-chart.php';
			require_once RRJ_AC_PATH . 'elements/bubble/bubble-chart.php';
			require_once RRJ_AC_PATH . 'elements/pie/pie-chart.php';
			require_once RRJ_AC_PATH . 'elements/radar/radar-chart.php';
			require_once RRJ_AC_PATH . 'elements/polar/polar-chart.php';
			
			// front end scripts
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
			
			// back end scripts
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
			
		} else {
			add_action( 'admin_notices', array( $this, 'missing_vc' ) );
		}
	}
	
	/**
	 *  enqueue back end scripts
	 */
	public function admin_scripts() {
		$scr = get_current_screen();
		$vc_screens = array( 'post', 'edit', 'widgets' );
		if ( in_array( $scr->base, $vc_screens ) ) {
			wp_enqueue_script( 'rrj-codemirror', RRJ_AC_URL . 'assets/libs/CodeMirror/codemirror.js', array( 'jquery' ), RRJ_AC_VERSION );
			wp_enqueue_script( 'rrj-jsmode', RRJ_AC_URL . 'assets/libs/CodeMirror/javascript.js', array( 'rrj-codemirror' ), RRJ_AC_VERSION );
			wp_enqueue_script( 'rrj-jseditor', RRJ_AC_URL . 'assets/js/param-jseditor.js', array( 'rrj-codemirror' ), RRJ_AC_VERSION );
			wp_enqueue_style( 'rrj-codemirror', RRJ_AC_URL . 'assets/libs/CodeMirror/codemirror.css', array(), RRJ_AC_VERSION );
		}
	}
	
	/**
	 *  load text domain for translations
	 */
	public function plugins_loaded() {
		load_plugin_textdomain( 'rrj-ac', false, RRJ_AC_PATH . 'languages' );
	}
	
	/**
	 *  tasks to run during init action
	 */
	public function init() {
		// add rrj_uislider param type
		vc_add_shortcode_param( 'rrj_uislider', array( $this, 'uislider' ) );
		// add rrj_jseditor param type
		vc_add_shortcode_param( 'rrj_jseditor', array( $this, 'jseditor' ) );
	}
	
	/**
	 *  jseditor param markup
	 */
	public function jseditor( $settings, $value ) {
		ob_start();
		include plugin_dir_path( __FILE__ ) . '/jseditor.php';
		return ob_get_clean();
	}
	
	/**
	 *  uislider param markup
	 */
	public function uislider( $settings, $value ) {
		ob_start();
		include plugin_dir_path( __FILE__ ) . '/uislider.php';
		return ob_get_clean();
	}
	
	/**
	 *  enqueue scripts in front end
	 */
	public function enqueue_scripts() {
		wp_enqueue_script( 'rrj-charts', RRJ_AC_URL . 'assets/js/chart-controller.js', array( 'jquery' ), RRJ_AC_VERSION );
	}
	
	/**
	 *  add admin notice about missing Visual Composer
	 */
	public function missing_vc() {
		$msg = sprintf(
			__( '%s needs %s to be installed and activated to function', 'rrj-ac' ),
			'<strong>Advanced Charts</strong>',
			'<strong>Visual Composer</strong>'
		);
		echo '<div class="updated"><p>' . $msg . '</p></div>';
	}
	
	/**
	 *  return the aspect ratio param mapping
	 */
	public static function AR(){
		return array(
			'1:1' => '1:1',
			'21:9' => '21:9',
			'16:9' => '16:9',
			'16:9' => '16:9',
			'4:3' => '4:3',
			'3:4' => '3:4',
			'9:16' => '9:16',
			'9:21' => '9:21',
		);
	}
	
	// return or create the unique instance
	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	
}
rrj_charts::instance();