<?php
$colors = rrj_colors::instance();

$_set_color = '#999';
if ( empty( $axes_color ) ) $axes_color = 'rgba(100,100,100,0.8)';

$dataset = array(
	'backgroundColor' => array(),
	'hoverBackgroundColor' => array(),
	'data' => array(),
	'borderWidth' => 1,
);

$labels = array();

foreach( $datasets as $set ) {
	$basecolor = ( !empty( $set['color'] ) )? $set['color'] : $_set_color;
	$dataset['backgroundColor'][] = $colors->dilute( $basecolor, 0.85 );
	$dataset['hoverBackgroundColor'][] = $basecolor;
	$dataset['data'][] = floatval( $set['value'] );
	$labels[] = $set['title'];
}

$options = array(
	'animation' => array( 'duration' => 2000 ),
	'maintainAspectRatio' => true,
	'cutoutPercentage' => absint( $cut ),
	'circumference' => pi() * 2 * ( absint( $circumference ) / 100 ),
	'legend' => array(
		'display' => !empty( $legend )? true : false,
		'position' => $legend_position,
		'labels' => array(
			'usePointStyle' => ( 'point' == $legend_style )? true : false,
			'padding' => 20,
			'boxWidth' => 12,
		),
	),
	'tooltips' => array(
		'enabled' => !empty( $tooltip )? true : false,
		'bodySpacing' => 8,
		'titleSpacing' => 6,
		'cornerRadius' => 8,
		'xPadding' => 10,
	),
);

if ( empty( $legend_onclick ) ) {
	$options['legend']['onClick'] = NULL;
}

$chart_data = array(
	'type' => 'pie',
	'data' => array(
		'labels' => $labels,
		'datasets' => array( $dataset ),
	),
	'options' => $options,
);

$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), self::code, $atts_array );
$AR = explode( ':', $ar );

$chart_id = wp_generate_password( 8, false );

$jsoptions = base64_decode( $jsoptions );
$jsoptions = str_replace( array( "\n","\r" ), '', $jsoptions );
$jsoptions = preg_replace( '#\s+#', ' ', $jsoptions );

?><div class="rrj-chart rrj-pie-chart">
	<div class="<?php echo esc_attr( $css_class ); ?>">
		<?php if ( !empty( $title ) && 'top' == $title_pos ) :?>
		<<?php echo $title_tag; ?> class="chart-title" <?php if ( 'auto' != $title_align ) echo 'style="text-align:' . $title_align . '"'; ?>><?php echo $title; ?></<?php echo $title_tag; ?>>
		<?php endif; ?>
		<div class="chart-data" data-id="<?php echo $chart_id; ?>" style="display:none;"><?php echo json_encode( $chart_data ); ?></div>
		<?php if ( '{}' != trim( $jsoptions ) && !empty( $jsoptions ) ) : ?>
		<script type="text/javascript">
		if ( 'undefined' === typeof rrjChartOptions ) {
			var rrjChartOptions = {};
		}
		<?php if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) : ?>
		rrjChartOptions['<?php echo $chart_id; ?>'] = <?php echo $jsoptions; ?>;
		<?php else: ?>
		try {
			rrjChartOptions['<?php echo $chart_id; ?>'] = <?php echo $jsoptions; ?>;
		} catch ( Ex ) {
			console.log( 'Advanced Charts >> <?php printf( __( 'Error in chart options. Chart ID: "%s"', 'rrj-ac' ), $chart_id ); ?>' );
		}
		<?php endif; ?>
		</script>
		<?php endif; ?>
		<canvas style="width:<?php echo $AR[0]; ?>px;height:<?php echo $AR[1]; ?>px;"></canvas>
		<?php if ( !empty( $title ) && 'bottom' == $title_pos ) :?>
		<<?php echo $title_tag; ?> class="chart-title" <?php if ( 'auto' != $title_align ) echo 'style="text-align:' . $title_align . '"'; ?>><?php echo $title; ?></<?php echo $title_tag; ?>>
		<?php endif; ?>
	</div>
</div>