<?php
class rrj_polar_chart
{
	// the shortcode
	const code = 'rrj_polar_chart';
	
	// unique instance of the class
	private static $instance = null;
	
	private function __construct() {
		add_shortcode( self::code, array( $this, 'shortcode' ) );
		
		add_action( 'wp_enqueue_scripts', 'rrj_enqueue_chartjs' );
		
		vc_lean_map( self::code, array( $this, 'map' ) );
	}
	/**
	 *  map shortcode
	 */
	public function map() {
		return array(
			'name' => __( 'Polar Area Chart', 'rrj-ac' ),
			'description' => __( 'Draw a polar area chart', 'rrj-ac' ),
			'base' => self::code,
			'class' => '',
			'icon' => RRJ_AC_URL . 'elements/polar/polar.png',
			'category' => __( 'Charts', 'rrj-ac' ),
			'admin_enqueue_js' => array(
				includes_url( 'js/jquery/ui/core.min.js' ),
				includes_url( 'js/jquery/ui/widget.min.js' ),
				includes_url( 'js/jquery/ui/mouse.min.js' ),
				RRJ_AC_URL . 'assets/js/param-uislider.js',
			),
			'admin_enqueue_css' => array(
				RRJ_AC_URL . 'assets/css/param-uislider.css',
			),
			'params' => $this->params(),
		);
	}
	
	/**
	 *  the shortcode function
	 */
	public function shortcode( $atts, $content = null ) {
		$atts = vc_map_get_attributes( self::code, $atts );
		$atts_array = $atts;
		extract( $atts );
		ob_start();
		$datasets = (array) vc_param_group_parse_atts( $atts['datasets'] );
		
		include plugin_dir_path( __FILE__ ) . 'template.php';
		
		return ob_get_clean();
	}
	
	/**
	 *  return the params field for vc_map()
	 */
	public function params() {
		$params = array(
			/**
			 * GENERAL 
			 */
			array(
				'type' => 'textfield',
				'heading' => __( 'Widget title', 'rrj-ac' ),
				'param_name' => 'title',
				'value' => __( 'Polar Area Chart', 'rrj-ac' ),
				'admin_label' => true,
			),
			array(
				'type' => 'param_group',
				'heading' => __( 'Data', 'rrj-ac' ),
				'param_name' => 'datasets',
				'value' => urlencode( json_encode( array(
					array(
						'title' => 'One',
						'color' => '#1e73be',
						'value' => '26',
					),
					array(
						'title' => 'Two',
						'color' => '#ec3bef',
						'value' => '24',
					),
					array(
						'title' => 'Three',
						'color' => '#f29b37',
						'value' => '16',
					),
					array(
						'title' => 'Four',
						'color' => '#9fe045',
						'value' => '28',
					),
					array(
						'title' => 'Five',
						'color' => '#eeee22',
						'value' => '14',
					),
				) ) ),
				'params' => array(
					array(
						'type' => 'textfield',
						'param_name' => 'title',
						'heading' => __( 'Title', 'rrj-ac' ),
						'desciption' => __( 'the title used for tooltips and legends', 'rrj-ac' ),
						'admin_label' => true,
					),
					array(
						'type' => 'colorpicker',
						'param_name' => 'color',
						'heading' => __( 'Color', 'rrj-ac' ),
					),
					array(
						'type' => 'textfield',
						'param_name' => 'value',
						'heading' => __( 'Value', 'rrj-ac' ),
						'admin_label' => true,
					),
				),
			),
		);
		/**
		 *  LEGEND AND TOOLTIP
		 */
		$tooltip_options = rrj_ac_tooltip_options( array( 'tooltip_mode' => false ) );
		
		/**
		 *  CHART OPTIONS
		 */
		$chart_options = rrj_ac_chart_options(
			array(
				'ar' => true,
				'axis_zero' => true,
				'axes_color' => true,
				'yaxis_labels' => true,
			)
		);
		
		$params = array_merge( $params, $tooltip_options, $chart_options );
		
		/**
		 *  y axis label background color
		 */
		$params[] = array(
			'type' => 'colorpicker',
			'heading' => __( 'Y axis labels background', 'rrj-ac' ),
			'param_name' => 'yaxis_labels_bg',
			'value' => 'rgba(0,0,0,0)',
			'group' => __( 'Chart options', 'rrj-ac' ),
		);
		
		/**
		 *  DESIGN OPTIONS
		 */
		$params = array_merge( $params, array( array(
			'type' => 'css_editor',
			'heading' => __( 'CSS', 'rrj-ac' ),
			'param_name' => 'css',
			'group' => __( 'Design options', 'rrj-ac' ),
		) ) );
		
		/**
		 *  Custom JS options
		 */
		$params = array_merge( $params, array( rrj_js_ptions() ) );
		
		return $params;
	}
	
	// return or create the unique instance
	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
}
rrj_polar_chart::instance();