"use strict";
angular.module('monsart').controller('MainCtrl', [
    '$rootScope',
    '$scope',
    'FontManager',
    'devicesConfig',
    'EmailConfig',
    'Globals',
    function ($rootScope, $scope, FontManager, devicesConfig, EmailConfig, Globals) {
        var maGlobals = Globals.maGlobals;
        
        $scope.emailTypes = Globals.emailTypes;
        $rootScope.currentType = Globals.emailTypes[0].key;
        
        $rootScope.order = Globals.demoData.order;
        $rootScope.products = Globals.demoData.products;
       // console.log($rootScope.products);
        $scope.loading = true;
        $scope.fonts = [];
        $scope.previewDevices = devicesConfig;
        $scope.previewStyle = {'width': '100%'};
        $scope.changes = false;
        $scope.isDemoConfig = true;
        var tp = FontManager.loadGoogleFonts();


        angular.forEach(maGlobals, function (value, key) {
            $rootScope[key] = value;
            angular.forEach(value, function (obj, name) {
                if (_.isArray(obj.val)) {
                    if (!_.isEqual(obj.val, obj.default)) {
                        $scope.isDemoConfig = false;
                    }
                } else {
                    if (obj.default != obj.val) {
                        $scope.isDemoConfig = false;
                    }
                }
            });
            $scope.$watchCollection(key, function (newValue, oldValue) {
                if (newValue != oldValue) {

                    $scope.changes = true;
                }
            });
        }, true);

        $scope.saveSettings = function () {
            angular.forEach(Globals.maGlobals, function (value, key) {
                maGlobals[key] = $rootScope[key];
            });
            $scope.loading = true;
            EmailConfig.saveConfig(Globals.maGlobals).then(function (data) {
                $scope.loading = false;
            });
        };
        
        $scope.emailTypeChanged= function(){
            $rootScope.$broadcast('email.typeChanged', $scope.currentType);
        }

        $scope.resetChanges = function () {
        };

        $scope.restoreDemo = function () {
            $scope.isDemoConfig = false;
            angular.forEach(Globals.maGlobals, function (value, key) {
                angular.forEach(value, function (obj, prop) {
                    $rootScope[key][prop].val = Globals.maGlobals[key][prop]['default'];
                });
            });
        };

        $scope.changePreviewDevice = function (deviceName) {
            setActivePreviewDevice(deviceName);
        };

        function getActiivePreviewDevice(deviceName) {
            var activeDevice = null;
            for (var key in $scope.previewDevices) {
                if ($scope.previewDevices[key].name === deviceName) {
                    activeDevice = $scope.previewDevices[key];
                    break;
                }
            }
            return activeDevice;
        }

        function setActivePreviewDevice(deviceName) {
            for (var key in $scope.previewDevices) {
                if ($scope.previewDevices[key].name === deviceName) {
                    $scope.previewDevices[key].active = true;
                    $scope.previewStyle.width = $scope.previewDevices[key].width;
                    $scope.$broadcast('screen.changed', $scope.previewDevices[key].width);
                } else {
                    $scope.previewDevices[key].active = false;
                }
            }
        }
        function isChanged() {
        }
    }]);

