"use strict";
angular.module('monsart').directive('maFontSelector', ['FontManager', function (FontManager) {
        return {
            templateUrl: '/directives/maFontSelector.tpl',
            restrict: 'E',
            scope: {
                font: "=ngModel",
            },
            link: function (scope, elem, attrs) {
                scope.fontList = [];
                scope.selectedFont = {};

                FontManager.getGoogleFonts().then(function (data) {
                    //console.log(data);
                    if (!data.error) {
                        scope.fontList = data;
                        for (var i = 0; i < data.length; i++) {
                            if (data[i].family === scope.font) {
                                scope.selectedFont = data[i];
                            }
                        }
                    }

                });
                scope.changeFont = function (item) {
                    WebFont.load({
                        google: {
                            families: [item.family]
                        }
                    });
                    scope.font = item.family;
                }

            }

        }
    }]);