"use strict";
angular.module('monsart').directive('maText', ['Config', '$rootScope' , function (Config, $rootScope) {
            return {
                templateUrl: '/directives/maText.tpl',
                restrict: 'E',
                scope: {
                    text: "=ngModel",
                    config: '=config'
                },
                link: function (scope, elem, attrs) {
                    
                    var currentType = $rootScope.currentType;
                    
                    var panel = attrs.panel;
                    var prop = attrs.prop;
                    if(angular.isDefined(scope.config.multipleEmails) && scope.config.multipleEmails){
                        scope.text = $rootScope[panel][prop][$rootScope.currentType].val;
                        scope.$on('email.typeChanged', function(ev, type){
                            currentType = type;
                            
                            scope.text = $rootScope[panel][prop][currentType].val;
                            
                        });
                        scope.$watch('text', function(newVal){
                            $rootScope[panel][prop][currentType].val = newVal;
                        });
                    }
                    
                    
                    
                },
                controller: function($scope){
                    $scope.wysywigConfig = Config.wysywig;
                }
            }
        }]);