"use strict";

angular.module('monsart').directive('maTextInput', [ '$rootScope',function ($rootScope) {

        return {
            templateUrl: '/directives/maTextInput.tpl',
            restrict: 'E',
            scope: {
                text: "=ngModel",
                config: '=config'
            },
            link: function (scope, elem, attrs) {
                var currentType = $rootScope.currentType;
                var panel = attrs.panel;
                var prop = attrs.prop;
                if (angular.isDefined(scope.config.multipleEmails) && scope.config.multipleEmails) {
                    scope.text = $rootScope[panel][prop][currentType].val;
                    scope.$on('email.typeChanged', function (ev, type) {
                        currentType = type;
                        scope.text = $rootScope[panel][prop][currentType].val;

                    });
                    scope.$watch('text', function (newVal) {
                        $rootScope[panel][prop][currentType].val = newVal;
                    });
                }

            },
        }

    }]);