<?php

class MaAssetManager extends MaSingleton {

    private $_appScripts = array(
        'app',
        'services/Config',
        'services/EmailConfig',
        'services/FontManager',
        'services/MediaHelper',
        'filters/propsFilter',
        'filters/trusted',
        'controllers/mainCtrl',
        'controllers/maMenuCtrl',
        'directives/maColor',
        'directives/maFontSelector',
        'directives/maFullHeight',
        'directives/maImage',
        'directives/maMediaStyle',
        'directives/maMenu',
        'directives/maPreviewScreen',
        'directives/maText',
        'directives/maTextInput'
    );
    private $_scripts = array(
        'showOnCustomize' => array(
            'jquery-ui',
            'jquery-ui-accordion',
            'media-upload',
            'thickbox' => array(
                'module' => true
            ),
            'wp-color-picker' => array(
                'module' => true
            )
        ),
        'allPages' => array(
            'jquery.nicescroll.min.js',
            'main.js',
        )
    );
    private $_mainStyles = array(
        'style.css',
        'media.css'
    );
    private $_actionStyles = array(
        'customize' => array(
            'vendor.min.css',
            'select2.min.css',
            'font-awesome' => array(
                'src' => 'fa/css/font-awesome.min.css',
            ),
            'main.css'
        )
    );

    public function init($hook) {
        $this->enqueueStyles($hook);
        $this->enqueueScripts($hook);
    }

    public function enqueueStyles($hook) {
        $app = MaBootstrap::getInstance()->getApp();
        if ($app->isPage($app->slug)) {
            foreach ($this->_mainStyles as $style) {
                wp_enqueue_style(MA_PLUGIN_PREFIX . $style, MA_ASSETS . 'css/' . $style, array(), MA_PLUGIN_VERION);
            }
            foreach ($this->_actionStyles as $key => $value) {
                if ($app->isAction($key)) {
                    foreach ($value as $styleName => $src) {

                        if (is_array($src)) {
                            wp_enqueue_style(MA_PLUGIN_PREFIX . $styleName, MA_ASSETS . 'css/' . $src['src'], array(), MA_PLUGIN_VERION);
                        } else {
                            wp_enqueue_style(MA_PLUGIN_PREFIX . $src, MA_ASSETS . 'css/' . $src, array(), MA_PLUGIN_VERION);
                        }
                    }
                }
            }
        }
    }

    public function enqueueScripts($hook) {
        $app = MaBootstrap::getInstance()->getApp();

        if ($app->isPage($app->slug)) {
            foreach ($this->_scripts['allPages'] as $script) {

                if (!preg_match('/\.js$/', $script)) {
                    wp_enqueue_script($script);
                    //if()
                } else {
                    wp_enqueue_script(MA_PLUGIN_PREFIX . $script, MA_ASSETS . 'js/' . $script, array('jquery'), MA_PLUGIN_VERION, true);
                }
            }
            if ($app->isAction('customize')) {
                wp_enqueue_script(MA_PLUGIN_PREFIX . 'vendor', MA_ASSETS . 'js/lib.min.js', array('jquery'), null, true);
                foreach ($this->_scripts['showOnCustomize'] as $key => $script) {


                    if (!is_array($script) && !preg_match('/\.js$/', $script)) {
                        wp_enqueue_script($script);
                        //if()
                    } elseif (is_array($script)) {
                        wp_enqueue_script($key);
                        wp_enqueue_style($key);
                    } else {
                        wp_enqueue_script(MA_PLUGIN_PREFIX . $script, MA_ASSETS . 'js/' . $script, array('jquery'), MA_PLUGIN_VERION, true);
                    }
                }
                if (MA_DEVELOPER_MODE) {
                    foreach ($this->_appScripts as $script) {
                        wp_enqueue_script(MA_PLUGIN_PREFIX . $script, MA_ASSETS . 'js/app/' . $script . '.js', array('jquery', MA_PLUGIN_PREFIX . 'vendor'), MA_PLUGIN_VERION, true);
                    }
                } else {
                    wp_enqueue_script(MA_PLUGIN_PREFIX . 'app', MA_ASSETS . 'js/app.min.js', array('jquery', MA_PLUGIN_PREFIX . 'vendor'), MA_PLUGIN_VERION, true);
                }
            }
        }
    }

}
