<?php

class MaEmail {

    private $_config = null;
    private $_previewId;
    private $_wcEmail = null;
    private $_data = null;

    /**
     *
     * @var WC_Order
     */
    private $_order = null;

    /**
     * WCEC PRO template id
     * @var int 
     */
    private $_orderTemplate;
    private $_preview = false;
    private $_emailType = '';
    private $_parts = array(
        'header' => '',
        'style' => '',
        'body' => '',
        'footer' => '',
        'email-header' => '',
        'item-loop' => '',
    );
    private $_folderPath = '';

    public function __construct($order, $preview = false) {

        $this->_preview = $preview;
        $this->_orderTemplate = $order;
        $this->_config = MaConfig::getInstance();
        $this->_data = $this->_config->getEmailConfig($order);

        if ($this->_preview) {
            $this->_previewId = '#preview-screen'; // '#' . $this->_config->slug . ' .preview-container';
        } else {
            $this->_previewId = '';
        }

        $folder_path = MA_ROOT . 'emails' . DS . 'order-' . $this->_orderTemplate;
        if (is_dir($folder_path)) {
            $this->_folderPath = $folder_path;
        }
    }

    public function getEmailPreview() {
        $this->_preview = true;
        return $this->_parts['style'] . $this->_parts['body'];
    }

    public function getPart($part, $force = false) {

        if ((array_key_exists($part, $this->_parts) && empty($this->_parts[$part])) || $force) {

            if (file_exists($this->_folderPath . DS . $part . '.php')) {

                ob_start();

                include $this->_folderPath . DS . $part . '.php';
                $this->_parts[$part] = ob_get_clean();
                if ($part === 'header') {
                    $this->_parts['header'] = str_replace('%styles%', $this->getPart('style'), $this->_parts['header']);
                }

                return $this->_parts[$part];
            }
        }





        return $this->_parts[$part];
    }

    public function initParts() {
        foreach ($this->_parts as $key => $part) {


            if (file_exists($this->_folderPath . DS . $key . '.php')) {
                ob_start();

                include $this->_folderPath . DS . $key . '.php';
                $this->_parts[$key] = ob_get_clean();
            }
        }


        $this->_parts['header'] = str_replace('%styles%', $this->_parts['style'], $this->_parts['header']);
    }

    public function hideOnPreview($string) {
        echo!$this->_previewId ? $string : '';
    }

    public function showOnlyOnPreview($string) {
        if ($this->_preview) {
            echo $string;
        }
    }

    public function setEamilType($type) {

        $this->_emailType = $type;
    }

    public function getEmailType() {
        return $this->_emailType;
    }

    public function isPreview() {
        return $this->_preview;
    }

    public function setOrder($order) {
        $this->_order = $order;
    }

    public function setWcEmail($wcEmail) {
        $this->_wcEmail = $wcEmail;
    }

    public function initReplaceVars($vars, $templateKey) {

        foreach ($vars as $section => $props) {
            foreach ($props as $var => $value) {
                $path = $section . '.';
                $path.= $var;
                if (!$value['multipleEmails']) {
                    $path .='.val';
                    $this->_replaceVars[] = array(
                        'key' => $path,
                        'value' => $value['val']
                    );
                } else {
                    $path .= '.' . $templateKey . '.val';
                    $this->_replaceVars[] = array(
                        'key' => $path,
                        'value' => $value[$templateKey]['val']
                    );
                }
            }
        }
    }

    public function getMultipleEmailPart($fileName) {
        if (file_exists($this->_folderPath . DS . $fileName . '.php')) {

            ob_start();

            include $this->_folderPath . DS . $fileName . '.php';
            $this->_parts[$fileName] = ob_get_clean();
          

            return $this->_parts[$fileName];
        }
    }

    public function imgSrc($src) {
        $val = str_replace("{{", '', str_replace("}}", '', $src));
        echo $this->_preview ? "ng-src='$src' ng-show='$val'" : "src='$src'";
    }

    public function style() {
        
    }

}
