"use strict";
angular.module('monsart').directive('maColor', ['$rootScope', '$timeout', function ($rootScope, $timeout) {
        return {
            templateUrl: '/directives/maColor.tpl',
            restrict: 'E',
            replace: true,
            scope: {
                color: '=ngModel'
            },
            link: function (scope, elem, attrs) {
                

                var $elem = angular.element(elem);

                //scope.color = data.val;

                $timeout(function () {
                    $elem.wpColorPicker({
                        change: function (event, ui) {
                            scope.$apply(function () {
                                scope.color = ui.color.toString();
                            });

                        },
                        // a callback to fire when the input is emptied or an invalid color
                        clear: function () {
                        },
                        // hide the color picker controls on load
                        hide: true,
                        // set  total width
                        width: 250,
                    });
                }, 0, false);

            }
        }
    }]);