"use strict";
angular.module('monsart').directive('maMenu', ['$timeout',function ($timeout) {
        return {
            templateUrl: '/directives/maMenu.tpl',
            restrict: 'E',
            replace: true,
            controller: 'MaMenuCtrl',
            scope: {
                config: "=config"
            },
            link: function (scope, elem, attrs) {
                $timeout(function(){
                  var selectElement = elem[0].querySelector('.ui-select-container');
                  var uiSelect = angular.element(selectElement).controller('uiSelect');
                  uiSelect.close = function(){};
                  $timeout(
                      function(){
                          uiSelect.open = true;
                          uiSelect.activate(false, true);
                      });
                  });
                scope.menuItems = [];
                scope.selectedItems = [];
                if (!angular.isDefined(scope.config.menuType)) {
                    scope.menuItems = scope.config.val;
                     
                }
                
            }
        }
    }]);