"use strict";
/**
 * Add new fonts and fetch font list from google 
 */
angular.module('monsart').service('FontManager', ['$q', '$http', 'Globals', function ($q, $http,Globals) {
        var _googleFontList;
        this.loadGoogleFonts = function () {

            _googleFontList = $q.defer();
            var fonts = localStorage.getItem('ma.googleFonts');
            if (angular.isDefined(fonts) && fonts != null) {
                try{
                    _googleFontList.resolve(angular.fromJson(fonts));
                    return _googleFontList.promise;
                }catch (e){
                    
                }
                
                
            }


            $http.get(Globals.ajaxUrl, {
                params: {
                    'action': 'ma_ajax_main',
                    'func': 'getGoogleFonts',
                    'nonce': Globals.nonce
                }

            }).then(function (response) {
                if (!response.error) {
                    localStorage.setItem('ma.googleFonts', angular.toJson(response.data.items));
                    _googleFontList.resolve(response.data.items);
                } else {
                    _googleFontList.reject({
                        error: response.message
                    });
                }
            });
            return _googleFontList.promise;


        };
        this.getGoogleFonts = function () {
            return _googleFontList.promise;
        };
    }]);