<?php

class MaBootstrap extends MaSingleton{
    private $_app;
    private $_assetManager;
    public function init(){
        $this->_assetManager = MaAssetManager::getInstance();
        $this->_slug = sanitize_title(MA_PLUGIN_NAME);
        $this->_app = MaApplication::getInstance();
        $this->_app->init();
        //$this->_app->getGoogleFonts();
        $this->_app->slug = $this->_slug;
        
        $this->hooks();
       
    }
    
    private function hooks(){
        
        add_action('init', array($this->_app, 'initAjax'));
        add_action('admin_menu', array($this, 'initAdminMenu'));
        add_action( 'adminNotices', array($this,'adminNotices') );
        add_action( 'admin_enqueue_scripts', array($this->_assetManager, 'init') );
    }
    private function isWoocommerceActive(){
        if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
            return true;
        }
        return false;
    }
    public function initAdminMenu(){
        
        add_menu_page(__(MA_PLUGIN_NAME), __(MA_PLUGIN_NAME), 'manage_options', $this->_slug, array($this, 'adminPage'), MA_IMAGES . 'icon.png');

    }
    public function adminPage(){
        $viewHelper = MaViewHelper::getInstance();
        $viewHelper->init();
        
    }
    public function adminNotices(){
        if(!$this->isWoocommerceActive()){
             ?>
            <div class="notice notice-error">
                <p><?php _e( 'Monsart Emails plugin depend on Woocommerce. Please download and active woocommerce plugin.' ); ?></p>
            </div>
            <?php
        }
    }
    /**
     * 
     * @return MaAssetManager
     */
    public function getAssetManager(){
        return $this->_assetManager;
    }
    /**
     * 
     * @return MaApplication
     */
    public function getApp(){
        return $this->_app;
    }
    
}