<?php

class MaConfig extends MaSingleton {

    private $_appConfig = array();
    private $_slug;
    private $_activeTemplate = null;
    private $_templateCount = 10;

    public function init() {

        $this->_appConfig = include MA_INCLUDES . 'data' . DS . 'data.php';
        $this->_slug = sanitize_title(MA_PLUGIN_NAME);
        $this->initActiveTemplate();
    }

    public function __get($property) {
        $propName = "_" . $property;
        if (property_exists($this, $propName)) {
            return $this->$propName;
        } else {
            return null;
        }
    }

    public function getEmailTypes() {
        $types = array();
        foreach ($this->_appConfig['emailTypes'] as $key => $value) {
            $types[] = array(
                'key' => $key,
                'name' => $value['name'],
            );
        }
        return $types;
    }

    public function initActiveTemplate() {
        $this->_activeTemplate = (int) get_option(MA_PLUGIN_PREFIX . '-active-template');
    }

    public function getEmailConfig($order) {

        $config = json_decode(base64_decode(get_option($this->_slug . '-order-' . $order)), true);
        
        if (file_exists(MA_ROOT . 'emails' . DS . 'order-' . $order . DS . 'config.php')) {
            $defaultConfig = include MA_ROOT . 'emails' . DS . 'order-' . $order . DS . 'config.php';
            foreach ($defaultConfig as $section => $value) {

                foreach ($defaultConfig[$section] as $propKey => $prop) {
                    $type = $defaultConfig[$section][$propKey]['type'];
                    $multipleEmails = isset($defaultConfig[$section][$propKey]['multipleEmails']) ? true : false;
                    if (isset($config[$section][$propKey])) {
                        if (isset($config[$section][$propKey]['val'])) {
                            $defaultConfig[$section][$propKey]['val'] = $config[$section][$propKey]['val'];
                        }

                        if ($type === 'image') {
                            $defaultConfig[$section][$propKey]['default'] = plugins_url(MA_PLUGIN_FOLDER_NAME) . '/emails/order-' . $order . '/' . $defaultConfig[$section][$propKey]['default'];
                        }
                        if (($type === 'text' || $type === 'textInput') && $multipleEmails) {
                            $defaultConfig[$section][$propKey] = $config[$section][$propKey];
                        }
                    } else {

                        if ($type === 'image') {

                            $defaultConfig[$section][$propKey]['val'] = plugins_url(MA_PLUGIN_FOLDER_NAME) . '/emails/order-' . $order . '/' . $defaultConfig[$section][$propKey]['default'];
                            $defaultConfig[$section][$propKey]['default'] = plugins_url(MA_PLUGIN_FOLDER_NAME) . '/emails/order-' . $order . '/' . $defaultConfig[$section][$propKey]['default'];
                        } else {

                            if (($type === 'text' || $type === 'textInput') && $multipleEmails) {

                                foreach ($this->_appConfig['emailTypes'] as $eType => $eValue) {

                                    $text = $type === 'text' ? $eValue['text'] : $eValue['title'];
                                    $defaultConfig[$section][$propKey][$eType] = array(
                                        'default' => $text,
                                        'val' => $text
                                    );
                                }
                            } else {
                                $defaultConfig[$section][$propKey]['val'] = $defaultConfig[$section][$propKey]['default'];
                            }
                        }
                    }
                }
            }
        }


        return $defaultConfig;
    }

    public function getDemoData($order) {
        $data = array();
        $demoDataFilePath = MA_ROOT . 'emails' . DS . 'order-' . $order . DS . 'demo.php';

        if (file_exists($demoDataFilePath)) {

            $data = include $demoDataFilePath;

            if (!isset($data['order'])) {
                $data['order'] = array();
            }
            $data['order'] = array_merge($this->_appConfig['genericData']['order'], $data['order']);
            if (isset($data['products']) & !empty($data['products'])) {
                foreach ($data['products'] as &$product) {
                    $product = array_merge($this->_appConfig['genericData']['product'], $product);
                    $product['img_src'] = plugins_url(MA_PLUGIN_FOLDER_NAME) . '/emails/order-' . $order . $product['img_src'];
                }
            }else{
                $data['products'] = array($this->_appConfig['genericData']['product']);
            }
        }
        return $data;
    }

}
