<!-- DIRECTIVES -->
<!-- Font Selector --->
<script type="text/ng-template" id="/directives/maFontSelector.tpl">
    
    <ui-select on-select="changeFont($item)" ng-model="selectedFont" theme="select2" style="min-width: 300px;" title="Choose a person" append-to-body="true">
        <ui-select-match placeholder="Select a person in the list or search his name/age...">{{$select.selected.family}}</ui-select-match>
        <ui-select-choices repeat="font in ::fontList  | propsFilter: {family: $select.search}">
            <div ng-bind-html="::font.family | highlight: $select.search"></div>
            <small>
                category: {{::font.category}}
                
            </small>
        </ui-select-choices>
    </ui-select>
</script>
<!-- /Font Selector --->
<!-- Ma Text -->
<script type="text/ng-template" id="/directives/maText.tpl">
    
    <wysiwyg-edit content="text"   config="wysywigConfig"></wysiwyg-edit>
    
</script>

<script type="text/ng-template" id="/directives/maTextInput.tpl">
    
   <input type="text" ng-model="text" value=""  />
    
</script>
<!-- /Ma Text -->
<!-- Ma Image -->
<script type="text/ng-template" id="/directives/maImage.tpl">
    <div class="input-container" ng-show="!val">
        <input ng-model="linkImage" ng-paste="::activateFromUrl()" ng-change="::activateFromUrl()"  type="text" class="text upload_image" size="36" placeholder="http://" name="upload_image" value="" />
        <input ng-click="::openThickBox()"  ng-hide="fromUrl" class=button add-image upload_image_button" type="button" value="Upload Image" />
        <input ng-click="::useImage()" ng-show="fromUrl"  class=button add-image upload_image_button" type="button" value="Use Link" />
    </div>
    <div ng-show="val" class="preview-img">
        
        <img ng-src="{{val}}">
        <button class="btn-icon btn-circle edit" ng-click="::openThickBox()" href="#"><i class="fa fa-edit"></i></button>
        <button class="btn-icon btn-circle remove" ng-click="::removeImage()" href="#"><i class="fa fa-remove"></i></button>
        
    </div>
</script> 
<!-- /Ma Image -->
<!-- Ma Color -->
<script type="text/ng-template" id="/directives/maColor.tpl">
    <input data-mode="hex" type="text" value="{{color}}" class="wp-color-picker-field ma-color-picker" data-default-color="{{color}}" />
</script>
<!-- /Ma Color -->
<!-- Ma Menu -->
<script type="text/ng-template" id="/directives/maMenu.tpl">
    <div class="ma-menu-manager">
        <!--<div class="menu-type">
            <ul class="nav-choices nav-justified">
                <li>Nav Menu</li>
                <li>Custom</li>
            </ul>
        </div>-->
        <div class="menu-display">
            <div class="nav-menu-display ma-custom-menu">
            
                <ui-select close-on-select="false" on-remove="removeItem($item)"  multiple ng-model="selectedItems" theme="select2" style="min-width: 300px;" title="Choose a menu item" >
                    <ui-select-match placeholder="Menu Items..">{{$item.text}}</ui-select-match>
                    <ui-select-choices ng-model="menuItem" repeat="menuItem in menuItems | propsFilter: {text: $select.search}" >
                      <div class="ma-single-menu-item"  ng-bind-html="menuItem.text | highlight: $select.search"></div>
                      <i class="fa fa-plus" aria-hidden="true"></i>
                    </ui-select-choices>
                </ui-select>
            </div>
            <div class="custom-menu-display">

                <div class="add-menu-item">
                    <div class="row"><label for="ma-menu-item-text">Text:</label><input id="ma-menu-item-text" ng-model="itemText" type="text" ></div>
                    <div class="row"><label for="ma-menu-item-url">Url:</label><input id="ma-menu-item-url" ng-model="itemUrl" type="text" placeholder="http://"></div>
                    <button class="button button-primary button-large" ng-click="addMenuItem()"><?php _e('Add Item'); ?></button>
                </div>
            </div>
        </div>
    </div>
</script>
<!-- /Ma Menu -->





