<?php
/**
 * Plugin Name: فروش لایسنس ووکامرس
 * Plugin URI: http://persianscript.ir/woocommerce-license-manager/
 * Description:  افزونه مدیریت و فروش لایسنس ، کارت شارژ در ووکامرس - فارسی شده توسط پرشین اسکریپت (ووکامرس فارسی)
 * Version: 5.2
 * Author: ووکامرس فارسی
 * Author URI: http://woocommerce.ir
 */
 
ini_set("display_errors", 0);
class SB_WC_Licences {

    public $orderID;

    public function __construct() 
    {
        register_activation_hook(__FILE__, array($this, 'onActivate'));
        $this->addActions();
    }

    public function action_woocommerce_order_status_completed($order_id) {
        global $wpdb;
        if(is_object($order_id)){
            $order_id = $order_id->id;
        }
        $email_lpl = get_option('sb_wc_gift_email_lpl');
        $email_lps = get_option('sb_wc_gift_email_lps');
        $this->orderID = $order_id;
        $order = new WC_Order($order_id);
        $items = $order->get_items();
        foreach ($items as $key => $value) 
        {
            $item_name = $wpdb->get_var("SELECT order_item_name FROM {$wpdb->prefix}woocommerce_order_items WHERE order_id = $order_id AND order_item_id = $key");
            if (empty($value['License Code(s)'])) 
            { 
                $this->action_woocommerce_add_order_item_meta($key, array('quantity' => $value['item_meta']['_qty'][0], 'product_id' => $value['item_meta']['_product_id'][0]));
            }
            if(wc_get_order_item_meta($key, 'License Code(s)', 1))
            {
                $license_code .= wc_get_order_item_meta($key, 'License Code(s)', 1) ;
                $to = $order->billing_email;
                $blogname = get_bloginfo();
                $subject = $email_lps;
                $message = $email_lpl;
                $message = str_replace('[receiver_name]', $order->billing_first_name .' '. $order->billing_last_name, $message);
                $message = str_replace('[order_id]', $order_id, $message);
                $message = str_replace('[blog_name]', $blogname, $message);
                $message = str_replace('[license_code]', $license_code, $message);
                $message = str_replace('[item_id]', $key, $message);
                $message = str_replace('[item_name]', $item_name, $message);
                $admin_mail = get_option( 'admin_email' );
                $headers = array("From: $blogname <$admin_mail>");
                wp_mail($to, $subject, $message, $headers, $attachments);
            }
        }
    }

    public function lmg_set_html_content_type() 
    {
        return 'text/html';
    }

    public function onActivate() 
    {
        global $wpdb;
        $query = array();
        $query[] = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}wc_product_licences(licence_id integer auto_increment primary key,
                        product_id integer not null,
                        licence_code varchar(500),
                        licence_status varchar(500),
                        activation_date datetime,
                        creation_date datetime
                    )";
        foreach ($query as $q) {
            $wpdb->query($q);
        }
        $lps = 'جزئیات لایسنس خریداری شده شما';
        $lpl = "<html><body>\n\n"."<h1>سلام [receiver_name],</h1><br />\n\n".
                "سفارش شما به شماره [order_id] محصول [item_name] , کد های شمار به شرح زیر می باشد :"
                ."\n\n" . "[license_code]<br />\n\n".
                "با تشکر<br />\n\n\[blog_name]</body></html>";
                
        update_option('sb_wc_gift_email_lpl', stripslashes($lpl));
        update_option('sb_wc_gift_email_lps', stripslashes($lps));
    }

    public function addActions() {
        if (is_admin()) {
            add_action( 'add_meta_boxes', array($this,'lmg_metabox_function') );
            add_action('save_post',array($this, 'save_lmg_metaboox')); 
            add_action('init', array($this, 'handleAdminRequests'));
            add_action('admin_init', array($this, 'action_add_metaboxes'));
            add_action('save_post', array($this, 'action_save_post'));
            add_action('woocommerce_settings_license_settings', array($this, 'license_settings'));
            add_action('woocommerce_settings_save_license_settings', array($this, 'action_save_settings'));
            add_filter('woocommerce_settings_tabs_array', array($this, 'filter_woocommerce_settings_tabs_array'), 50);
        } else {    
        }
        add_filter( 'wp_mail_content_type', array($this,'lmg_set_html_content_type') );
        add_action('init', array($this,'wlmg_localize') );
        add_action('woocommerce_order_status_completed', array($this, 'action_woocommerce_order_status_completed'));
        add_action('woocommerce_order_status_processing', array($this, 'action_woocommerce_order_status_completed'));
    }
    
    public function wlmg_localize()  {
    // Localization
    load_plugin_textdomain('wlmg', false, dirname(plugin_basename(__FILE__)). "/languages" );
    }

    public function filter_woocommerce_settings_tabs_array($tabs)
    {
        $tabs['license_settings'] = __('مدیریت لایسنس','wlmg');
        return $tabs;
    }
    
    public function license_settings()
    {   
        $email_lpl = get_option('sb_wc_gift_email_lpl');
        $email_lps = get_option('sb_wc_gift_email_lps');
        ?>
        <div class="wrap">
            <h2>تنظیمات مدیریت لایسنس</h2>
            <p>این افزونه به صورت رایگان از سوی پرشین اسکریپت (ووکامرس فارسی) به صورت رایگان منتشر شده است.</p>
            <p>
            <label>
                <strong>عنوان ایمیل</label></strong><br />
                <input type="text" name="lps" style="width:300px;" value="<?php print $email_lps; ?>" />
                </p>
                <p>
                   <div><strong>برچسب های قابل استفاده :</strong></div>
                   <div>[blog_name] = عنوان وب سایت</div>
                   <div>[order_id] = شماره سفارش</div>
                   <div>[license_code] = کد لایسنس</div>
                   <div>[item_id] = شناسه محصول</div>
                   <div>[item_name] = عنوان محصول</div>
                   <div>[receiver_name] = نام حریدار</div>
               </p>
                <p>
                    <strong><label>قالب ایمیل</label></strong><br/>
                    <textarea rows="" cols="" style="width:50%;height:200px;" name="lpl"><?php print $email_lpl; ?></textarea>
                </p>
        </div>
        <?php 
    }

    public function action_save_settings()
    {
        if( isset($_POST['lpl']) )
        {
            update_option('sb_wc_gift_email_lpl', stripslashes($_POST['lpl']));
        }
        if( isset($_POST['lps']) )
        {
            update_option('sb_wc_gift_email_lps', stripslashes($_POST['lps']));
        }
    }

    public function lmg_metabox_function(){
    add_meta_box( 'lmg', 'تنظیمات لایسنس ووکامرس', array($this,'lmg_metabox'), 'product', 'side' ); 
    }
    
    public function lmg_metabox($post)
    {
        wp_nonce_field( plugin_basename( __FILE__ ), 'wm_noncename' );
        ?>
    <p>
        <label><strong><?php _e('License Code Per Quantity' , 'wlmg'); ?></strong><?php _e('(Set the number of license code that will be given to the customer for each unit of this product ordered.)','wlmg'); ?></label><br/>
        <input type="text" name="license_unit" value="<?php if (get_post_meta($post->ID, 'license_unit', true) == ""){ echo '1' ;}else{ print get_post_meta($post->ID, 'license_unit', true); }?>" size="100" style="padding:3px;width:150px;" />
        </p>
    
    <?php
    }
    public function save_lmg_metaboox($post_id)
    {
        if( !isset($_POST['post_type']) || $_POST['post_type'] != 'product' || !current_user_can('edit_post') )
            return false;
        if ( ! isset( $_POST['wm_noncename'] ) || ! wp_verify_nonce( $_POST['wm_noncename'], plugin_basename( __FILE__ ) ) )
            return;
        if( isset( $_POST[ 'license_unit' ] ) ) 
        {
            update_post_meta( $post_id, 'license_unit', sanitize_text_field( $_POST[ 'license_unit' ] ) );
        }
    }

    public function action_add_metaboxes() {
        add_meta_box('sb-wc-licences', __('License Code(s)','wlmg'), array($this, 'metabox_licences'), 'product', 'advanced');
    }

    public function metabox_licences($post) {
        global $wpdb;

        $product_id = $post->ID;
        $query = "SELECT * FROM {$wpdb->prefix}wc_product_licences WHERE product_id = $product_id AND licence_status = 'available'";
        $licences = $wpdb->get_results($query);
        require_once dirname(__FILE__) . '/metaboxes/licences.php';
    }

    public function handleAdminRequests() {
        global $wpdb;

        $task = isset($_REQUEST['task']) ? $_REQUEST['task'] : null;
        if (!$task)
            return false;
        if ($task == 'delete_licence') {
            global $wpdb;
            $post_id = (int) $_REQUEST['post'];
            $wpdb->delete($wpdb->prefix . 'wc_product_licences', array('licence_id' => (int) $_REQUEST['id']));
            $link = admin_url('post.php?post=' . $post_id . '&action=edit&message=4');
            wp_redirect($link);
            die();
        }
    }

    public function action_save_post($post_id) {
        global $wpdb;

        if ($_POST['post_type'] != 'product')
            return false;

        $product_id = $post_id;
        if (isset($_FILES['licences_file']) && $_FILES['licences_file']['size'] > 0) {
            $tmp_file = wp_tempnam($_FILES['licences_file']['name']);
            move_uploaded_file($_FILES['licences_file']['tmp_name'], $tmp_file);
            $fh = fopen($tmp_file, 'r');
            $contents = fread($fh, $_FILES['licences_file']['size']);
            fclose($fh);
            $licences = explode("\n", $contents);
            foreach ($licences as $l) {
                if (empty($l))
                    continue;
                $data = array('product_id' => $product_id, 'licence_code' => trim($l), 'licence_status' => 'available',
                    'creation_date' => date('Y-m-d H:i:s'));
                $wpdb->insert("{$wpdb->prefix}wc_product_licences", $data);
            }
        }
        if (isset($_POST['single_licence']) && !empty($_POST['single_licence'])) {
            $l = trim($_POST['single_licence']);
            $data = array('product_id' => $product_id,
                'licence_code' => $l,
                'licence_status' => 'available',
                'creation_date' => date('Y-m-d H:i:s'));
            $wpdb->insert("{$wpdb->prefix}wc_product_licences", $data);
        }
    }

    public function action_woocommerce_add_order_item_meta($item_id, $values) {
        global $wpdb,$post;
        if(get_post_meta($values['product_id'], 'license_unit', 1) == 0)
        {
            return false;
        }
        $product_no = (int) $values['product_id'];
        $qty_no = (int) $values['quantity'] * get_post_meta($values['product_id'], 'license_unit', 1);

        $query = $wpdb->get_results("SELECT licence_id, product_id, licence_code, licence_status FROM {$wpdb->prefix}wc_product_licences 
                    WHERE product_id = $product_no 
                    AND licence_code <> '' 
                    AND licence_status = 'available' 
                    LIMIT 0,$qty_no");

        $elements = array();
        $licenseString = "";
        $i = 1;
        foreach ($query as $query) {
            $elements[] = $query->licence_code;
            $license_id[] = $query->licence_id;

            $licenseString .= "<strong>". __('Code','wlmg')."#$i: </strong>" . $query->licence_code . "<br>";
            $i++;
        }

        $licence = $this->_getProductLicenseCode((int) $values['product_id'], (int) $values['quantity']);
        if (!$licence) {

            return false;
        }
        wc_add_order_item_meta($item_id, __('License Code(s)','wlmg'), $licenseString,false);
        $this->_setLicenceCodeStatus(implode($license_id, ','), 'assigned');
    }

    protected function _getProductLicenseCode($product_id, $quantity) 
    {
        if (empty($product_id))
            return false;

        global $wpdb;

        $queryCount = "SELECT count(licence_id) FROM {$wpdb->prefix}wc_product_licences 
                WHERE product_id = $product_id
                AND licence_code <> '' 
                AND licence_status = 'available'";
        $available_codes = $wpdb->get_var($queryCount);

        $order = new WC_Order($this->orderID);

        if ($available_codes < $quantity) {
            return false;
        }

        $query = "SELECT licence_id, product_id, licence_code, licence_status FROM {$wpdb->prefix}wc_product_licences 
                    WHERE product_id = $product_id
                    AND licence_code <> '' 
                    AND licence_status = 'available'
                    ORDER BY creation_date ASC
                    LIMIT 1";
        return $wpdb->get_row($query);
    }

    protected function _setLicenceCodeStatus($licence_id, $status) 
    {
        global $wpdb;
        $wpdb->query("UPDATE {$wpdb->prefix}wc_product_licences SET licence_status = '$status' WHERE licence_id in ($licence_id)");
    }
}
$sb_wc_licences = new SB_WC_Licences();
?>