<?php 
class WCMCA_CheckoutPage
{
	public function __construct()
	{
		add_filter('plugins_loaded', array(&$this,'init'));
		add_action('wp_footer', array( &$this,'add_custom_css'),99);
		add_action('woocommerce_before_checkout_form', array(&$this, 'add_popup_html'));
		add_action('woocommerce_before_checkout_billing_form', array(&$this, 'add_billing_address_select_menu'));
		add_action('woocommerce_before_checkout_shipping_form', array(&$this, 'add_shipping_address_select_menu'));
		
		add_action('woocommerce_checkout_update_order_meta', array( &$this, 'save_checkout_extra_field' ));
		
		//Shipping per product woocommerce_checkout_cart_item_quantity
		add_filter('woocommerce_checkout_cart_item_quantity', array(&$this,'add_product_shipping_dropdown_menu'), 10, 3); //woocommerce_cart_item_name
		add_filter('wp_ajax_wcmca_load_product_address', array(&$this,'ajax_load_product_address'));
		
		//add_action('woocommerce_checkout_process', array( &$this, 'update_cart_item_meta' )); 
		add_filter('woocommerce_get_cart_item_from_session', array( &$this, 'update_cart_item_meta' ),10,3); 
	}
	public function init()
	{
		if(version_compare( WC_VERSION, '3.0.7', '<' ))
			add_action('woocommerce_add_order_item_meta', array( &$this, 'update_order_item_meta' ),10,3); //Update order items meta
		else
			add_action('woocommerce_new_order_item', array( &$this, 'update_order_item_meta' ),10,3);
	}
	public function add_custom_css()
	{	
		global $wcmca_html_helper;
		if(@is_checkout())
			$wcmca_html_helper->render_custom_css('my_account_page');
	}
	function add_popup_html($checkout)
	{
		global $wcmca_html_helper,$wcmca_address_model;
		
		if(!get_current_user_id())
			return;
		
		$wcmca_html_helper->render_address_form_popup();
		$wcmca_html_helper->render_custom_css('checkout_page');
	}
	function add_billing_address_select_menu($checkout)
	{
		global $wcmca_html_helper,$wcmca_address_model,$wcmca_option_model;
		
		//wcmca_var_dump($checkout);
		//wcmca_var_dump(get_user_meta( get_current_user_id()));
		//wcmca_var_dump($wcmca_address_model->get_address_by_id('def_billing'));
		
		if(!get_current_user_id())
			return;
		$wcmca_html_helper->render_address_select_menu();
	}
	function add_shipping_address_select_menu($checkout)
	{
		global $wcmca_html_helper,$wcmca_option_model;
		
		if(!get_current_user_id())
			return;
		$wcmca_html_helper->render_address_select_menu('shipping');
	}
	public function save_checkout_extra_field($order_id)
	{
		global $wcmca_option_model, $wcev_order_model;
		if(!$wcmca_option_model->is_vat_identification_number_enabled())
			return;
		
		if(!isset($wcev_order_model) && isset($_POST['billing_vat_number']))
			$wcmca_order_model->save_vat_field($order_id, $_POST['billing_vat_number']);
	}
	
	public function add_product_shipping_dropdown_menu($text, $cart_item, $cart_item_key)
	{
		global $wcmca_html_helper, $wcmca_option_model;
		/* wcmca_var_dump($cart_item_key);
		wcmca_var_dump($cart_item); */
	
		if(!get_current_user_id() || !$wcmca_option_model->shipping_per_product())
			return $text;
		
		echo $text."<br/>";
		$wcmca_html_helper->render_address_select_menu_for_product($cart_item_key);
	}
	public function ajax_load_product_address()
	{
		global $wcmca_html_helper;
		$cart_item_id = isset($_POST['cart_item_key']) ? $_POST['cart_item_key'] : null;
		$address_id = isset($_POST['address_id']) ? $_POST['address_id'] : null;
		$type = isset($_POST['type']) ? $_POST['type'] : 'shipping';
		
		if(get_current_user_id() && isset($address_id))
			$wcmca_html_helper->render_product_address_preview($address_id, get_current_user_id(),  $type);
		wp_die();
	}
	public function update_cart_item_meta($session_data, $values, $key)
	//public function update_cart_item_meta($posted_data)
	{
		if(!isset($_POST) || empty($_POST))
			return $session_data;
		
		$cart = WC()->cart->cart_contents ;
		$posted_data = $_POST;
		if(isset($posted_data['wcmca_product_address']))
		{
			foreach($posted_data['wcmca_product_address'] as $product_address)
			{
				$ids = explode("-||-",$product_address); //[0] = cart_item_key; [1] = address_id; [2] = address_type
				/*$if(isset($cart[$ids[0]]))
					$cart[$ids[0]]['wcmca_shipping_address'] = $ids[1]; */
				 if($key == $ids[0])
					 $session_data['wcmca_shipping_address'] = $ids[1]; 
			}
		}
		if(isset($posted_data['wcmca_product_fields']))
		{
			foreach($posted_data['wcmca_product_fields'] as $item_key => $field_array)
			{
				if($key == $item_key)
				 {
					 if(!isset($session_data['wcmca_shipping_fields']))
						 $session_data['wcmca_shipping_fields'] = array();
					  
					 foreach($field_array as $field_name => $field_value )
						$session_data['wcmca_shipping_fields'][$field_name] = $field_value;
				 }
			}
			
			
		}
		//wcmca_var_dump($session_data['wcmca_shipping_fields']);
		//wc_add_notice( __('Stop test','woocommerce-multiple-customer-addresses') ,'error');  
		return $session_data; 
	}
	function update_order_item_meta($item_id, $values, $cart_item_key)
									// $item_id, $item, $order_id -> woocommerce_new_order_item
	{
		global $wcmca_customer_model, $wcmca_address_model;
		
		if ( is_a( $values, 'WC_Order_Item_Product' ) ) 
		{
			$values = $values->legacy_values;
			//$cart_item_key = $values->legacy_cart_item_key;
			
		} 
				
		if(isset($values['wcmca_shipping_address']))
		{
			//If the address is inputted from the product address form (gust users?)
			/*if( $values['wcmca_shipping_address'] == 'guest_data')
			{
				//read $values['wcmca_shipping_fields'] 
			}
			else*/
			{
				$address = $wcmca_address_model->get_address_by_id($values['wcmca_shipping_address']);
				if(!empty($address))
					foreach($address as $key => $field)
					{
						//$type = $field['type'];
						wc_add_order_item_meta($item_id, '_wcmca_'.$key, $field, true);
					}
			}
		}
		
		//Only for specia field "Notes" (but for now reads and stores all the fields)
		if(isset($values['wcmca_shipping_fields']))
		{
			foreach($values['wcmca_shipping_fields'] as  $field_name => $field_value)
			{
				//if($field_name == 'notes')
					wc_add_order_item_meta($item_id, '_wcmca_'.$field_name, $field_value, true);
			}
		}
		//wcmca_var_dump($values);
		//wp_die();  
	}

}
?>