<?php
if (!defined('ABSPATH'))
    exit;

class WOS_admin
{

    /**
     * The single instance
     * @var    object
     * @access  private
     * @since    1.0.0
     */
    private static $_instance = null;

    /**
     * The main plugin object.
     * @var    object
     * @access  public
     * @since    1.0.0
     */
    public $parent = null;

    /**
     * Prefix for plugin settings.
     * @var     string
     * @access  publicexport
     * Delete
     * @since   1.0.0
     */
    public $base = '';

    /**
     * Available settings for plugin.
     * @var     array
     * @access  public
     * @since   1.0.0
     */
    public $settings = array();


    public function __construct($parent)
    {
        $this->parent = $parent;
        $this->base = 'wos_';
        $this->dir = dirname($this->parent->file);
        add_action('admin_menu', array($this, 'add_menu_item'));
        add_action('admin_print_scripts', array($this, 'admin_scripts'));
        add_action('admin_print_styles', array($this, 'admin_styles'));
        add_action('wp_ajax_nopriv_wos_saveSettings', array($this, 'saveSettings'));
        add_action('wp_ajax_wos_saveSettings', array($this, 'saveSettings'));
        add_action('wp_ajax_nopriv_wos_loadSettings', array($this, 'loadSettings'));
        add_action('wp_ajax_wos_loadSettings', array($this, 'loadSettings'));    
        add_action('wp_ajax_nopriv_wos_saveShortcut', array($this, 'saveShortcut'));
        add_action('wp_ajax_wos_saveShortcut', array($this, 'saveShortcut'));    
        add_action('wp_ajax_nopriv_wos_deleteShortcut', array($this, 'deleteShortcut'));
        add_action('wp_ajax_wos_deleteShortcut', array($this, 'deleteShortcut'));          
        add_action('admin_head', array($this, 'options_custom_styles'));      
        add_action('init', array($this, 'detectPluginActivation'));
        add_action('admin_init', array($this, 'checkAutomaticUpdates'));  
        add_action('wp_logout',  array($this,'endSession'));
        add_action('wp_login',  array($this,'endSession'));

    }


    /**
     * Add menu to admin
     * @return void
     */
    public function add_menu_item()
    {
        add_menu_page('WP OS Desktop', __("WP OS Desktop", 'wos'), 'manage_options', 'wos_menu', array($this, 'view_settings_wos'), 'dashicons-welcome-view-site');
        $menuSlag = 'wos_menu';
    }

    public function getSettings()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . "wos_settings";
        $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE id=1 LIMIT 1");
        $settings = $settings[0];
        return $settings;
    }
    
    public function loadSettings(){        
        if(current_user_can('manage_options')){   
            $settings = $this->getSettings();
           // $settings->purchaseCode="";
            echo(json_encode($settings));
        }
        die();
    }
    public function detectPluginActivation(){
         if(!session_id()) {
            session_start();
        }
        if(isset($_GET['action']) && ($_GET['action'] == 'activate' ||$_GET['action'] == 'deactivate')){
            $_SESSION['wos_loadPageBackend'] = 1;            
        }
        
    }
     /*
     * Check for updates
     */
     function checkAutomaticUpdates(){
       $settings = $this->getSettings();
       if($settings && $settings->purchaseCode != ""){
         require_once('plugin_update_check.php');      
        $updateCheckerWos = new PluginUpdateChecker_2_0 (
           'https://kernl.us/api/v1/updates/5718cb711e14737d770078b8/',
           $this->parent->file,
           'wos',
           1
        );
        $updateCheckerWos->purchaseCode = $settings->purchaseCode;
       }
     }
    public function endSession(){
        session_destroy ();        
    }
    public function options_custom_styles()
    {        
        $settings= $this->getSettings();
            $output = '';
            
            $output .= '#osdb_bootstraped .wos-window {';
            $output .= ' border-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";
            
            $output .= '#osdb_bootstraped .wos-shortcut .wos_editShortcutIcon {';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";            
            
            $output .= '#osdb_bootstraped .wos-window > .wos-window-header,#osdb_bootstraped #wos-closedWindows-container > a {';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= ' color: ' . $settings->colorWinHeader . ';';            
            $output .= '}';
            $output .= "\n";    
            
            $output .= '#osdb_bootstraped .wos-window > .wos-window-header .wos-window-title, #osdb_bootstraped .wos-window > .wos-window-header .wos-window-icon:before {';
            $output .= ' color: ' . $settings->colorWinHeader . ';';            
            $output .= '}';
            $output .= "\n";    
            
            
            $output .= '#osdb_bootstraped .wos-window .wos-window-loader {';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";
            
            $output .= '#osdb_bootstraped .wos-window .wos-window-loader .wos-spinner{';
            $output .= ' background-color: ' . $settings->colorWinHeader . ';';
            $output .= '}';
            $output .= "\n";
            
            
            $output .= '#osdb_bootstraped .wos-window > .wos-window-header > .wos-window-header-icons > a.wos-window-header-icon {';
            $output .= ' background-color: ' . $settings->colorWinIconsBg . ';';
            $output .= ' color: ' . $settings->colorWinIcons . ';';
            $output .= '}';
            $output .= "\n";
            
            
            $output .= '#osdb_bootstraped .wos-window > .wos-window-header > .wos-window-header-icons > a.wos-window-header-icon.wos_iconActivated {';
            $output .= ' background-color: ' . $settings->colorWinIconsSelected . ';';
            $output .= ' color: ' . $settings->colorWinHeader . ';';
            $output .= '}';
            $output .= "\n";
            
            
            $output .= '#osdb_bootstraped .wos-window > .wos-window-header > .wos-window-header-icons > a.wos-window-header-icon:hover {';
            $output .= ' color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";
            
            $fxGray= '0';
            $fxBlur= '0';
            $fxBrightness= '100';
            if($settings->fxWinGray){
                $fxGray= '100';                
            }
            if($settings->fxWinBlur){
                $fxBlur= '0.7';                
            }
            if($settings->fxWinDark){
                $fxBrightness= '90%';                
            }
            
            $defaultWinFilters = 'blur('.$fxBlur.'px) grayscale('.$fxGray.'%) brightness('.$fxBrightness.'%);';
            $output .= '#osdb_bootstraped .wos-window {';
            $output .= ' -webkit-filter: ' . $defaultWinFilters . ';';
            $output .= ' filter: ' . $defaultWinFilters . ';';
            $output .= '}';
            $output .= "\n";            
            
            $output .= '#osdb_bootstraped .wos-shortcut-title{';
            $output .= ' color: ' . $settings->colorShortcuts . ';';
            $output .= '}';
            $output .= "\n";
            
            $output .= '#osdb_bootstraped .wos-shortcut .wp-menu-image:before{';
            $output .= ' color: ' . $settings->colorShortcuts . ';';
            $output .= '}';
            $output .= "\n";
            
            
            if($settings->backgroundImage != ""){
                $output .= '#osdb_bootstraped.wos-backendContainer {';
                $output .= ' background-image: url(' . $settings->backgroundImage . ');';
                $output .= '}';
                $output .= "\n";  
            }
            
            if($settings->hideWPMenu && !current_user_can('manage_options')){
                $output .= '#adminmenumain {';
                $output .= ' display: none !important;';
                $output .= '}';
                $output .= "\n";      
                $output .= '#osdb_bootstraped.wos-backendContainer {';
                $output .= ' left: 0px !important;';
                $output .= '}';
                $output .= "\n";     
            }
            if(!$settings->usersCanEditShortcut && !current_user_can('manage_options')){
                $output .= '#osdb_bootstraped .wos-shortcut .wos_editShortcutIcon{';
                $output .= ' display: none !important;';
                $output .= '}';
                $output .= "\n";   
                $output .= '#osdb_bootstraped #wos-shortcut-trash{';
                $output .= ' display: none !important;';
                $output .= '}';
                $output .= "\n";   
            }
            
            $output .= "\n";
            if ($output != '') {
                $output = "\n<style id=\"wos_styles\" >\n" . $output . "</style>\n";
                echo $output;
            }
        
    }
    
    /*
    * Load admin styles
    */
    function admin_styles()
    {        
        $url = '';
       if(isset($_SERVER['HTTP_REFERER'])){
        $url = $_SERVER['HTTP_REFERER'];           
       }
       $settings = $this->getSettings();
       if($settings->enableWOS && $this->checkRolesRight() && !is_network_admin()){         
            if(isset($_GET['wos-reload']) || $settings->firstStart){   
            wp_register_style($this->parent->_token . '-jqueryui', esc_url($this->parent->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-jqueryui');
            wp_register_style($this->parent->_token . '-bootstrap', esc_url($this->parent->assets_url) . 'css/bootstrap.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-bootstrap');            
            wp_register_style($this->parent->_token . '-fontawesome', esc_url($this->parent->assets_url) . 'css/font-awesome.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-fontawesome');            
            wp_register_style($this->parent->_token . '-flat-ui', esc_url($this->parent->assets_url) . 'css/flat-ui-pro.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-flat-ui');      
            wp_register_style($this->parent->_token . '-osBackend', esc_url($this->parent->assets_url) . 'css/osBackend.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-osBackend'); 
            } else if(!isset($_GET['wos-reload'])) {
                wp_register_style($this->parent->_token . '-osBackendView', esc_url($this->parent->assets_url) . 'css/osBackendView.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '-osBackendView');      
                if (isset($_GET['page']) && strpos($_GET['page'], 'wos_menu') !== false) {
                    wp_register_style($this->parent->_token . '-jqueryui', esc_url($this->parent->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '-jqueryui');
                    wp_register_style($this->parent->_token . '-colpick', esc_url($this->parent->assets_url) . 'css/colpick.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '-colpick');
                    wp_register_style($this->parent->_token . '-bootstrap', esc_url($this->parent->assets_url) . 'css/bootstrap.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '-bootstrap');
                    wp_register_style($this->parent->_token . '-flat-ui', esc_url($this->parent->assets_url) . 'css/flat-ui-pro.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '-flat-ui');     
                    wp_register_style($this->parent->_token . '-osBackendSettings', esc_url($this->parent->assets_url) . 'css/osBackendSettings.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '-osBackendSettings');         
                }
            }
        } else if(!is_network_admin()){
            if (isset($_GET['page']) && strpos($_GET['page'], 'wos_menu') !== false) {
            wp_register_style($this->parent->_token . '-jqueryui', esc_url($this->parent->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-jqueryui');
            wp_register_style($this->parent->_token . '-colpick', esc_url($this->parent->assets_url) . 'css/colpick.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-colpick');
            wp_register_style($this->parent->_token . '-bootstrap', esc_url($this->parent->assets_url) . 'css/bootstrap.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-bootstrap');
            wp_register_style($this->parent->_token . '-flat-ui', esc_url($this->parent->assets_url) . 'css/flat-ui-pro.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-flat-ui');     
            wp_register_style($this->parent->_token . '-osBackendSettings', esc_url($this->parent->assets_url) . 'css/osBackendSettings.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-osBackendSettings');         
        }
        }
        
    }

    /*
     * Load admin scripts
     */
    function admin_scripts()
    {       
        global $wpdb;
       $url = '';
       if(isset($_SERVER['HTTP_REFERER'])){
        $url = $_SERVER['HTTP_REFERER'];           
       }
       $settings = $this->getSettings();
       if($settings->enableWOS && $this->checkRolesRight()&& !is_network_admin()){            
            if(isset($_GET['wos-reload']) || $settings->firstStart){   
                wp_register_script($this->parent->_token . '-flatui', esc_url($this->parent->assets_url) . 'js/flat-ui-pro.min.js', array('jquery',
                    'jquery-ui-core',
                    'jquery-ui-mouse',
                    'jquery-ui-position',
                    'jquery-ui-droppable',
                    'jquery-ui-draggable',
                    'jquery-ui-resizable',
                    'jquery-effects-core',
                    'jquery-effects-drop',
                    'jquery-effects-fade',
                    'jquery-effects-bounce'), $this->parent->_version);
                wp_enqueue_script($this->parent->_token . '-flatui');    
                wp_register_script($this->parent->_token . '-mousetrap', esc_url($this->parent->assets_url) . 'js/mousetrap.min.js', array('jquery'));
                wp_enqueue_script($this->parent->_token . '-mousetrap');   
                wp_register_script($this->parent->_token . '-osBackend', esc_url($this->parent->assets_url) . 'js/osBackend.min.js', $this->parent->_token . '-flatui', $this->parent->_version);
                wp_enqueue_script($this->parent->_token . '-osBackend'); 
                                
                
                $userID = get_current_user_id();   
                $canEditShortcuts = $settings->usersCanEditShortcut;
                if(current_user_can('manage_options')){  
                    $canEditShortcuts = true;
                }
                
                $table_name = $wpdb->prefix . "wos_shortcuts";
                $links = $wpdb->get_results("SELECT * FROM $table_name WHERE userID=$userID");
                $js_data[] = array(
                    'links'=>$links,
                    'canEditShortcuts'=>$canEditShortcuts,
                    'texts' => array(
                            'Save' => __('Save', 'wos'),
                            'Title' => __('Title', 'wos'),
                            'EditShortcut' => __('Edit a shortcut', 'wos'),
                            'Icon' => __('Icon', 'wos'),
                            'SelectIcon' => __('Select an icon', 'wos')
                        ),
                    'key_nextWin_1'=>$settings->key_nextWin_1,
                    'key_nextWin_2'=>$settings->key_nextWin_2,
                    'key_prevWin_1'=>$settings->key_prevWin_1,
                    'key_prevWin_2'=>$settings->key_prevWin_2,
                    'key_prevWin_3'=>$settings->key_prevWin_3
                );
                wp_localize_script($this->parent->_token . '-osBackend', 'wos_data', $js_data);
                $table_name = $wpdb->prefix . "wos_settings";
                $wpdb->update($table_name, array('firstStart'=>0), array('id' => 1));
            }else if(!isset($_GET['wos-reload'])&& !is_network_admin()){
                wp_register_script($this->parent->_token . '-mousetrap', esc_url($this->parent->assets_url) . 'js/mousetrap.min.js', array('jquery'));
                wp_enqueue_script($this->parent->_token . '-mousetrap');   
                wp_register_script($this->parent->_token . '-osBackendView', esc_url($this->parent->assets_url) . 'js/osBackendView.min.js', array(), $this->parent->_version);
                wp_enqueue_script($this->parent->_token . '-osBackendView');  
                
                $loadPageBackend = 0;
                if(isset($_SESSION['wos_loadPageBackend']) && $_SESSION['wos_loadPageBackend']  == 1){
                    $_SESSION['wos_loadPageBackend'] = '';    
                    $loadPageBackend = 1;
                }
                wp_localize_script($this->parent->_token . '-osBackendView', 'wos_data',array('loadPageBackend'=>$loadPageBackend,
                    'key_nextWin_1'=>$settings->key_nextWin_1,
                    'key_nextWin_2'=>$settings->key_nextWin_2,
                    'key_prevWin_1'=>$settings->key_prevWin_1,
                    'key_prevWin_2'=>$settings->key_prevWin_2,
                    'key_prevWin_3'=>$settings->key_prevWin_3));
                
                if (isset($_GET['page']) && strpos($_GET['page'], 'wos_menu') !== false) { 
                     wp_register_script($this->parent->_token . '-colpick', esc_url($this->parent->assets_url) . 'js/colpick.min.js', array('jquery'), $this->parent->_version);
                    wp_enqueue_script($this->parent->_token . '-colpick');   
                    wp_register_script($this->parent->_token . '-flatui', esc_url($this->parent->assets_url) . 'js/flat-ui-pro.min.js', array('jquery'), $this->parent->_version);
                    wp_enqueue_script($this->parent->_token . '-flatui');   
                    wp_register_script($this->parent->_token . '-osBackendSettings', esc_url($this->parent->assets_url) . 'js/osBackendSettings.min.js', array(), $this->parent->_version);
                            
                     $js_data[] = array(
                        'assetsUrl' => esc_url($this->parent->assets_url),
                        'texts' => array(
                            'Yes' => __('Yes', 'wos'),
                            'No' => __('No', 'wos')
                        ),
                        'loadPageBackend'=>$loadPageBackend
                    );
                     
                    wp_localize_script($this->parent->_token . '-osBackendSettings', 'wos_data', $js_data);
                     wp_enqueue_script($this->parent->_token . '-osBackendSettings'); 
                }

            }
       } else if(!is_network_admin()){
           if (isset($_GET['page']) && strpos($_GET['page'], 'wos_menu') !== false) { 
                     wp_register_script($this->parent->_token . '-colpick', esc_url($this->parent->assets_url) . 'js/colpick.min.js', array('jquery'), $this->parent->_version);
                    wp_enqueue_script($this->parent->_token . '-colpick');   
                    wp_register_script($this->parent->_token . '-flatui', esc_url($this->parent->assets_url) . 'js/flat-ui-pro.min.js', array('jquery'), $this->parent->_version);
                    wp_enqueue_script($this->parent->_token . '-flatui');   
                    wp_register_script($this->parent->_token . '-osBackendSettings', esc_url($this->parent->assets_url) . 'js/osBackendSettings.min.js', array(), $this->parent->_version);

                     $js_data[] = array(
                        'assetsUrl' => esc_url($this->parent->assets_url),
                        'texts' => array(
                            'Yes' => __('Yes', 'wos'),
                            'No' => __('No', 'wos')
                        )
                    );
                    wp_localize_script($this->parent->_token . '-osBackendSettings', 'wos_data', $js_data);
                     wp_enqueue_script($this->parent->_token . '-osBackendSettings'); 
                }
       }
    }
    
    private function checkRolesRight(){
        $settings = $this->getSettings();
        $chkOK = false;        
        if($settings->rolesAllowed == "" ){
            $chkOK = true;    
        } else {
            $rolesAllowed = explode(',', $settings->rolesAllowed );
            if ( is_user_logged_in() ) {
                $user = new WP_User(get_current_user_id());
                if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
                    foreach ( $user->roles as $role ) {
                        if(in_array($role, $rolesAllowed)){
                            $chkOK = true;
                        }
                    }
                }
            }
        }
        return  $chkOK ;
    }

    public function saveShortcut(){
        global $wpdb;
        
        if(is_user_logged_in()){   
            $url = sanitize_text_field($_POST['url']);
            $posX = sanitize_text_field($_POST['posX']);
            $posY = sanitize_text_field($_POST['posY']);
            $userID = get_current_user_id();        
            $html = ($_POST['html']);
            echo $html;

            $table_name = $wpdb->prefix . "wos_shortcuts";
            $existingLinks = $wpdb->get_results("SELECT * FROM $table_name WHERE url='$url' AND userID=$userID LIMIT 1");
            if(count($existingLinks)>0){
                $existingLink = $existingLinks[0];
                if(isset($_POST['html']) && $_POST['html'] != ""){
                    $wpdb->update($table_name, array('posX'=>$posX,'posY'=>$posY,'html'=>$html), array('id' => $existingLink->id));                     
                }else{
                    $wpdb->update($table_name, array('posX'=>$posX,'posY'=>$posY), array('id' => $existingLink->id));                     
                }           
            } else {
                $wpdb->insert($table_name, array('userID'=>$userID,'url'=>$url,'html'=>$html,'posX'=>$posX,'posY'=>$posY));                   
            }
        }
        die();        
    }
    public function deleteShortcut(){
        global $wpdb;
        if(is_user_logged_in()){   
            $url = sanitize_text_field($_POST['url']);
            $userID = get_current_user_id();

            $table_name = $wpdb->prefix . "wos_shortcuts";
            $wpdb->delete($table_name, array('url'=>$url,'userID'=>$userID));
        }
        die();
    }
    public function saveSettings(){
        global $wpdb;
        $settings = $this->getSettings();
        $currentCode = $settings->purchaseCode;
        if(current_user_can('manage_options')){   
            $table_name = $wpdb->prefix . "wos_settings";
            $sqlDatas = array();
            foreach ($_POST as $key => $value) {
                if ($key != 'action' && $key != 'id' && $key != 'pll_ajax_backend'&& $key != "undefined" && $key != "files") {                
                    $sqlDatas[$key] = (stripslashes($value));
                }
            }
            $wpdb->update($table_name, $sqlDatas, array('id' => 1));
        }
        if(isset($_POST['purchaseCode']) && $currentCode != $_POST['purchaseCode'] && $_POST['purchaseCode'] != "") {
             try {
                $url = 'http://www.loopus-plugins.com/updates/update.php?checkCode=15804874&code=' . sanitize_text_field($_POST['purchaseCode']);
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $rep = curl_exec($ch);
                if ($rep != '0410') {
                  $table_name = $wpdb->prefix . "wos_settings";
                  $wpdb->update($table_name, array('purchaseCode' => sanitize_text_field($_POST['purchaseCode'])), array('id' => 1));
                } else {
                    
                  $table_name = $wpdb->prefix . "wos_settings";
                  $wpdb->update($table_name, array('purchaseCode' =>""), array('id' => 1));
                  echo '1';
                }
            } catch (Exception $e) {
                $table_name = $wpdb->prefix . "wos_settings";
                $wpdb->update($table_name, array('purchaseCode' => sanitize_text_field($_POST['purchaseCode'])), array('id' => 1));
            }            
        }
        die();    
    }
   
    public function view_settings_wos(){
        wp_enqueue_style('thickbox');
        wp_enqueue_script('thickbox');
        
        echo '<h1 style="margin-bottom: 28px;">'.__('WP OS Desktop Backend Settings','wos').'</h1>';  
        echo '<div id="osdb_bootstraped">';
        echo '<div id="wos_settings">';        
        echo '<div class="col-sm-4 col-xs-6">';
       
         echo '<div class="form-group">'
        .       '<label>'.__('Enable WP OS Backend ?','wos').'</label>'
        .       '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="enableWOS"/>'
        .    '</div>';// eof .form-group
        echo '<div class="form-group">'
        .       '<label>'.__('Gray effect on windows in background','wos').'</label>'
        .       '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="fxWinGray"/>'
        .    '</div>';// eof .form-group
        echo '<div class="form-group">'
        .       '<label>'.__('Blur effect on windows in background','wos').'</label>'
        .       '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="fxWinBlur"/>'
        .    '</div>';// eof .form-group
        echo '<div class="form-group">'
        .       '<label>'.__('Dark effect on windows in background','wos').'</label>'
        .       '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="fxWinDark"/>'
        .    '</div>';// eof .form-group
        echo '<div class="form-group">'
        .       '<label>'.__('Hide WP menu for non-admin users','wos').'</label>'
        .       '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="hideWPMenu"/>'
        .    '</div>';// eof .form-group
        echo '<div class="form-group">'
        .       '<label>'.__('Allow non-admins to edit shortcuts','wos').'</label>'
        .       '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="usersCanEditShortcut"/>'
        .    '</div>';// eof .form-group
                
        
        echo '</div>'; // eof .col-sm-4
        
         echo '<div class="col-sm-4 col-xs-6">';
      
           echo '<div class="form-group">';
        echo '<label>'.__('Purchase Code','wos').'</label>';
        echo '<input class="form-control" name="purchaseCode"/>
             <br/>
            <span style="font-size:12px;"><a href="'.$this->parent->assets_url.'img/purchaseCode.gif" target="_blank">' . __('Where I can find my purchase code ?', 'wos') . '</a></span>';             
        echo '</div>'; // eof .form-group
         echo '<div class="form-group">';
        echo '<label>'.__('Background image','wos').'</label>';
        echo '<input class="form-control" name="backgroundImage" style="margin-right: 6px;display: inline-block;" />'
             . '<a class="btn btn-default imageBtn" style=" display: inline-block; margin-top: 4px; margin-bottom: 4px;">' . __('Upload Image', 'wos') . '</a>';             
        echo '</div>'; // eof .form-group
        echo '<div class="form-group">'
        .       '<label>'.__('Keyboard shortcut to show next window','wos').'</label>'
        .       '<select name="key_nextWin_1"  class="form-control" >';                   
            echo '<option value="shift">Shift</option>';               
            echo '<option value="ctrl">Control</option>';               
            echo '<option value="alt">Alt</option>';               
            echo '<option value="end">End</option>';          
            echo '<option value="home">Home</option>';        
        echo    '</select> + '
            .  '<select name="key_nextWin_2"  class="form-control" >';                   
            echo '<option value="a">a</option>';               
            echo '<option value="b">b</option>';               
            echo '<option value="c">c</option>';               
            echo '<option value="d">d</option>';          
            echo '<option value="e">e</option>';        
            echo '<option value="f">f</option>';         
            echo '<option value="g">g</option>';         
            echo '<option value="h">h</option>';         
            echo '<option value="i">i</option>';         
            echo '<option value="j">j</option>';         
            echo '<option value="k">k</option>';         
            echo '<option value="l">l</option>';         
            echo '<option value="m">m</option>';         
            echo '<option value="n">n</option>';         
            echo '<option value="o">o</option>';         
            echo '<option value="p">p</option>';         
            echo '<option value="q">q</option>';         
            echo '<option value="r">r</option>';         
            echo '<option value="s">s</option>';         
            echo '<option value="t">t</option>';         
            echo '<option value="u">u</option>';         
            echo '<option value="v">v</option>';         
            echo '<option value="w">w</option>';         
            echo '<option value="x">x</option>';         
            echo '<option value="y">y</option>';         
            echo '<option value="z">z</option>';         
            echo '<option value="1">1</option>';         
            echo '<option value="2">2</option>';         
            echo '<option value="3">3</option>';         
            echo '<option value="4">4</option>';         
            echo '<option value="5">5</option>';         
            echo '<option value="6">6</option>';         
            echo '<option value="7">7</option>';         
            echo '<option value="8">8</option>';         
            echo '<option value="9">9</option>';         
            echo '<option value="0">0</option>';         
        echo    '</select>'
        .    '</div>';// eof .form-group
        
        echo '<div class="form-group">'
        .       '<label>'.__('Keyboard shortcut to show next window','wos').'</label>'
        .       '<select name="key_prevWin_1"  class="form-control" >';                   
            echo '<option value="shift">Shift</option>';               
            echo '<option value="ctrl">Control</option>';               
            echo '<option value="alt">Alt</option>';               
            echo '<option value="end">End</option>';          
            echo '<option value="home">Home</option>';        
        echo    '</select> + '
            .       '<select name="key_prevWin_2"  class="form-control" >';                   
            echo '<option value="shift">Shift</option>';               
            echo '<option value="ctrl">Control</option>';               
            echo '<option value="alt">Alt</option>';               
            echo '<option value="end">End</option>';          
            echo '<option value="home">Home</option>';        
        echo    '</select> + '
            .  '<select name="key_prevWin_3"  class="form-control" >';                   
            echo '<option value="a">a</option>';               
            echo '<option value="b">b</option>';               
            echo '<option value="c">c</option>';               
            echo '<option value="d">d</option>';          
            echo '<option value="e">e</option>';        
            echo '<option value="f">f</option>';         
            echo '<option value="g">g</option>';         
            echo '<option value="h">h</option>';         
            echo '<option value="i">i</option>';         
            echo '<option value="j">j</option>';         
            echo '<option value="k">k</option>';         
            echo '<option value="l">l</option>';         
            echo '<option value="m">m</option>';         
            echo '<option value="n">n</option>';         
            echo '<option value="o">o</option>';         
            echo '<option value="p">p</option>';         
            echo '<option value="q">q</option>';         
            echo '<option value="r">r</option>';         
            echo '<option value="s">s</option>';         
            echo '<option value="t">t</option>';         
            echo '<option value="u">u</option>';         
            echo '<option value="v">v</option>';         
            echo '<option value="w">w</option>';         
            echo '<option value="x">x</option>';         
            echo '<option value="y">y</option>';         
            echo '<option value="z">z</option>';         
            echo '<option value="1">1</option>';         
            echo '<option value="2">2</option>';         
            echo '<option value="3">3</option>';         
            echo '<option value="4">4</option>';         
            echo '<option value="5">5</option>';         
            echo '<option value="6">6</option>';         
            echo '<option value="7">7</option>';         
            echo '<option value="8">8</option>';         
            echo '<option value="9">9</option>';         
            echo '<option value="0">0</option>';         
        echo    '</select>'
        .    '</div>';// eof .form-group
        
        echo '<div class="form-group">'
        .       '<label>'.__('','wos').'</label>'
        .       '<select name="rolesAllowed"  class="form-control" multiple >';
          global $wp_roles;
        foreach ($wp_roles->roles as $role) {            
            echo '<option value="'.strtolower($role['name']).'" >'.$role['name'].'</option>';
        }
        echo    '</select>'
        .    '</div>';// eof .form-group
             
        echo '</div>'; // eof .col-sm-4
        
         echo '<div class="col-sm-4 col-xs-6">';
         
           echo '<div class="form-group">';
        echo '<label>'.__('Background color of windows','wos').'</label>';
        echo '<input class="form-control wos_colorpicker" name="colorWinHeaderBg" />';        
        echo '</div>'; // eof .form-group
        echo '<div class="form-group">';
        echo '<label>'.__('Text color of windows header','wos').'</label>';
        echo '<input class="form-control wos_colorpicker" name="colorWinHeader" />';        
        echo '</div>'; // eof .form-group
        echo '<div class="form-group">';
        echo '<label>'.__('Background color of windows icons','wos').'</label>';
        echo '<input class="form-control wos_colorpicker" name="colorWinIconsBg" />';        
        echo '</div>'; // eof .form-group
        echo '<div class="form-group">';
        echo '<label>'.__('Background color of activated windows icons','wos').'</label>';
        echo '<input class="form-control wos_colorpicker" name="colorWinIconsSelected" />';        
        echo '</div>'; // eof .form-group
          echo '<div class="form-group">';
        echo '<label>'.__('Default color of windows icons','wos').'</label>';
        echo '<input class="form-control wos_colorpicker" name="colorWinIcons" />';        
        echo '</div>'; // eof .form-group
        echo '<div class="form-group">';
        echo '<label>'.__('Color of shortcuts','wos').'</label>';
        echo '<input class="form-control wos_colorpicker" name="colorShortcuts" />';        
        echo '</div>'; // eof .form-group
        
        
        
        echo '</div>'; // eof .col-sm-4
         
        echo '<div class="clearfix"></div>';
        
        
        
        
        echo '<p style="text-align: center; margin-top: 18px;">'
            . ' <a href="javascript:"  onclick="wos_saveSettings();" class="btn btn-primary"><span class="glyphicon glyphicon-floppy-disk"></span>'.__('Save','wos').'</a>'
            . ' <a href="javascript:"  onclick="wos_resetColors();" class="btn btn-warning"><span class="glyphicon glyphicon-floppy-diskglyphicon glyphicon-refresh"></span>'.__('Reset colors','wos').'</a>'
            . '</p>';
          
        echo '</div>'; // eof #wos_settings
        echo '</div>'; // eof #osdb_bootstraped
    }
   
     /**
     * Main Instance
     *
     *
     * @since 1.0.0
     * @static
     * @return Main instance
     */
    public static function instance($parent)
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self($parent);
        }
        return self::$_instance;
    }

    // End instance()

    /**
     * Cloning is forbidden.
     *
     * @since 1.0.0
     */
    public function __clone()
    {
        _doing_it_wrong(__FUNCTION__, __(''), $this->parent->_version);
    }
// End __clone()

    /**
     * Unserializing instances of this class is forbidden.
     *
     * @since 1.0.0
     */
    public function __wakeup()
    {
        _doing_it_wrong(__FUNCTION__, __(''), $this->parent->_version);
    }

// End __wakeup()
}
