<?php

/*
 * Plugin Name: WP OS Backend Desktop
 * Version: 1.137
 * Plugin URI: http://persianscript.ir
 * Description: This plugin gives a beautiful OS desktop style to your WP Backend
 * Author: پرشین اسکریپت
 * Author URI: http://persianscript.ir
 * Requires at least: 3.8
 * Tested up to: 4.4.2
 *
 * @package WordPress
 * @author Biscay Charly (loopus)
 * @since 1.0.0
 */

if (!defined('ABSPATH'))
    exit;

register_activation_hook(__FILE__, 'wos_install');
register_uninstall_hook(__FILE__, 'wos_uninstall');

global $jal_db_version;
$jal_db_version = "1.1";

require_once('includes/wos-core.php');
require_once('includes/wos-admin.php');

function WP_osBackendDesktop() {
    $version = 1.137;
    wos_checkDBUpdates($version);
    $instance = WOS_Core::instance(__FILE__, $version);
    if (is_null($instance->menu)) {
        $instance->menu = WOS_admin::instance($instance);
    }
    return $instance;
}

/**
 * Installation. Runs on activation.
 * @access  public
 * @since   1.0.0
 * @return  void
 */
function wos_install() {
    global $wpdb;
    global $jal_db_version;
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
    add_option("jal_db_version", $jal_db_version);

    $db_table_name = $wpdb->prefix . "wos_settings";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		purchaseCode VARCHAR(250) NOT NULL,      
    		colorWinHeader VARCHAR(16) NOT NULL DEFAULT '#ecf0f1',       
    		colorWinHeaderBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c',     
    		colorWinIconsBg VARCHAR(16) NOT NULL DEFAULT '#ecf0f1',     
    		colorWinIcons VARCHAR(16) NOT NULL DEFAULT '#95a5a6',    
    		colorWinIconsSelected VARCHAR(16) NOT NULL DEFAULT '#95a5a6',     
    		colorWPMenuLinks VARCHAR(16) NOT NULL DEFAULT '#1cccaa',         
    		colorWPMenuBadges VARCHAR(16) NOT NULL DEFAULT '#e74c3c',      
    		colorShortcuts VARCHAR(16) NOT NULL DEFAULT '#ecf0f1',         
    		enableWOS BOOL NOT NULL DEFAULT 1,     
    		fxWinGray BOOL NOT NULL DEFAULT 1,      
    		fxWinBlur BOOL NOT NULL DEFAULT 1,      
    		fxWinDark BOOL NOT NULL DEFAULT 1,          
                applyColorsWP BOOL NOT NULL DEFAULT 1,
                firstStart BOOL NOT NULL DEFAULT 1,
                backgroundImage VARCHAR(250) NOT NULL,
                hideWPMenu BOOL NOT NULL,           
                rolesAllowed TEXT NOT NULL,
                usersCanEditShortcut BOOL NOT NULL DEFAULT 1, 
                key_nextWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt', 
                key_nextWin_2 VARCHAR(4) NOT NULL DEFAULT 's',
                key_prevWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt', 
                key_prevWin_2 VARCHAR(16) NOT NULL DEFAULT 'shift',
                key_prevWin_3 VARCHAR(4) NOT NULL DEFAULT 's',
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);
        $rows_affected = $wpdb->insert($db_table_name, array('purchaseCode' => '',
            'colorWinHeader'=>'#ecf0f1',
            'colorWinHeaderBg'=>'#1cccaa',
            'colorWinIconsBg'=>'#ecf0f1',
            'colorWinIcons'=>'#95a5a6',
            'colorWinIconsSelected'=>'#95a5a6',
            'colorWPMenuLinks'=>'#1cccaa',
            'colorWPMenuBadges'=>'#1cccaa',
            'colorShortcuts'=>'#ecf0f1',
            'usersCanEditShortcut'=>1,
            'key_nextWin_1'=>'alt',
            'key_nextWin_2'=>'s',
            'key_prevWin_1'=>'alt',
            'key_prevWin_2'=>'shift',
            'key_prevWin_3'=>'s')
            );
    }
    
    $db_table_name = $wpdb->prefix . "wos_shortcuts";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		userID mediumint(9) NOT NULL,      
    		posX  mediumint(9) NOT NULL,    
    		posY  mediumint(9) NOT NULL,  
                url VARCHAR(250) NOT NULL,
                html TEXT NOT NULL,
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);
    }

    global $isInstalled;
    $isInstalled = true;
    wp_redirect("wp-admin/admin.php?page=wos_menu&wos-reload=1");
}
// End install()

/**
 * Update database
 * @access  public
 * @since   2.0
 * @return  void
 */
function wos_checkDBUpdates($version) {
    global $wpdb;
    $installed_ver = get_option("wos_version");
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
    
    if (!$installed_ver || $installed_ver < 1.1) {      
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD hideWPMenu BOOL NOT NULL;";
        $wpdb->query($sql);            
    }
    
    if (!$installed_ver || $installed_ver < 1.12) {      
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD rolesAllowed TEXT NOT NULL;";
        $wpdb->query($sql);            
    }    
    if (!$installed_ver || $installed_ver < 1.132) {      
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD usersCanEditShortcut BOOL NOT NULL DEFAULT 1;";
        $wpdb->query($sql);            
        $wpdb->update($table_name, array('usersCanEditShortcut'=>1), array('id' => 1));
        
    }                
            
    if (!$installed_ver || $installed_ver < 1.137) {     
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD key_nextWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_nextWin_2 VARCHAR(4) NOT NULL DEFAULT 's';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_prevWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_prevWin_2 VARCHAR(16) NOT NULL DEFAULT 'shift';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_prevWin_3 VARCHAR(4) NOT NULL DEFAULT 's';";
        $wpdb->query($sql);            
        
    }    
    
    
    update_option("wos_version", $version);
}

/**
 * Uninstallation.
 * @access  public
 * @since   1.0.0
 * @return  void
 */
function wos_uninstall() {

    global $wpdb;
    global $jal_db_version;
    $table_name = $wpdb->prefix . "wos_settings";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    $table_name = $wpdb->prefix . "wos_shortcuts";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
}
// End uninstall()

WP_osBackendDesktop();