<?php
if ( ! defined ( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

if ( ! class_exists ( "WC_Email" ) ) {
    require_once ( WC ()->plugin_path () . '/includes/emails/class-wc-email.php' );
}

if ( ! class_exists ( "YWAU_Order_File_Response" ) ) {
    /**
     * A custom Order Email class
     *
     * @since 0.1
     * @extends \YWAU_Order_Admin_Message
     */
    class YWAU_Order_File_Response extends YWAU_Order_Admin_Message {

        /**
         * Set email defaults
         *
         * @since 0.1
         */
        public function __construct () {
            parent::__construct ();
            $this->email_type = 'file_status_update';
        }

        /**
         * Determine if the email should actually be sent and setup email merge variables
         *
         * @since 0.1
         *
         * @param int $order_id
         */
        public function trigger ( $order_id ) {
            // bail if no order ID is present
            if ( ! $order_id ) {
                return;
            }

            // setup order object
            $this->object = wc_get_order ( $order_id );

            // woohoo, send the email!
            $result = $this->send ( $this->get_recipient (), $this->get_subject (), $this->get_content (), $this->get_headers (), $this->get_attachments () );

            return $result;
        }
    } // end \YWAU_Order_File_Response class
}

return new YWAU_Order_File_Response();
