/**
 * @author: Sharif Zamani
 * @copyright: PersianScript
 */

var RenderManager = function()
{
    this.canvas = document.getElementById("screen");
    this.context2D = this.canvas.getContext("2d");
}



var blobby1Img = new Array(5);
var blobby2Img = new Array(5);
for(var i = 0; i < 5; i++)
{
	blobby1Img[i] = new Image();
	blobby2Img[i] = new Image();
	blobby1Img[i].src = "data/img/" + i + "b.png";
	blobby2Img[i].src = "data/img/" + i + "r.png";
}


var fontImg = new Array(11);
for(var i = 0; i < 11; i++)
{
	fontImg[i] = new Image();
	fontImg[i].src = "data/img/f" + i + ".png";
}

var backgroundImg = new Image();
backgroundImg.src = "data/img/strand1.png";

var ballImg = new Image();
ballImg.src = "data/img/ball01.png";

var pokalImg = new Image();
pokalImg.src = "data/img/pokal.png";

var titleImg = new Image();
titleImg.src = "data/img/titel.png";

function drawMenu()
{
	var canvas = document.getElementById("screen");
	canvas = canvas.getContext("2d");
	canvas.fillStyle = "rgb(0, 0, 0)";
	canvas.fillRect(0, 0, 800, 600);
	canvas.globalAlpha = 0.2;
	canvas.drawImage(backgroundImg, 0, 0);
	canvas.globalAlpha = 1;
	canvas.drawImage(titleImg, 20, 80);
}

function drawWin()
{
	this.drawMenu();
	canvas.drawImage(pokalImg, 30, 200);
}

function drawGame()
{
	canvas = renderManager.context2D;
	canvas.drawImage(backgroundImg , 0, 0);
	canvas.fillRect(ballPosition.x - 2, 5, 5, 5);
	canvas.drawImage(ballImg, ballPosition.x - BALL_RADIUS, ballPosition.y - BALL_RADIUS);
	canvas.drawImage(
		blobby1Img[Math.round(blobState[LEFT_PLAYER])],
		blobPosition[LEFT_PLAYER].x - BLOBBY_WIDTH / 2,
		blobPosition[LEFT_PLAYER].y - BLOBBY_HEIGHT / 2);

	canvas.drawImage(
		blobby2Img[Math.round(blobState[RIGHT_PLAYER])],
		blobPosition[RIGHT_PLAYER].x - BLOBBY_WIDTH / 2,
		blobPosition[RIGHT_PLAYER].y - BLOBBY_HEIGHT / 2);

	canvas.fillStyle = "rgb(255, 255, 255)";

	if(rightScore > 9) {
	    canvas.drawImage(fontImg[1], 724, 20);
	    canvas.drawImage(fontImg[rightScore - 10], 748, 20);
	} else {
	    canvas.drawImage(fontImg[0], 724, 20);
            canvas.drawImage(fontImg[rightScore], 748, 20);
        }

	if(leftScore > 9)
	{
		canvas.drawImage(fontImg[1], 44, 20);
		canvas.drawImage(fontImg[leftScore - 10], 68, 20);
	} else 		{
		canvas.drawImage(fontImg[0], 44, 20);
		canvas.drawImage(fontImg[leftScore], 68, 20);
	}


	if(servingPlayer == RIGHT_PLAYER)
		canvas.drawImage(fontImg[10], 700, 20);
	else if(servingPlayer == LEFT_PLAYER)
		canvas.drawImage(fontImg[10], 20, 20);
}
