/**
 * @author: Sharif Zamani
 * @copyright: PersianScript
 *
 * @file
 */

/**
 * @class 
 * 
 * 
 */
var Soundfile = function(filePath, maxChannels)
{
    /*
     * 
     */
    this.play = function()
    {
        this.channels[this.channelcounter].play();
        this.channelcounter = (this.channelcounter + 1) % this.maxChannels;
    }

    /**
     * @constructor
     *
     * 
     * 
     *
     * @params 
     * @params 
     */
    this.channelcounter = 0;
    this.maxChannels = maxChannels;
    this.filePath = filePath;
    this.channels = new Array();

    for(i = 0; i < maxChannels; i++)
    {
	this.channels[i] = new Audio();
	this.channels[i].src = filePath;
	this.channels[i].load();
    }
}

/**
 * @class 
 * 
 * 
 */
var SoundManager = function() {
    /**
    * 
    *
    * @param 
    * @param 
    * @param 
    */
    this.loadSound = function(identifier, filePath, channels) {
	this.buffer[identifier] = new Soundfile(filePath, channels);
    };

    /**
    * 
    *
    * @param 
    */
    this.playSound = function(identifier) {
	if(!this.mute) {
	    this.buffer[identifier].play();
        }
    };

    /**
    * 
    *
    * @param 
    */
    this.muteSound = function(mute) {
	this.mute = mute;
    };

    /**
    * 
    *
    * @returns 
    */
    this.isSoundMuted = function() {
	return this.mute;
    };

    /**
     * @constructor
     *
     * 
     */
    this.buffer = new Array();
    this.mute = false;

    this.loadSound('whistle', 'data/snd/whistle.ogg', 3);
    this.loadSound('touch', 'data/snd/touch.ogg', 6);
};
